/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.h3;

import com.uber.h3core.H3Core;
import com.uber.h3core.util.GeoCoord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.store.EmptyIterator;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.dggs.h3.H3Index;
import org.geotools.dggs.h3.H3ParentIterator;
import org.geotools.dggs.h3.H3Zone;
import org.geotools.dggs.h3.H3ZoneIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.predicate.RectangleContains;
import org.locationtech.jts.operation.predicate.RectangleIntersects;

public class H3DGGSInstance
implements DGGSInstance {
    final H3Core h3;
    final GeometryFactory gf = new GeometryFactory((CoordinateSequenceFactory)new LiteCoordinateSequenceFactory());
    final Set<Long> northPoleZones;
    final Set<Long> southPoleZones;

    public H3DGGSInstance(H3Core h3) {
        this.h3 = h3;
        int[] resolutions = this.getResolutions();
        this.northPoleZones = Arrays.stream(resolutions).mapToObj(r -> this.getZone((double)90.0, (double)0.0, (int)r).id).collect(Collectors.toSet());
        this.southPoleZones = Arrays.stream(resolutions).mapToObj(r -> this.getZone((double)-90.0, (double)0.0, (int)r).id).collect(Collectors.toSet());
    }

    @Override
    public String getIdentifier() {
        return "H3";
    }

    @Override
    public void close() {
    }

    @Override
    public int[] getResolutions() {
        int[] result = new int[16];
        for (int i = 0; i < result.length; ++i) {
            result[i] = i;
        }
        return result;
    }

    @Override
    public Zone getZone(String id) throws IllegalArgumentException {
        try {
            long lid = this.h3.stringToH3(id);
            return new H3Zone(this, lid);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not build zone from id, is the id valid?", e);
        }
    }

    @Override
    public H3Zone getZone(double lat, double lon, int resolution) {
        long id = this.h3.geoToH3(lat, lon, resolution);
        return new H3Zone(this, id);
    }

    @Override
    public Iterator<Zone> zonesFromEnvelope(Envelope envelope, int targetResolution, boolean compact) {
        Envelope intersection = envelope.intersection((Envelope)WORLD);
        if (intersection.isNull()) {
            return new EmptyIterator();
        }
        if (compact) {
            ArrayList zones = new ArrayList();
            new H3ZoneIterator<Long>(this.h3, id -> {
                int r = this.h3.h3GetResolution(id.longValue());
                return r < targetResolution && this.ringOverlaps((Long)id, envelope) && !this.containedInEnvelope((Long)id, envelope);
            }, id -> {
                int r = this.h3.h3GetResolution(id.longValue());
                return r == targetResolution && this.overlaps((long)id, envelope) || r < targetResolution && this.containedInEnvelope((Long)id, envelope);
            }, id -> id).forEachRemaining(id -> zones.add(id));
            try {
                List compacted = this.h3.compact(zones);
                return compacted.stream().map(id -> new H3Zone(this, (long)id)).iterator();
            }
            catch (IllegalArgumentException e) {
                return zones.stream().map(id -> new H3Zone(this, (long)id)).iterator();
            }
        }
        return new H3ZoneIterator<Zone>(this.h3, id -> this.h3.h3GetResolution(id.longValue()) < targetResolution && (this.ringOverlaps((Long)id, envelope) || this.datelineCrossing((long)id)), id -> this.h3.h3GetResolution(id.longValue()) == targetResolution && this.overlaps((long)id, envelope), id -> new H3Zone(this, (long)id));
    }

    private boolean datelineCrossing(long id) {
        return new H3Zone(this, id).overlapsDateline();
    }

    private boolean ringOverlaps(Long zoneId, Envelope envelope) {
        if (this.overlaps(zoneId, envelope)) {
            return true;
        }
        List ringItems = this.h3.kRing(zoneId.longValue(), 1);
        return ringItems.stream().anyMatch(id -> this.overlaps((Long)id, envelope));
    }

    private boolean overlaps(Long zoneId, Envelope envelope) {
        GeoCoord center = this.h3.h3ToGeo(zoneId.longValue());
        if (envelope.contains(center.lng, center.lat)) {
            return true;
        }
        H3Zone zone = new H3Zone(this, zoneId);
        Polygon polygon = zone.getBoundary();
        return this.boundaryIntersects(envelope, polygon);
    }

    private boolean boundaryIntersects(Envelope envelope, Polygon polygon) {
        if (!polygon.getEnvelopeInternal().intersects(envelope)) {
            return false;
        }
        RectangleIntersects intersects = new RectangleIntersects(JTS.toGeometry((Envelope)envelope));
        return intersects.intersects((Geometry)polygon);
    }

    private boolean ringContained(Long zoneId, Envelope envelope) {
        if (!this.containedInEnvelope(zoneId, envelope)) {
            return false;
        }
        List ringItems = this.h3.kRing(zoneId.longValue(), 1);
        return ringItems.stream().allMatch(id -> this.containedInEnvelope((Long)id, envelope));
    }

    private boolean containedInEnvelope(Long zoneId, Envelope envelope) {
        H3Zone zone = new H3Zone(this, zoneId);
        Polygon polygon = zone.getBoundary();
        if (envelope.contains(polygon.getEnvelopeInternal())) {
            return true;
        }
        RectangleContains contains = new RectangleContains(JTS.toGeometry((Envelope)envelope));
        return contains.contains((Geometry)polygon);
    }

    @Override
    public long countZonesFromEnvelope(Envelope envelope, int resolution) {
        Envelope intersection = envelope.intersection((Envelope)WORLD);
        if (intersection.isNull()) {
            return 0L;
        }
        AtomicLong counter = new AtomicLong();
        H3ZoneIterator<AtomicLong> iterator = new H3ZoneIterator<AtomicLong>(this.h3, id -> this.h3.h3GetResolution(id.longValue()) < resolution && !this.ringContained((long)id, envelope), id -> {
            int currentResolution = this.h3.h3GetResolution(id.longValue());
            if (currentResolution == resolution) {
                if (this.overlaps((Long)id, envelope)) {
                    counter.addAndGet(1L);
                    return true;
                }
            } else if (this.ringContained((Long)id, envelope)) {
                counter.addAndGet(this.childrenCount((Long)id, resolution - currentResolution));
            }
            return false;
        }, id -> counter);
        while (iterator.hasNext()) {
            iterator.next();
        }
        return counter.get();
    }

    private long childrenCount(Long zoneId, int depth) {
        if (!this.h3.h3IsPentagon(zoneId.longValue())) {
            return (long)Math.pow(7.0, depth);
        }
        return this.pentagonCount(depth);
    }

    private long pentagonCount(int depth) {
        if (depth == 0) {
            return 0L;
        }
        return 1L + this.pentagonCount(depth - 1) + 5L * (long)Math.pow(7.0, depth - 1);
    }

    @Override
    public List<AttributeDescriptor> getExtraProperties() {
        ArrayList<AttributeDescriptor> result = new ArrayList<AttributeDescriptor>();
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.setName("shape");
        builder.setBinding(String.class);
        result.add(builder.buildDescriptor("shape"));
        return result;
    }

    @Override
    public Iterator<Zone> neighbors(String id, int radius) {
        long h3Id = this.h3.stringToH3(id);
        return this.h3.kRing(h3Id, radius).stream().filter(zoneId -> h3Id != zoneId).map(zoneId -> new H3Zone(this, (long)zoneId)).iterator();
    }

    @Override
    public Iterator<Zone> children(String zoneId, int resolution) {
        Zone zone = this.getZone(zoneId);
        if (zone.getResolution() >= resolution) {
            return new EmptyIterator();
        }
        return new H3ZoneIterator<Zone>(this.h3, id -> this.h3.h3GetResolution(id.longValue()) < resolution, id -> this.h3.h3GetResolution(id.longValue()) == resolution, id -> new H3Zone(this, (long)id), Arrays.asList(this.h3.stringToH3(zoneId)));
    }

    @Override
    public Iterator<Zone> parents(String zoneId) {
        long id = this.h3.stringToH3(zoneId);
        return new H3ParentIterator(id, this);
    }

    @Override
    public Zone point(Point point, int resolution) {
        long id = this.h3.geoToH3(point.getY(), point.getX(), resolution);
        return new H3Zone(this, id);
    }

    @Override
    public Iterator<Zone> polygon(Polygon polygon, int resolution, boolean compact) {
        List<GeoCoord> shell = this.getGeoCoords(polygon.getExteriorRing());
        List holes = IntStream.range(0, polygon.getNumInteriorRing()).mapToObj(i -> this.getGeoCoords(polygon.getInteriorRingN(i))).collect(Collectors.toList());
        List zones = this.h3.polyfill(shell, holes, resolution);
        if (compact) {
            zones = this.h3.compact((Collection)zones);
        }
        return zones.stream().map(id -> new H3Zone(this, (long)id)).iterator();
    }

    private List<GeoCoord> getGeoCoords(LinearRing ring) {
        return Arrays.stream(ring.getCoordinates()).map(c -> new GeoCoord(c.y, c.x)).collect(Collectors.toList());
    }

    @Override
    public Filter getChildFilter(FilterFactory ff, String zoneId, int resolution, boolean upTo) {
        long id = this.h3.stringToH3(zoneId);
        H3Index idx = new H3Index(id);
        long lowest = idx.lowestIdChild(resolution);
        long highest = idx.highestIdChild(resolution);
        String lowestId = this.h3.h3ToString(lowest);
        String highestId = this.h3.h3ToString(highest);
        PropertyIsBetween matchFilter = ff.between((Expression)ff.property("zoneId"), (Expression)ff.literal((Object)lowestId), (Expression)ff.literal((Object)highestId));
        return matchFilter;
    }
}

