/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.DGGSSetFunctionBase;
import org.geotools.dggs.Zone;

public class NeighborFunction
extends DGGSSetFunctionBase {
    Set<String> zoneIds;
    public static FunctionName NAME = NeighborFunction.functionName((String)"neighbor", (String)"result:Boolean", (String[])new String[]{"testedZoneId:String", "referenceZoneId:String", "distance:Integer", "dggs:org.geotools.dggs.DGGSInstance"});

    public NeighborFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        String testedZoneId = (String)this.getParameterValue(object, 0);
        if (testedZoneId == null) {
            return false;
        }
        return this.matches(testedZoneId, () -> {
            String referenceZoneId = (String)this.getParameterValue(object, 1);
            Integer distance = (Integer)this.getParameterValue(object, 2);
            DGGSInstance dggs = (DGGSInstance)this.getParameterValue(object, 3);
            if (referenceZoneId == null || distance == null || dggs == null) {
                return Collections.emptyIterator();
            }
            return dggs.neighbors(referenceZoneId, distance);
        });
    }

    @Override
    public Iterator<Zone> getMatchedZones() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        Integer distance = (Integer)this.getParameterValue(null, 2);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 3);
        return dggs.neighbors(referenceZoneId, distance);
    }

    @Override
    public long countMatched() {
        if (!this.isStable()) {
            throw new IllegalStateException("Source parameters are not stable");
        }
        String referenceZoneId = (String)this.getParameterValue(null, 1);
        Integer distance = (Integer)this.getParameterValue(null, 2);
        DGGSInstance dggs = (DGGSInstance)this.getParameterValue(null, 3);
        return dggs.countNeighbors(referenceZoneId, distance);
    }
}

