/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.util.Arrays;
import java.util.HashSet;
import java.util.stream.Stream;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.filter.sort.SortOrder;
import org.geotools.dggs.DGGSFilterTransformer;
import org.geotools.dggs.DGGSFilterVisitor;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.jdbc.BasicSQLDialect;

public class DGGSQuerySplitter {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    private final SimpleFeatureType schema;
    private DGGSInstance dggs;
    private DGGSResolutionCalculator resolutionCalculator;

    public DGGSQuerySplitter(DGGSInstance dggs, DGGSResolutionCalculator resolutionCalculator, SimpleFeatureType schema) {
        this.dggs = dggs;
        this.resolutionCalculator = resolutionCalculator;
        this.schema = schema;
    }

    public PrePost split(Query query) {
        Query adapted = this.adaptQuery(query);
        Filter simplified = SimplifyingFilterVisitor.simplify((Filter)adapted.getFilter());
        PostPreProcessFilterSplittingVisitor splitter = new PostPreProcessFilterSplittingVisitor(BasicSQLDialect.BASE_DBMS_CAPABILITIES, this.schema, null){

            protected boolean supports(Object value) {
                if (value instanceof Function) {
                    return true;
                }
                return super.supports(value);
            }
        };
        simplified.accept((FilterVisitor)splitter, null);
        PrePost result = new PrePost();
        result.pre = new Query(adapted);
        result.pre.setFilter(splitter.getFilterPre());
        result.post = splitter.getFilterPost();
        if (result.post != Filter.INCLUDE) {
            result.post = query.getFilter();
        }
        return result;
    }

    private Query adaptQuery(Query query) {
        if (query == null) {
            return Query.ALL;
        }
        Query result = new Query(query);
        if (query.getPropertyNames() != null) {
            HashSet<String> requestedProperties = new HashSet<String>(Arrays.asList(query.getPropertyNames()));
            Stream<String> namesStream = Arrays.stream(query.getPropertyNames()).filter(n -> !"geometry".equals(n));
            if (requestedProperties.contains("geometry") && !requestedProperties.contains("zoneId")) {
                namesStream = Stream.concat(namesStream, Stream.of("zoneId"));
            }
            String[] delegateProperties = (String[])namesStream.toArray(String[]::new);
            result.setPropertyNames(delegateProperties);
        }
        if (query.getSortBy() != null) {
            SortBy[] adaptedSort = (SortBy[])Arrays.stream(query.getSortBy()).map(sb -> {
                if (sb == SortBy.NATURAL_ORDER) {
                    return FF.sort("zoneId", SortOrder.ASCENDING);
                }
                if (sb == SortBy.REVERSE_ORDER) {
                    return FF.sort("zoneId", SortOrder.DESCENDING);
                }
                return sb;
            }).toArray(SortBy[]::new);
            result.setSortBy(adaptedSort);
        } else if (query.getStartIndex() != null || query.getMaxFeatures() < Integer.MAX_VALUE) {
            result.setSortBy(new SortBy[]{FF.sort("zoneId", SortOrder.ASCENDING)});
        }
        Filter filter = query.getFilter();
        DGGSFilterVisitor dggsInjector = new DGGSFilterVisitor(this.dggs);
        filter = (Filter)filter.accept((FilterVisitor)dggsInjector, null);
        int resolution = this.resolutionCalculator.getTargetResolution(query, -1);
        Filter adapted = DGGSFilterTransformer.adapt((Filter)filter, (DGGSInstance)this.dggs, (DGGSResolutionCalculator)this.resolutionCalculator, (int)resolution);
        if (resolution != -1) {
            PropertyIsEqualTo resolutionFilter = FF.equals((Expression)FF.property("resolution"), (Expression)FF.literal(resolution));
            result.setFilter((Filter)FF.and(adapted, (Filter)resolutionFilter));
        } else {
            result.setFilter(adapted);
        }
        return result;
    }

    public static class PrePost {
        public Query pre;
        public Filter post;
    }
}

