/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.Zone;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.collection.FilteringSimpleFeatureCollection;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.CountVisitor;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class DGGSFeatureCollection
implements SimpleFeatureCollection {
    private final SimpleFeatureType schema;
    private final DGGSInstance dggs;
    private final SimpleFeatureCollection delegate;

    public DGGSFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureType schema, DGGSInstance dggs) {
        this.delegate = delegate;
        this.schema = schema;
        this.dggs = dggs;
    }

    public String[] getSchemaProperties(SimpleFeatureType schema) {
        return (String[])schema.getAttributeDescriptors().stream().map(ad -> ad.getLocalName()).toArray(String[]::new);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    public String getID() {
        return this.delegate.getID();
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        if (DGGSFeatureCollection.isGeometryless(visitor, this.getSchema())) {
            this.delegate.accepts(visitor, progress);
        } else {
            DataUtilities.visit((FeatureCollection)this, (FeatureVisitor)visitor, (ProgressListener)progress);
        }
    }

    public static boolean isGeometryless(FeatureVisitor visitor, SimpleFeatureType schema) {
        if (visitor instanceof FeatureAttributeVisitor) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(schema);
            for (Expression e : ((FeatureAttributeVisitor)visitor).getExpressions()) {
                e.accept((ExpressionVisitor)extractor, null);
            }
            for (PropertyName pname : extractor.getPropertyNameSet()) {
                AttributeDescriptor att = (AttributeDescriptor)pname.evaluate((Object)schema);
                if (!(att instanceof GeometryDescriptor)) continue;
                return false;
            }
            return true;
        }
        return visitor instanceof CountVisitor;
    }

    public ReferencedEnvelope getBounds() {
        return DataUtilities.bounds((FeatureCollection)this);
    }

    public boolean contains(Object o) {
        try (SimpleFeatureIterator fi = this.features();){
            while (fi.hasNext()) {
                SimpleFeature next = (SimpleFeature)fi.next();
                if (!Objects.equals(o, next)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean containsAll(Collection<?> o) {
        HashSet candidates = new HashSet(o);
        try (SimpleFeatureIterator fi = this.features();){
            while (fi.hasNext()) {
                SimpleFeature next = (SimpleFeature)fi.next();
                candidates.remove(next);
                if (!candidates.isEmpty()) continue;
                break;
            }
        }
        return candidates.isEmpty();
    }

    public boolean isEmpty() {
        try (SimpleFeatureIterator fi = this.features();){
            boolean bl = !fi.hasNext();
            return bl;
        }
    }

    public int size() {
        return this.delegate.size();
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public <O> O[] toArray(O[] array) {
        int size = this.size();
        if (array.length < size) {
            Object[] grown = (Object[])Array.newInstance(array.getClass().getComponentType(), size);
            array = grown;
        }
        try (SimpleFeatureIterator it = this.features();){
            int i;
            for (i = 0; it.hasNext() && i < size; ++i) {
                array[i] = it.next();
            }
            while (i < size) {
                array[i] = null;
                ++i;
            }
            Object[] objectArray = array;
            return objectArray;
        }
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        return new FilteringSimpleFeatureCollection(this.delegate, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return new SortedSimpleFeatureCollection(this.delegate, new SortBy[]{order});
    }

    public SimpleFeatureIterator features() {
        final SimpleFeatureIterator it = this.delegate.features();
        final SimpleFeatureBuilder fb = new SimpleFeatureBuilder(this.getSchema());
        return new SimpleFeatureIterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public SimpleFeature next() throws NoSuchElementException {
                return DGGSFeatureCollection.this.wrapFeature((SimpleFeature)it.next(), fb);
            }

            public void close() {
                it.close();
            }
        };
    }

    private SimpleFeature wrapFeature(SimpleFeature next, SimpleFeatureBuilder fb) {
        for (AttributeDescriptor ad : this.schema.getAttributeDescriptors()) {
            String name = ad.getLocalName();
            if ("geometry".equals(name)) {
                Zone zone = this.dggs.getZone((String)next.getAttribute("zoneId"));
                fb.add((Object)zone.getBoundary());
                continue;
            }
            fb.add(next.getAttribute(name));
        }
        return fb.buildFeature(next.getID());
    }
}

