/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.dggs.clickhouse.ClickHouseDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class ClickHouseJDBCDataStoreFactory
extends JDBCDataStoreFactory {
    public static final String DATABASE_ID = "clickhouse";
    public static final String DRIVER_CLASSNAME = "com.clickhouse.jdbc.ClickHouseDriver";
    public static final String FORCE_HTTP_CLIENT = "http_connection_provider=HTTP_CLIENT";

    protected String getDatabaseID() {
        return DATABASE_ID;
    }

    protected String getDriverClassName() {
        return DRIVER_CLASSNAME;
    }

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new ClickHouseDialect(dataStore);
    }

    protected String getValidationQuery() {
        return "select 1";
    }

    public String getDescription() {
        return "Clickhouse alphanumeric datastore";
    }

    public BasicDataSource createDataSource(Map<String, ?> params) throws IOException {
        BasicDataSource ds = super.createDataSource(params);
        ds.addConnectionProperty("max_query_size", "1000000");
        ds.addConnectionProperty("socket_timeout", "300000");
        return ds;
    }

    protected String getJDBCUrl(Map<String, ?> params) throws IOException {
        return super.getJDBCUrl(params) + "?http_connection_provider=HTTP_CLIENT";
    }
}

