/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.dggs.clickhouse.ClickHouseFilterToSQL;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

class ClickHouseDialect
extends BasicSQLDialect {
    private static final String GEOMETRY_NOT_SUPPORTED = "Geometry functions are not supported in ClickHouse, this store is provided as pure JDBC support to DGGS";

    protected ClickHouseDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        throw new UnsupportedOperationException(GEOMETRY_NOT_SUPPORTED);
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        throw new UnsupportedOperationException(GEOMETRY_NOT_SUPPORTED);
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        throw new UnsupportedOperationException(GEOMETRY_NOT_SUPPORTED);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        throw new UnsupportedOperationException(GEOMETRY_NOT_SUPPORTED);
    }

    public FilterToSQL createFilterToSQL() {
        ClickHouseFilterToSQL f2s = new ClickHouseFilterToSQL();
        f2s.setCapabilities(BASE_DBMS_CAPABILITIES);
        return f2s;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET " + offset);
        }
    }

    public Object convertValue(Object value, AttributeDescriptor ad) {
        Class binding = ad.getType().getBinding();
        java.util.Date c = ClickHouseDialect.convertValue(value, binding);
        if (c != null) {
            return c;
        }
        return super.convertValue(value, ad);
    }

    private static java.util.Date convertValue(Object value, Class<?> binding) {
        if (value instanceof LocalDate && binding.equals(Date.class)) {
            LocalDate d = (LocalDate)value;
            Calendar c = Calendar.getInstance();
            c.clear();
            c.set(d.getYear(), d.getMonthValue() - 1, d.getDayOfMonth(), 0, 0, 0);
            return new Date(c.getTimeInMillis());
        }
        if (value instanceof LocalDateTime && binding.equals(Timestamp.class)) {
            return Timestamp.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        return null;
    }

    public Function<Object, Object> getAggregateConverter(FeatureVisitor visitor, SimpleFeatureType featureType) {
        Class targetType;
        List resultTypes;
        Optional maybeResultTypes = this.getResultTypes(visitor, featureType);
        if (maybeResultTypes.isPresent() && (resultTypes = (List)maybeResultTypes.get()).size() == 1 && java.util.Date.class.isAssignableFrom(targetType = (Class)resultTypes.get(0))) {
            return v -> ClickHouseDialect.convertValue(v, targetType);
        }
        return Function.identity();
    }
}

