/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.dggs.clickhouse;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.DefaultServiceInfo;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.dggs.DGGSInstance;
import org.geotools.dggs.clickhouse.ClickHouseDGGSFeatureSource;
import org.geotools.dggs.gstore.DGGSFeatureSource;
import org.geotools.dggs.gstore.DGGSResolutionCalculator;
import org.geotools.dggs.gstore.DGGSStore;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Polygon;

public class ClickHouseDGGSDataStore
implements DGGSStore {
    static final Logger LOGGER = Logging.getLogger(ClickHouseDGGSDataStore.class);
    public static final String GEOMETRY = "geometry";
    public static final String DEFAULT_GEOMETRY = "";
    private final DGGSInstance dggs;
    private final DataStore delegate;
    private final DGGSResolutionCalculator resolutions;

    public ClickHouseDGGSDataStore(DGGSInstance dggs, DataStore delegate) {
        this.delegate = delegate;
        this.dggs = dggs;
        this.resolutions = new DGGSResolutionCalculator(dggs);
    }

    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("Features from " + this.getClass().getSimpleName());
        info.setSchema(FeatureTypes.DEFAULT_NAMESPACE);
        return info;
    }

    public List<Name> getNames() throws IOException {
        return this.delegate.getNames().stream().filter(n -> {
            try {
                return this.isDGGSSchema((SimpleFeatureType)this.delegate.getSchema(n));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to grab schema for " + n, e);
                return false;
            }
        }).collect(Collectors.toList());
    }

    public String[] getTypeNames() throws IOException {
        return (String[])Arrays.stream(this.delegate.getTypeNames()).filter(t -> {
            try {
                return this.isDGGSSchema(this.delegate.getSchema(t));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to grab schema for " + t, e);
                return false;
            }
        }).toArray(String[]::new);
    }

    private boolean isDGGSSchema(SimpleFeatureType schema) {
        return this.checkAttribute(schema, "zoneId", String.class) && this.checkAttribute(schema, "resolution", Byte.class, Short.class, Integer.class) && schema.getDescriptor(GEOMETRY) == null;
    }

    private boolean checkAttribute(SimpleFeatureType schema, String name, Class<?> ... expectedBindings) {
        return Optional.ofNullable(schema.getDescriptor(name)).filter(ad -> {
            for (Class binding : expectedBindings) {
                if (!binding.isAssignableFrom(ad.getType().getBinding())) continue;
                return true;
            }
            return false;
        }).isPresent();
    }

    public SimpleFeatureType getSchema(Name name) throws IOException {
        SimpleFeatureType ft = (SimpleFeatureType)this.delegate.getSchema(name);
        return this.wrapType(ft);
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        SimpleFeatureType ft = this.delegate.getSchema(typeName);
        return this.wrapType(ft);
    }

    private SimpleFeatureType wrapType(SimpleFeatureType ft) {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(ft.getName());
        for (AttributeDescriptor ad : ft.getAttributeDescriptors()) {
            tb.minOccurs(0);
            tb.add(ad.getLocalName(), ad.getType().getBinding());
        }
        tb.add(GEOMETRY, Polygon.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        return tb.buildFeatureType();
    }

    public DGGSFeatureSource getFeatureSource(String typeName) throws IOException {
        return new ClickHouseDGGSFeatureSource(this, this.delegate.getFeatureSource(typeName), this.getSchema(typeName));
    }

    public DGGSFeatureSource getFeatureSource(Name typeName) throws IOException {
        return new ClickHouseDGGSFeatureSource(this, this.delegate.getFeatureSource(typeName), this.getSchema(typeName));
    }

    public DGGSFeatureSource getDGGSFeatureSource(String typeName) throws IOException {
        return this.getFeatureSource(typeName);
    }

    public void dispose() {
        try {
            this.delegate.dispose();
        }
        finally {
            this.dggs.close();
        }
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        final DGGSFeatureSource source = this.getFeatureSource(query.getTypeName());
        final SimpleFeatureIterator features = source.getFeatures(query).features();
        return new FeatureReader<SimpleFeatureType, SimpleFeature>(){

            public SimpleFeatureType getFeatureType() {
                return (SimpleFeatureType)source.getSchema();
            }

            public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
                return (SimpleFeature)features.next();
            }

            public boolean hasNext() throws IOException {
                return features.hasNext();
            }

            public void close() throws IOException {
                features.next();
            }
        };
    }

    public LockingManager getLockingManager() {
        return this.delegate.getLockingManager();
    }

    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void removeSchema(Name typeName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DataStore getDelegate() {
        return this.delegate;
    }

    protected DGGSInstance getDggs() {
        return this.dggs;
    }

    protected DGGSResolutionCalculator getResolutions() {
        return this.resolutions;
    }
}

