/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.backuprestore.web.WorkspaceModel;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class StoreModel<T extends StoreInfo>
extends LoadableDetachableModel<T> {
    private static final long serialVersionUID = -2008934085507417813L;
    private ResourceFilePanel resourceFilePanel;
    IModel workspace;
    String name;

    private StoreModel(T store) {
        super(store);
        this.setObject(store);
    }

    public StoreModel(ResourceFilePanel resourceFilePanel, T store) {
        this(store);
        this.resourceFilePanel = resourceFilePanel;
    }

    public void setObject(T store) {
        super.setObject(store);
        if (store != null) {
            this.workspace = new WorkspaceModel<WorkspaceInfo>(this.resourceFilePanel, store.getWorkspace());
            this.name = store.getName();
        } else {
            this.name = null;
        }
    }

    protected T load() {
        StoreInfo store;
        if (this.workspace == null) {
            return null;
        }
        if (this.name == null) {
            return null;
        }
        if (this.resourceFilePanel != null && this.resourceFilePanel.getStores() != null && !this.resourceFilePanel.getStores().isEmpty() && this.workspace.getObject() != null && this.resourceFilePanel.getStores().containsKey(((WorkspaceInfo)this.workspace.getObject()).getName())) {
            for (StoreInfo st : this.resourceFilePanel.getStores().get(((WorkspaceInfo)this.workspace.getObject()).getName())) {
                if (!st.getName().equals(this.name)) continue;
                return (T)st;
            }
        }
        if ((store = GeoServerApplication.get().getCatalog().getStoreByName((WorkspaceInfo)this.workspace.getObject(), this.name, StoreInfo.class)) != null) {
            return (T)store;
        }
        return (T)((StoreInfo)this.getObject());
    }

    public void detach() {
        super.detach();
        if (this.workspace != null) {
            this.workspace.detach();
        }
    }
}

