/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.backuprestore.web.WorkspaceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.web.GeoServerApplication;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;

public class BackupRestoreStoresIndexModel
extends LoadableDetachableModel<List<StoreInfo>> {
    private static final long serialVersionUID = -998149757898741087L;
    private WorkspaceModel<WorkspaceInfo> workspace;
    private ResourceFilePanel resourceFilePanel;

    public BackupRestoreStoresIndexModel(WorkspaceModel<WorkspaceInfo> workspace, ResourceFilePanel resourceFilePanel) {
        this.workspace = workspace;
        this.resourceFilePanel = resourceFilePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<StoreInfo> load() {
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        if (ws != null) {
            ExcludeFilter filter;
            if (this.resourceFilePanel.getStores() != null && !this.resourceFilePanel.getStores().isEmpty() && this.resourceFilePanel.getStores().containsKey(ws.getName())) {
                return this.resourceFilePanel.getStores().get(ws.getName());
            }
            Catalog catalog = GeoServerApplication.get().getCatalog();
            try {
                filter = Predicates.equal((String)"workspace.name", (Object)ws.getName());
            }
            catch (Exception e) {
                filter = Filter.EXCLUDE;
            }
            ArrayList<StoreInfo> stores = new ArrayList<StoreInfo>();
            try (CloseableIterator iterator = catalog.list(StoreInfo.class, (Filter)filter);){
                while (iterator.hasNext()) {
                    stores.add((StoreInfo)iterator.next());
                }
            }
            Collections.sort(stores, new StoreComparator());
            return stores;
        }
        return new ArrayList<StoreInfo>();
    }

    public void detach() {
        super.detach();
        if (this.workspace != null) {
            this.workspace.detach();
        }
    }

    protected static class StoreComparator
    implements Comparator<StoreInfo> {
        @Override
        public int compare(StoreInfo s1, StoreInfo s2) {
            return s1.getName().compareToIgnoreCase(s2.getName());
        }
    }
}

