/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.backuprestore.web.StoreModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.util.CloseableIterator;
import org.geoserver.web.GeoServerApplication;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;

public class BackupRestoreLayersIndexModel
extends LoadableDetachableModel<List<LayerInfo>> {
    private static final long serialVersionUID = -2216296970407724704L;
    private StoreModel<StoreInfo> storeInfo;
    private ResourceFilePanel resourceFilePanel;

    public BackupRestoreLayersIndexModel(StoreModel<StoreInfo> storeModel, ResourceFilePanel resourceFilePanel) {
        this.storeInfo = storeModel;
        this.resourceFilePanel = resourceFilePanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LayerInfo> load() {
        StoreInfo si = (StoreInfo)this.storeInfo.getObject();
        if (si != null) {
            ExcludeFilter filter;
            if (this.resourceFilePanel.getLayers() != null && !this.resourceFilePanel.getLayers().isEmpty() && this.resourceFilePanel.getLayers().containsKey(si.getName())) {
                return this.resourceFilePanel.getLayers().get(si.getName());
            }
            Catalog catalog = GeoServerApplication.get().getCatalog();
            try {
                filter = Predicates.equal((String)"resource.store.name", (Object)si.getName());
            }
            catch (Exception e) {
                filter = Filter.EXCLUDE;
            }
            ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
            try (CloseableIterator iterator = catalog.list(LayerInfo.class, (Filter)filter);){
                while (iterator.hasNext()) {
                    layers.add((LayerInfo)iterator.next());
                }
            }
            Collections.sort(layers, new LayerComparator());
            return layers;
        }
        return new ArrayList<LayerInfo>();
    }

    public void detach() {
        super.detach();
        if (this.storeInfo != null) {
            this.storeInfo.detach();
        }
    }

    protected static class LayerComparator
    implements Comparator<LayerInfo> {
        @Override
        public int compare(LayerInfo l1, LayerInfo l2) {
            return l1.getName().compareToIgnoreCase(l2.getName());
        }
    }
}

