/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class WorkspaceModel<T extends WorkspaceInfo>
extends LoadableDetachableModel<T> {
    private static final long serialVersionUID = 8956830437048564765L;
    private ResourceFilePanel resourceFilePanel;
    String name;

    private WorkspaceModel(T workspace) {
        super(workspace);
        this.setObject(workspace);
    }

    public WorkspaceModel(ResourceFilePanel resourceFilePanel, T workspace) {
        this(workspace);
        this.resourceFilePanel = resourceFilePanel;
    }

    public void setObject(T object) {
        super.setObject(object);
        this.name = object != null ? object.getName() : null;
    }

    protected T load() {
        WorkspaceInfo workspace;
        if (this.name == null) {
            return null;
        }
        if (this.resourceFilePanel != null && this.resourceFilePanel.getWorkspaces() != null && !this.resourceFilePanel.getWorkspaces().isEmpty()) {
            for (WorkspaceInfo ws : this.resourceFilePanel.getWorkspaces()) {
                if (!ws.getName().equals(this.name)) continue;
                return (T)ws;
            }
        }
        if ((workspace = GeoServerApplication.get().getCatalog().getWorkspaceByName(this.name)) != null) {
            return (T)workspace;
        }
        return (T)((WorkspaceInfo)this.getObject());
    }
}

