/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.backuprestore.utils.BackupUtils;
import org.geoserver.backuprestore.web.BackupRestoreDataPage;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Files;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.browser.ExtensionFileFilter;
import org.geoserver.web.wicket.browser.GeoServerFileChooser;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.util.logging.Logging;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.SAXBuilder;
import org.opengis.filter.Filter;

public class ResourceFilePanel
extends Panel {
    protected static Logger LOGGER = Logging.getLogger(ResourceFilePanel.class);
    private static final String[] FILE_EXTENSIONS = new String[]{".zip", ".gz", ".tar", ".tgz", ".bz"};
    String file;
    List<WorkspaceInfo> workspaces;
    Map<String, List<StoreInfo>> stores;
    Map<String, List<LayerInfo>> layers;
    Filter wsFilter;
    Filter siFilter;
    Filter liFilter;
    TextField fileField;
    GeoServerDialog dialog;
    private BackupRestoreDataPage backupRestoreDataPage;

    public ResourceFilePanel(String id, BackupRestoreDataPage container) {
        super(id);
        this.backupRestoreDataPage = container;
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        Form form = new Form("form", (IModel)new CompoundPropertyModel((Object)this));
        this.add(new Component[]{form});
        this.fileField = new TextField("file");
        this.fileField.setRequired(true);
        this.fileField.setOutputMarkupId(true);
        this.fileField.add(new Behavior[]{new OnChangeAjaxBehavior(){

            protected void onUpdate(AjaxRequestTarget target) {
                String valueAsString = (String)((TextField)this.getComponent()).getModelObject();
                ResourceFilePanel.this.doUpdate(target, valueAsString);
            }
        }});
        form.add(new Component[]{this.fileField});
        form.add(new Component[]{this.chooserButton(form)});
    }

    public Resource getResource() {
        return Files.asResource((File)new File(this.file));
    }

    public List<WorkspaceInfo> getWorkspaces() {
        return this.workspaces;
    }

    public Map<String, List<StoreInfo>> getStores() {
        return this.stores;
    }

    public Map<String, List<LayerInfo>> getLayers() {
        return this.layers;
    }

    Component chooserButton(Form form) {
        AjaxSubmitLink link = new AjaxSubmitLink("chooser"){

            protected void onSubmit(AjaxRequestTarget target, Form form) {
                ResourceFilePanel.this.dialog.setTitle((IModel)new ParamResourceModel("chooseFile", (Component)this, new Object[0]));
                ResourceFilePanel.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){

                    protected Component getContents(String id) {
                        File file = null;
                        if (!ResourceFilePanel.this.fileField.getInput().trim().equals("") && !(file = new File(ResourceFilePanel.this.fileField.getInput())).exists()) {
                            file = null;
                        }
                        GeoServerFileChooser chooser = new GeoServerFileChooser(id, (IModel)new Model(file)){

                            protected void fileClicked(File file, AjaxRequestTarget target) {
                                ResourceFilePanel.this.file = file.getAbsolutePath();
                                ResourceFilePanel.this.fileField.clearInput();
                                ResourceFilePanel.this.fileField.setModelObject((Object)file.getAbsolutePath());
                                target.add(new Component[]{ResourceFilePanel.this.fileField});
                                ResourceFilePanel.this.dialog.close(target);
                            }
                        };
                        ResourceFilePanel.this.initFileChooser(chooser);
                        return chooser;
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        GeoServerFileChooser chooser = (GeoServerFileChooser)contents;
                        ResourceFilePanel.this.file = ((File)chooser.getDefaultModelObject()).getAbsolutePath();
                        ResourceFilePanel.this.fileField.clearInput();
                        target.add(new Component[]{ResourceFilePanel.this.fileField});
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        target.add(new Component[]{ResourceFilePanel.this.fileField});
                        ResourceFilePanel.this.doUpdate(target, ResourceFilePanel.this.file);
                    }
                });
            }
        };
        link.setDefaultFormProcessing(false);
        return link;
    }

    SubmitLink submitLink() {
        return new SubmitLink("submit"){

            public void onSubmit() {
            }
        };
    }

    protected void initFileChooser(GeoServerFileChooser fileChooser) {
        fileChooser.setFilter((IModel)new Model((Serializable)new ExtensionFileFilter(FILE_EXTENSIONS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(AjaxRequestTarget target, String valueAsString) {
        block25: {
            Catalog catalog = GeoServerApplication.get().getCatalog();
            File file = null;
            if (!(valueAsString.trim().equals("") || (file = new File(valueAsString)).exists() && !file.isDirectory())) {
                file = null;
                this.workspaces = null;
                this.stores = null;
                this.layers = null;
            }
            ArrayList<WorkspaceInfo> workspaceInfos = new ArrayList<WorkspaceInfo>();
            HashMap<String, List<StoreInfo>> storeInfos = new HashMap<String, List<StoreInfo>>();
            HashMap<String, List<LayerInfo>> layerInfos = new HashMap<String, List<LayerInfo>>();
            try {
                Resource archiveFile;
                if (file == null || !Resources.exists((Resource)(archiveFile = Files.asResource((File)file))) || archiveFile.getType() == Resource.Type.DIRECTORY) break block25;
                Resource tmpDir = BackupUtils.geoServerTmpDir((GeoServerDataDirectory)new GeoServerDataDirectory(GeoServerApplication.get().getResourceLoader()));
                try {
                    BackupUtils.extractTo((Resource)archiveFile, (Resource)tmpDir);
                    Resource brCatalogIndex = tmpDir.get("br_index.xml");
                    if (Resources.exists((Resource)brCatalogIndex)) {
                        SAXBuilder saxBuilder = new SAXBuilder();
                        Document document = saxBuilder.build(brCatalogIndex.in());
                        Element classElement = document.getRootElement();
                        List workspaceList = classElement.getChildren("Workspace");
                        for (Element ws : workspaceList) {
                            String wsName = ws.getChild("Name").getText();
                            WorkspaceInfo workspace = catalog.getWorkspaceByName(wsName);
                            if (workspace == null) {
                                workspace = catalog.getFactory().createWorkspace();
                                workspace.setName(wsName);
                            }
                            workspaceInfos.add(workspace);
                            storeInfos.put(wsName, new ArrayList());
                            for (Element st : ws.getChildren("Store")) {
                                String stName = st.getChild("Name").getText();
                                String type = st.getAttribute("type").getValue();
                                DataStoreInfo store = null;
                                FeatureTypeInfo resource = null;
                                if ("DataStoreInfo".equals(type)) {
                                    store = catalog.getDataStoreByName(stName);
                                    if (store == null) {
                                        store = catalog.getFactory().createDataStore();
                                        store.setName(stName);
                                    }
                                } else if ("CoverageStoreInfo".equals(type) && (store = catalog.getCoverageStoreByName(stName)) == null) {
                                    store = catalog.getFactory().createCoverageStore();
                                    store.setName(stName);
                                }
                                if (store == null) continue;
                                ((List)storeInfos.get(wsName)).add(store);
                                layerInfos.put(stName, new ArrayList());
                                for (Element ly : st.getChildren("Layer")) {
                                    LayerInfo layer;
                                    String lyName = ly.getChild("Name").getText();
                                    if ("DataStoreInfo".equals(type)) {
                                        resource = catalog.getFeatureTypeByName(lyName);
                                        if (resource == null) {
                                            resource = catalog.getFactory().createFeatureType();
                                            store.setWorkspace(workspace);
                                            resource.setStore((StoreInfo)store);
                                            resource.setName(lyName);
                                        }
                                    } else if ("CoverageStoreInfo".equals(type) && (resource = catalog.getCoverageByName(lyName)) == null) {
                                        resource = catalog.getFactory().createCoverage();
                                        store.setWorkspace(workspace);
                                        resource.setStore((StoreInfo)store);
                                        resource.setName(lyName);
                                    }
                                    if ((layer = catalog.getLayerByName(lyName)) == null) {
                                        layer = catalog.getFactory().createLayer();
                                        layer.setResource((ResourceInfo)resource);
                                        layer.setName(lyName);
                                    }
                                    ((List)layerInfos.get(stName)).add(layer);
                                }
                            }
                        }
                        this.workspaces = workspaceInfos;
                        this.stores = storeInfos;
                        this.layers = layerInfos;
                        Element filtersList = classElement.getChild("Filters");
                        for (Element filter : filtersList.getChildren("Filter")) {
                            if ("WorkspaceInfo".equals(filter.getAttribute("type").getValue())) {
                                this.wsFilter = ECQL.toFilter((String)filter.getChild("ECQL").getText());
                            }
                            if ("StoreInfo".equals(filter.getAttribute("type").getValue())) {
                                this.siFilter = ECQL.toFilter((String)filter.getChild("ECQL").getText());
                            }
                            if (!"LayerInfo".equals(filter.getAttribute("type").getValue())) continue;
                            this.liFilter = ECQL.toFilter((String)filter.getChild("ECQL").getText());
                        }
                    }
                }
                finally {
                    if (tmpDir != null) {
                        tmpDir.delete();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error occurred while parsing Backup/Restore Index.", e);
            }
        }
        if (this.backupRestoreDataPage.get("workspace") != null) {
            this.backupRestoreDataPage.get("workspace").setDefaultModelObject(null);
            this.backupRestoreDataPage.get("store").setDefaultModelObject(null);
            this.backupRestoreDataPage.get("layer").setDefaultModelObject(null);
            target.add(new Component[]{this.backupRestoreDataPage.get("workspace")});
            target.add(new Component[]{this.backupRestoreDataPage.get("store")});
            target.add(new Component[]{this.backupRestoreDataPage.get("layer")});
        }
    }
}

