/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class BackupRestoreWorkspacesIndexModel
extends LoadableDetachableModel<List<WorkspaceInfo>> {
    private static final long serialVersionUID = 4052600127151308001L;
    private ResourceFilePanel resourceFilePanel;

    public BackupRestoreWorkspacesIndexModel(ResourceFilePanel resourceFilePanel) {
        this.resourceFilePanel = resourceFilePanel;
    }

    protected List<WorkspaceInfo> load() {
        if (this.resourceFilePanel.getWorkspaces() != null && !this.resourceFilePanel.getWorkspaces().isEmpty()) {
            return this.resourceFilePanel.getWorkspaces();
        }
        Catalog catalog = GeoServerApplication.get().getCatalog();
        ArrayList<WorkspaceInfo> workspaces = new ArrayList<WorkspaceInfo>(catalog.getWorkspaces());
        Collections.sort(workspaces, new WorkspaceComparator());
        return workspaces;
    }

    protected static class WorkspaceComparator
    implements Comparator<WorkspaceInfo> {
        @Override
        public int compare(WorkspaceInfo w1, WorkspaceInfo w2) {
            return w1.getName().compareToIgnoreCase(w2.getName());
        }
    }
}

