/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.geoserver.backuprestore.Backup;
import org.geoserver.web.GeoServerApplication;
import org.springframework.security.core.context.SecurityContextHolder;

public class BackupRestoreWebUtils {
    static Backup backupFacade() {
        Backup backupFacade = (Backup)GeoServerApplication.get().getBeanOfType(Backup.class);
        backupFacade.setAuth(SecurityContextHolder.getContext().getAuthentication());
        return backupFacade;
    }

    static boolean isDevMode() {
        return RuntimeConfigurationType.DEVELOPMENT == GeoServerApplication.get().getConfigurationType();
    }

    static void disableLink(ComponentTag tag) {
        tag.setName("a");
        tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
    }

    static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }
}

