/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.NumberTextField;
import org.apache.wicket.markup.html.form.SubmitLink;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.handler.resource.ResourceStreamRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.util.resource.FileResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;
import org.geoserver.backuprestore.AbstractExecutionAdapter;
import org.geoserver.backuprestore.BackupExecutionAdapter;
import org.geoserver.backuprestore.RestoreExecutionAdapter;
import org.geoserver.backuprestore.web.BackupRestoreDataPage;
import org.geoserver.backuprestore.web.BackupRestoreExecutionModel;
import org.geoserver.backuprestore.web.BackupRestoreExecutionsProvider;
import org.geoserver.backuprestore.web.BackupRestoreExecutionsTable;
import org.geoserver.backuprestore.web.BackupRestoreWebUtils;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Paths;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoServerUnlockablePage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.Icon;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;

public class BackupRestorePage<T extends AbstractExecutionAdapter>
extends GeoServerSecuredPage
implements GeoServerUnlockablePage {
    public static final PackageResourceReference COMPRESS_ICON = new PackageResourceReference(BackupRestorePage.class, "compress.png");
    static final String DETAILS_LEVEL = "expand";
    int expand = 0;
    File backupFile;
    GeoServerDialog dialog;
    private PageParameters params;
    private Class<T> clazz;

    public BackupRestorePage(PageParameters pp) {
        this((IModel<T>)new BackupRestoreExecutionModel(pp.get("id").toLong(), BackupRestorePage.getType(pp.get("clazz").toString())), pp, BackupRestorePage.getType(pp.get("clazz").toString()));
    }

    public BackupRestorePage(T bkp, PageParameters pp) {
        this((IModel<T>)new BackupRestoreExecutionModel((AbstractExecutionAdapter)bkp, BackupRestorePage.getType(pp.get("clazz").toString())), pp, BackupRestorePage.getType(pp.get("clazz").toString()));
    }

    private static Class getType(String simpleName) {
        if (BackupExecutionAdapter.class.getSimpleName().equals(simpleName)) {
            return BackupExecutionAdapter.class;
        }
        if (RestoreExecutionAdapter.class.getSimpleName().equals(simpleName)) {
            return RestoreExecutionAdapter.class;
        }
        return null;
    }

    public BackupRestorePage(IModel<T> model, PageParameters pp, Class<T> clazz) {
        this.params = pp;
        this.clazz = clazz;
        this.initComponents(model);
    }

    public Class<T> getType() {
        return this.clazz;
    }

    void initComponents(final IModel<T> model) {
        this.add(new Component[]{new Label("id", (IModel)new PropertyModel(model, "id"))});
        this.add(new Component[]{new Label("clazz", (IModel)new Model((Serializable)((Object)this.clazz.getSimpleName().substring(0, this.clazz.getSimpleName().indexOf("Execution")))))});
        BackupRestoreExecutionsProvider provider = new BackupRestoreExecutionsProvider(this.getType()){

            @Override
            protected List<GeoServerDataProvider.Property<AbstractExecutionAdapter>> getProperties() {
                return Arrays.asList(ID, STATE, STARTED, PROGRESS, ARCHIVEFILE, OPTIONS);
            }

            protected List<T> getItems() {
                return Collections.singletonList(model.getObject());
            }
        };
        BackupRestoreExecutionsTable<T> headerTable = new BackupRestoreExecutionsTable<T>("header", provider, this.getType());
        headerTable.setOutputMarkupId(true);
        headerTable.setFilterable(false);
        headerTable.setPageable(false);
        this.add(new Component[]{headerTable});
        AbstractExecutionAdapter bkp = (AbstractExecutionAdapter)model.getObject();
        boolean selectable = bkp.getStatus() != BatchStatus.COMPLETED;
        this.add(new Component[]{new Icon("icon", COMPRESS_ICON)});
        this.add(new Component[]{new Label("title", (IModel)new DataTitleModel(this, bkp)).add(new Behavior[]{new AttributeModifier("title", (IModel)new DataTitleModel(this, bkp, false))})});
        Form form = new Form("form");
        this.add(new Component[]{form});
        try {
            if (this.params != null && this.params.getNamedKeys().contains(DETAILS_LEVEL) && this.params.get(DETAILS_LEVEL).toInt() > 0) {
                this.expand = this.params.get(DETAILS_LEVEL).toInt();
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error parsing the 'details level' parameter: ", this.params.get(DETAILS_LEVEL).toString());
        }
        form.add(new Component[]{new SubmitLink("refresh"){

            public void onSubmit() {
                this.setResponsePage(BackupRestorePage.class, new PageParameters().add("id", (Object)BackupRestorePage.this.params.get("id").toLong()).add("clazz", (Object)BackupRestorePage.this.getType().getSimpleName()).add(BackupRestorePage.DETAILS_LEVEL, (Object)BackupRestorePage.this.expand));
            }
        }});
        NumberTextField expand = new NumberTextField(DETAILS_LEVEL, (IModel)new PropertyModel((Object)this, DETAILS_LEVEL));
        expand.add((IValidator)RangeValidator.minimum((Comparable)Integer.valueOf(0)));
        form.add(new Component[]{expand});
        TextArea details = new TextArea("details", new BKErrorDetailsModel(bkp));
        details.setOutputMarkupId(true);
        details.setMarkupId("details");
        this.add(new Component[]{details});
        String location = bkp.getArchiveFile().path();
        if (location == null) {
            location = this.getGeoServerApplication().getGeoServer().getLogging().getLocation();
        }
        this.backupFile = new File(location);
        if (!this.backupFile.isAbsolute()) {
            GeoServerDataDirectory dd = (GeoServerDataDirectory)this.getGeoServerApplication().getBeanOfType(GeoServerDataDirectory.class);
            this.backupFile = dd.get(Paths.convert((String)this.backupFile.getPath())).file();
        }
        if (!this.backupFile.exists()) {
            this.error((Serializable)((Object)("Could not find the Backup Archive file: " + this.backupFile.getAbsolutePath())));
        }
        Link<Object> downLoadLink = new Link<Object>("download"){

            public void onClick() {
                FileResourceStream stream = new FileResourceStream(BackupRestorePage.this.backupFile){

                    public String getContentType() {
                        return "application/zip";
                    }
                };
                ResourceStreamRequestHandler handler = new ResourceStreamRequestHandler((IResourceStream)stream, BackupRestorePage.this.backupFile.getName());
                handler.setContentDisposition(ContentDisposition.ATTACHMENT);
                RequestCycle.get().scheduleRequestHandlerAfterCurrent((IRequestHandler)handler);
            }
        };
        this.add(new Component[]{downLoadLink});
        AjaxLink pauseLink = new AjaxLink("pause", (Link)downLoadLink){
            final /* synthetic */ Link val$downLoadLink;
            {
                this.val$downLoadLink = link;
                super(x0);
            }

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                AbstractExecutionAdapter bkp = (AbstractExecutionAdapter)model.getObject();
                if (bkp.getStatus() == BatchStatus.STOPPED) {
                    BackupRestorePage.this.setLinkEnabled((AjaxLink)this.val$downLoadLink.getParent().get("pause"), false, target);
                } else {
                    try {
                        BackupRestoreWebUtils.backupFacade().stopExecution(bkp.getId());
                        this.setResponsePage(BackupRestoreDataPage.class);
                    }
                    catch (JobExecutionNotRunningException | NoSuchJobExecutionException e) {
                        LOGGER.log(Level.WARNING, "", e);
                        this.getSession().error((Serializable)((Object)e));
                        this.setResponsePage(BackupRestoreDataPage.class);
                    }
                }
            }
        };
        pauseLink.setEnabled(this.doSelectReady(bkp) && bkp.getStatus() != BatchStatus.STOPPED);
        this.add(new Component[]{pauseLink});
        AjaxLink resumeLink = new AjaxLink("resume", (Link)downLoadLink){
            final /* synthetic */ Link val$downLoadLink;
            {
                this.val$downLoadLink = link;
                super(x0);
            }

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                AbstractExecutionAdapter bkp = (AbstractExecutionAdapter)model.getObject();
                if (bkp.getStatus() != BatchStatus.STOPPED) {
                    BackupRestorePage.this.setLinkEnabled((AjaxLink)this.val$downLoadLink.getParent().get("pause"), false, target);
                } else {
                    try {
                        Long id = BackupRestoreWebUtils.backupFacade().restartExecution(bkp.getId());
                        PageParameters pp = new PageParameters();
                        pp.add("id", (Object)id);
                        if (bkp instanceof BackupExecutionAdapter) {
                            pp.add("clazz", (Object)BackupExecutionAdapter.class.getSimpleName());
                        } else if (bkp instanceof RestoreExecutionAdapter) {
                            pp.add("clazz", (Object)RestoreExecutionAdapter.class.getSimpleName());
                        }
                        this.setResponsePage(BackupRestorePage.class, pp);
                    }
                    catch (JobParametersInvalidException | NoSuchJobException | NoSuchJobExecutionException | JobInstanceAlreadyCompleteException | JobRestartException e) {
                        LOGGER.log(Level.WARNING, "", e);
                        this.getSession().error((Serializable)((Object)e));
                        this.setResponsePage(BackupRestoreDataPage.class);
                    }
                }
            }
        };
        resumeLink.setEnabled(bkp.getStatus() == BatchStatus.STOPPED);
        this.add(new Component[]{resumeLink});
        AjaxLink cancelLink = new AjaxLink("cancel", (Link)downLoadLink){
            final /* synthetic */ Link val$downLoadLink;
            {
                this.val$downLoadLink = link;
                super(x0);
            }

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                AbstractExecutionAdapter bkp = (AbstractExecutionAdapter)model.getObject();
                if (!BackupRestorePage.this.doSelectReady(bkp)) {
                    BackupRestorePage.this.setLinkEnabled((AjaxLink)this.val$downLoadLink.getParent().get("cancel"), false, target);
                } else {
                    try {
                        BackupRestoreWebUtils.backupFacade().abandonExecution(bkp.getId());
                        PageParameters pp = new PageParameters();
                        pp.add("id", (Object)bkp.getId());
                        if (bkp instanceof BackupExecutionAdapter) {
                            pp.add("clazz", (Object)BackupExecutionAdapter.class.getSimpleName());
                        } else if (bkp instanceof RestoreExecutionAdapter) {
                            pp.add("clazz", (Object)RestoreExecutionAdapter.class.getSimpleName());
                        }
                        this.setResponsePage(BackupRestorePage.class, pp);
                    }
                    catch (NoSuchJobExecutionException | JobExecutionAlreadyRunningException e) {
                        this.error((Serializable)((Object)e));
                        LOGGER.log(Level.WARNING, "", e);
                    }
                }
            }
        };
        cancelLink.setEnabled(this.doSelectReady(bkp));
        this.add(new Component[]{cancelLink});
        AjaxLink doneLink = new AjaxLink("done"){

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                this.setResponsePage(BackupRestoreDataPage.class);
            }
        };
        this.add(new Component[]{doneLink});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
    }

    private boolean doSelectReady(AbstractExecutionAdapter bkp) {
        return bkp.getStatus() != BatchStatus.COMPLETED && bkp.getStatus() != BatchStatus.FAILED && bkp.getStatus() != BatchStatus.ABANDONED;
    }

    public String getAjaxIndicatorMarkupId() {
        return null;
    }

    void setLinkEnabled(AjaxLink link, boolean enabled, AjaxRequestTarget target) {
        link.setEnabled(enabled);
        target.add(new Component[]{link});
    }

    class BKErrorDetailsModel<T extends AbstractExecutionAdapter>
    extends LoadableDetachableModel<String> {
        long contextId;

        public BKErrorDetailsModel(AbstractExecutionAdapter bkp) {
            this.contextId = bkp.getId();
        }

        protected String load() {
            AbstractExecutionAdapter ctx = null;
            if (BackupRestorePage.this.getType() == BackupExecutionAdapter.class) {
                ctx = (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getBackupExecutions().get(this.contextId);
            } else if (BackupRestorePage.this.getType() == RestoreExecutionAdapter.class) {
                ctx = (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getRestoreExecutions().get(this.contextId);
            }
            StringBuilder buf = new StringBuilder();
            if (!ctx.getAllFailureExceptions().isEmpty()) {
                for (Throwable ex : ctx.getAllFailureExceptions()) {
                    ex = this.writeException(buf, ex, Level.SEVERE);
                }
            } else {
                buf.append("\nNO Exceptions Detected.\n");
            }
            if (!ctx.getAllWarningExceptions().isEmpty()) {
                for (Throwable ex : ctx.getAllWarningExceptions()) {
                    ex = this.writeException(buf, ex, Level.WARNING);
                }
            } else {
                buf.append("\nNO Warnings Detected.\n");
            }
            return buf.toString();
        }

        private Throwable writeException(StringBuilder buf, Throwable ex, Level level) {
            int cnt = 0;
            while (ex != null) {
                if (buf.length() > 0) {
                    buf.append('\n');
                }
                if (ex.getMessage() != null) {
                    buf.append(level).append(":");
                    buf.append(ex.getMessage());
                    ++cnt;
                }
                if (BackupRestorePage.this.expand > 0 && BackupRestorePage.this.expand >= cnt) {
                    StringWriter errors = new StringWriter();
                    ex.printStackTrace(new PrintWriter(errors));
                    buf.append('\n').append(errors.toString());
                }
                ex = ex.getCause();
            }
            return ex;
        }
    }

    class DataTitleModel<T extends AbstractExecutionAdapter>
    extends LoadableDetachableModel<String> {
        long contextId;
        boolean abbrev;
        final /* synthetic */ BackupRestorePage this$0;

        DataTitleModel(T bkp) {
            this(this$0, (AbstractExecutionAdapter)bkp, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        DataTitleModel(T bkp, boolean abbrev) {
            this.this$0 = (BackupRestorePage)this$0;
            this.contextId = bkp.getId();
            this.abbrev = abbrev;
        }

        protected String load() {
            String title;
            AbstractExecutionAdapter ctx = null;
            if (this.this$0.getType() == BackupExecutionAdapter.class) {
                ctx = (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getBackupExecutions().get(this.contextId);
            } else if (this.this$0.getType() == RestoreExecutionAdapter.class) {
                ctx = (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getRestoreExecutions().get(this.contextId);
            }
            String string = title = ctx.getArchiveFile() != null ? ctx.getArchiveFile().path() : ctx.toString();
            if (this.abbrev && title.length() > 70) {
                title = title.substring(0, 20) + "[...]" + title.substring(title.length() - 50);
            }
            title = title + " [" + BackupRestoreWebUtils.humanReadableByteCount(FileUtils.sizeOf((File)ctx.getArchiveFile().file()), false) + "]";
            return title;
        }
    }
}

