/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.awt.RenderingHints;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AbstractAjaxTimerBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.behavior.IBehaviorListener;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.util.time.Duration;
import org.geoserver.backuprestore.AbstractExecutionAdapter;
import org.geoserver.backuprestore.Backup;
import org.geoserver.backuprestore.BackupExecutionAdapter;
import org.geoserver.backuprestore.RestoreExecutionAdapter;
import org.geoserver.backuprestore.web.BackupRestoreExecutionsProvider;
import org.geoserver.backuprestore.web.BackupRestoreExecutionsTable;
import org.geoserver.backuprestore.web.BackupRestoreLayersIndexModel;
import org.geoserver.backuprestore.web.BackupRestorePage;
import org.geoserver.backuprestore.web.BackupRestoreStoresIndexModel;
import org.geoserver.backuprestore.web.BackupRestoreWebUtils;
import org.geoserver.backuprestore.web.BackupRestoreWorkspacesIndexModel;
import org.geoserver.backuprestore.web.LayerChoiceRenderer;
import org.geoserver.backuprestore.web.LayerModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.backuprestore.web.StoreChoiceRenderer;
import org.geoserver.backuprestore.web.StoreModel;
import org.geoserver.backuprestore.web.WorkspaceChoiceRenderer;
import org.geoserver.backuprestore.web.WorkspaceModel;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.platform.resource.Resource;
import org.geoserver.platform.resource.Resources;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.GeoServerUnlockablePage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.NoSuchJobExecutionException;

public class BackupRestoreDataPage
extends GeoServerSecuredPage
implements GeoServerUnlockablePage {
    static Logger LOGGER = Logging.getLogger(BackupRestoreDataPage.class);
    WorkspaceModel workspace;
    DropDownChoice workspaceChoice;
    TextField workspaceNameTextField;
    StoreModel<StoreInfo> store;
    DropDownChoice<StoreInfo> storeChoice;
    LayerModel<LayerInfo> layer;
    DropDownChoice<LayerInfo> layerChoice;
    Component statusLabel;
    BackupRestoreExecutionsTable backupRestoreExecutionsTable;
    BackupRestoreExecutionsTable restoreExecutionsTable;
    ResourceFilePanel backupRestoreFileResource = new ResourceFilePanel("backupResource", this);
    GeoServerDialog dialog;

    public BackupRestoreDataPage(PageParameters params) {
        this.add(new Component[]{this.backupRestoreFileResource});
        Catalog catalog = GeoServerApplication.get().getCatalog();
        this.workspace = new WorkspaceModel<Object>(this.backupRestoreFileResource, null);
        this.workspaceChoice = new DropDownChoice("workspace", (IModel)this.workspace, (IModel)new BackupRestoreWorkspacesIndexModel(this.backupRestoreFileResource), (IChoiceRenderer)new WorkspaceChoiceRenderer());
        this.workspaceChoice.setOutputMarkupId(true);
        this.workspaceChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                BackupRestoreDataPage.this.updateTargetWorkspace(target);
            }
        }});
        this.workspaceChoice.setNullValid(true);
        this.add(new Component[]{this.workspaceChoice});
        WebMarkupContainer workspaceNameContainer = new WebMarkupContainer("workspaceNameContainer");
        workspaceNameContainer.setOutputMarkupId(true);
        this.add(new Component[]{workspaceNameContainer});
        this.workspaceNameTextField = new TextField("workspaceName", (IModel)new Model());
        this.workspaceNameTextField.setOutputMarkupId(true);
        boolean defaultWorkspace = catalog.getDefaultWorkspace() != null;
        this.workspaceNameTextField.setVisible(!defaultWorkspace);
        this.workspaceNameTextField.setRequired(!defaultWorkspace);
        workspaceNameContainer.add(new Component[]{this.workspaceNameTextField});
        this.store = new StoreModel<Object>(this.backupRestoreFileResource, null);
        this.storeChoice = new DropDownChoice<StoreInfo>("store", this.store, (IModel)new BackupRestoreStoresIndexModel(this.workspace, this.backupRestoreFileResource), (IChoiceRenderer)new StoreChoiceRenderer()){

            protected String getNullValidKey() {
                return BackupRestoreDataPage.class.getSimpleName() + "." + super.getNullValidKey();
            }
        };
        this.storeChoice.setOutputMarkupId(true);
        this.storeChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                BackupRestoreDataPage.this.updateTargetStore(target);
            }
        }});
        this.storeChoice.setNullValid(true);
        this.add(new Component[]{this.storeChoice});
        this.layer = new LayerModel<Object>(this.backupRestoreFileResource, null);
        this.layerChoice = new DropDownChoice<LayerInfo>("layer", this.layer, (IModel)new BackupRestoreLayersIndexModel(this.store, this.backupRestoreFileResource), (IChoiceRenderer)new LayerChoiceRenderer()){

            protected String getNullValidKey() {
                return BackupRestoreDataPage.class.getSimpleName() + "." + super.getNullValidKey();
            }
        };
        this.layerChoice.setOutputMarkupId(true);
        this.layerChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){

            protected void onUpdate(AjaxRequestTarget target) {
                BackupRestoreDataPage.this.updateTargetLayer(target);
            }
        }});
        this.layerChoice.setNullValid(true);
        this.add(new Component[]{this.layerChoice});
        Form backupForm = new Form("backupForm");
        this.add(new Component[]{backupForm});
        this.populateBackupForm(backupForm);
        Form restoreForm = new Form("restoreForm");
        this.add(new Component[]{restoreForm});
        this.populateRestoreForm(restoreForm);
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setInitialWidth(600);
        this.dialog.setInitialHeight(400);
        this.dialog.setMinimalHeight(150);
    }

    protected void updateTargetWorkspace(AjaxRequestTarget target) {
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        this.workspaceNameTextField.setVisible(ws == null);
        this.workspaceNameTextField.setRequired(ws == null);
        if (target != null) {
            target.add(new Component[]{this.storeChoice});
            target.add(new Component[]{this.layerChoice});
            target.add(new Component[]{this.workspaceNameTextField.getParent()});
        }
    }

    protected void updateTargetStore(AjaxRequestTarget target) {
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        this.workspaceNameTextField.setVisible(ws == null);
        this.workspaceNameTextField.setRequired(ws == null);
        if (target != null) {
            target.add(new Component[]{this.layerChoice});
            target.add(new Component[]{this.workspaceNameTextField.getParent()});
        }
    }

    protected void updateTargetLayer(AjaxRequestTarget target) {
        WorkspaceInfo ws = (WorkspaceInfo)this.workspace.getObject();
        this.workspaceNameTextField.setVisible(ws == null);
        this.workspaceNameTextField.setRequired(ws == null);
        if (target != null) {
            target.add(new Component[]{this.layerChoice});
            target.add(new Component[]{this.workspaceNameTextField.getParent()});
        }
    }

    private void populateBackupForm(Form form) {
        form.add(new Component[]{new CheckBox("backupOptOverwirte", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        form.add(new Component[]{new CheckBox("backupOptBestEffort", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        form.add(new Component[]{new CheckBox("backupOptCleanTemp", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        this.statusLabel = new Label("status", (IModel)new Model()).setOutputMarkupId(true);
        form.add(new Component[]{this.statusLabel});
        form.add(new Component[]{new AjaxSubmitLink("newBackupStart", form){

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                BackupRestoreDataPage.this.addFeedbackPanels(target);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target, final Form<?> form) {
                Long jobid;
                BackupRestoreDataPage.this.statusLabel.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"working-link"))});
                BackupRestoreDataPage.this.statusLabel.setDefaultModelObject((Object)"Working");
                target.add(new Component[]{BackupRestoreDataPage.this.statusLabel});
                Component cancel = form.get("cancel");
                cancel.setEnabled(true);
                target.add(new Component[]{cancel});
                this.setEnabled(false);
                target.add(new Component[]{this});
                final 6 self = this;
                try {
                    jobid = this.launchBackupExecution(form);
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, "Error starting a new Backup", e);
                    return;
                }
                finally {
                    BackupRestoreDataPage.this.resetButtons(form, target, "newBackupStart");
                    BackupRestoreDataPage.this.addFeedbackPanels(target);
                }
                cancel.setDefaultModelObject((Object)jobid);
                this.add(new Behavior[]{new AbstractAjaxTimerBehavior(Duration.milliseconds((long)100L)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onTimer(AjaxRequestTarget target) {
                        Backup backupFacade = BackupRestoreWebUtils.backupFacade();
                        BackupExecutionAdapter exec = (BackupExecutionAdapter)backupFacade.getBackupExecutions().get(jobid);
                        if (!exec.isRunning()) {
                            try {
                                if (exec.getAllFailureExceptions() != null && !exec.getAllFailureExceptions().isEmpty()) {
                                    this.getSession().error((Serializable)exec.getAllFailureExceptions().get(0));
                                    this.setResponsePage(BackupRestoreDataPage.class);
                                } else if (exec.isStopping()) {
                                } else {
                                    PageParameters pp = new PageParameters();
                                    pp.add("id", (Object)exec.getId());
                                    pp.add("clazz", (Object)BackupExecutionAdapter.class.getSimpleName());
                                    this.setResponsePage(BackupRestorePage.class, pp);
                                }
                            }
                            catch (Exception e) {
                                this.error(e);
                                LOGGER.log(Level.WARNING, "", e);
                            }
                            finally {
                                this.stop(null);
                                BackupRestoreDataPage.this.resetButtons(form, target, "newBackupStart");
                                BackupRestoreDataPage.this.addFeedbackPanels(target);
                            }
                            return;
                        }
                        String msg = exec != null ? exec.getStatus().toString() : "Working";
                        BackupRestoreDataPage.this.statusLabel.setDefaultModelObject((Object)msg);
                        target.add(new Component[]{BackupRestoreDataPage.this.statusLabel});
                    }

                    public boolean canCallListenerInterface(Component component, Method method) {
                        if (self.equals(component) && method.getDeclaringClass().equals(IBehaviorListener.class) && method.getName().equals("onRequest")) {
                            return true;
                        }
                        return super.canCallListenerInterface(component, method);
                    }
                }});
            }

            private Long launchBackupExecution(Form<?> form) throws Exception {
                Resource archiveFile = BackupRestoreDataPage.this.getBackupRestoreArchiveResource(true);
                Filter wsFilter = null;
                Filter siFilter = null;
                Filter liFilter = null;
                WorkspaceInfo ws = (WorkspaceInfo)BackupRestoreDataPage.this.workspace.getObject();
                StoreInfo si = (StoreInfo)BackupRestoreDataPage.this.store.getObject();
                LayerInfo li = (LayerInfo)BackupRestoreDataPage.this.layer.getObject();
                if (ws != null) {
                    wsFilter = Predicates.or((Filter[])new Filter[]{Predicates.equal((String)"name", (Object)ws.getName()), Predicates.equal((String)"workspace.name", (Object)ws.getName()), Predicates.equal((String)"resource.store.workspace.name", (Object)ws.getName())});
                }
                if (si != null) {
                    siFilter = Predicates.or((Filter)Predicates.equal((String)"name", (Object)si.getName()), (Filter)Predicates.equal((String)"resource.store.name", (Object)si.getName()));
                }
                if (li != null) {
                    liFilter = Predicates.or((Filter)Predicates.equal((String)"name", (Object)li.getName()), (Filter)Predicates.equal((String)"resource.name", (Object)li.getResource().getName()));
                }
                Hints hints = new Hints(new HashMap(2));
                Boolean backupOptOverwirte = (Boolean)((CheckBox)form.get("backupOptOverwirte")).getModelObject();
                Boolean backupOptBestEffort = (Boolean)((CheckBox)form.get("backupOptBestEffort")).getModelObject();
                Boolean backupOptCleanTemp = (Boolean)((CheckBox)form.get("backupOptCleanTemp")).getModelObject();
                if (backupOptBestEffort.booleanValue()) {
                    hints.add((RenderingHints)new Hints((RenderingHints.Key)new Hints.OptionKey(new String[]{"BK_BEST_EFFORT"}), (Object)"BK_BEST_EFFORT"));
                }
                if (backupOptCleanTemp.booleanValue()) {
                    hints.add((RenderingHints)new Hints((RenderingHints.Key)new Hints.OptionKey(new String[]{"BK_CLEANUP_TEMP"}), (Object)"BK_CLEANUP_TEMP"));
                }
                Backup backupFacade = BackupRestoreWebUtils.backupFacade();
                return backupFacade.runBackupAsync(archiveFile, backupOptOverwirte.booleanValue(), wsFilter, siFilter, liFilter, hints).getId();
            }
        }});
        form.add(new Component[]{new AjaxLink<Long>("cancel", (IModel)new Model()){

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                Long jobid = (Long)this.getModelObject();
                if (jobid != null) {
                    try {
                        BackupRestoreWebUtils.backupFacade().stopExecution(jobid);
                        this.setResponsePage(BackupRestoreDataPage.class);
                    }
                    catch (JobExecutionNotRunningException | NoSuchJobExecutionException e) {
                        LOGGER.log(Level.WARNING, "", e);
                    }
                }
                this.setEnabled(false);
                target.add(new Component[]{this});
            }
        }.setOutputMarkupId(true).setEnabled(false)});
        this.backupRestoreExecutionsTable = new BackupRestoreExecutionsTable("backups", new BackupRestoreExecutionsProvider(true, BackupExecutionAdapter.class){

            @Override
            protected List<GeoServerDataProvider.Property<AbstractExecutionAdapter>> getProperties() {
                return Arrays.asList(ID, STATE, STARTED, PROGRESS, ARCHIVEFILE, OPTIONS);
            }
        }, true, BackupExecutionAdapter.class){

            protected void onSelectionUpdate(AjaxRequestTarget target) {
            }
        };
        this.backupRestoreExecutionsTable.setOutputMarkupId(true);
        this.backupRestoreExecutionsTable.setFilterable(false);
        this.backupRestoreExecutionsTable.setSortable(false);
        form.add(new Component[]{this.backupRestoreExecutionsTable});
    }

    private void populateRestoreForm(Form form) {
        form.add(new Component[]{new CheckBox("restoreOptDryRun", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        form.add(new Component[]{new CheckBox("restoreOptBestEffort", (IModel)new Model((Serializable)Boolean.valueOf(false)))});
        form.add(new Component[]{new CheckBox("restoreOptCleanTemp", (IModel)new Model((Serializable)Boolean.valueOf(true)))});
        this.statusLabel = new Label("status", (IModel)new Model()).setOutputMarkupId(true);
        form.add(new Component[]{this.statusLabel});
        form.add(new Component[]{new AjaxSubmitLink("newRestoreStart", form){

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                BackupRestoreDataPage.this.addFeedbackPanels(target);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onSubmit(AjaxRequestTarget target, final Form<?> form) {
                Long jobid;
                BackupRestoreDataPage.this.statusLabel.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)"working-link"))});
                BackupRestoreDataPage.this.statusLabel.setDefaultModelObject((Object)"Working");
                target.add(new Component[]{BackupRestoreDataPage.this.statusLabel});
                Component cancel = form.get("cancel");
                cancel.setEnabled(true);
                target.add(new Component[]{cancel});
                this.setEnabled(false);
                target.add(new Component[]{this});
                final 10 self = this;
                try {
                    jobid = this.launchRestoreExecution(form);
                }
                catch (Exception e) {
                    this.error(e);
                    LOGGER.log(Level.WARNING, "Error starting a new Restore", e);
                    return;
                }
                finally {
                    BackupRestoreDataPage.this.resetButtons(form, target, "newRestoreStart");
                    BackupRestoreDataPage.this.addFeedbackPanels(target);
                }
                cancel.setDefaultModelObject((Object)jobid);
                this.add(new Behavior[]{new AbstractAjaxTimerBehavior(Duration.milliseconds((long)100L)){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected void onTimer(AjaxRequestTarget target) {
                        Backup backupFacade = BackupRestoreWebUtils.backupFacade();
                        RestoreExecutionAdapter exec = (RestoreExecutionAdapter)backupFacade.getRestoreExecutions().get(jobid);
                        if (!exec.isRunning()) {
                            try {
                                if (exec.getAllFailureExceptions() != null && !exec.getAllFailureExceptions().isEmpty()) {
                                    this.getSession().error((Serializable)exec.getAllFailureExceptions().get(0));
                                    this.setResponsePage(BackupRestoreDataPage.class);
                                } else if (exec.isStopping()) {
                                } else {
                                    PageParameters pp = new PageParameters();
                                    pp.add("id", (Object)exec.getId());
                                    pp.add("clazz", (Object)RestoreExecutionAdapter.class.getSimpleName());
                                    this.setResponsePage(BackupRestorePage.class, pp);
                                }
                            }
                            catch (Exception e) {
                                this.error(e);
                                LOGGER.log(Level.WARNING, "", e);
                            }
                            finally {
                                this.stop(null);
                                BackupRestoreDataPage.this.resetButtons(form, target, "newRestoreStart");
                                BackupRestoreDataPage.this.addFeedbackPanels(target);
                            }
                            return;
                        }
                        String msg = exec != null ? exec.getStatus().toString() : "Working";
                        BackupRestoreDataPage.this.statusLabel.setDefaultModelObject((Object)msg);
                        target.add(new Component[]{BackupRestoreDataPage.this.statusLabel});
                    }

                    public boolean canCallListenerInterface(Component component, Method method) {
                        if (self.equals(component) && method.getDeclaringClass().equals(IBehaviorListener.class) && method.getName().equals("onRequest")) {
                            return true;
                        }
                        return super.canCallListenerInterface(component, method);
                    }
                }});
            }

            private Long launchRestoreExecution(Form<?> form) throws Exception {
                Boolean restoreOptCleanTemp;
                Boolean restoreOptBestEffort;
                Resource archiveFile = BackupRestoreDataPage.this.getBackupRestoreArchiveResource(false);
                Filter wsFilter = null;
                Filter siFilter = null;
                Filter liFilter = null;
                WorkspaceInfo ws = (WorkspaceInfo)BackupRestoreDataPage.this.workspace.getObject();
                StoreInfo si = (StoreInfo)BackupRestoreDataPage.this.store.getObject();
                LayerInfo li = (LayerInfo)BackupRestoreDataPage.this.layer.getObject();
                if (ws != null) {
                    wsFilter = Predicates.or((Filter[])new Filter[]{Predicates.equal((String)"name", (Object)ws.getName()), Predicates.equal((String)"workspace.name", (Object)ws.getName()), Predicates.equal((String)"resource.store.workspace.name", (Object)ws.getName())});
                }
                if (si != null) {
                    siFilter = Predicates.or((Filter)Predicates.equal((String)"name", (Object)si.getName()), (Filter)Predicates.equal((String)"resource.store.name", (Object)si.getName()));
                }
                if (li != null) {
                    liFilter = Predicates.or((Filter)Predicates.equal((String)"name", (Object)li.getName()), (Filter)Predicates.equal((String)"resource.name", (Object)li.getResource().getName()));
                }
                if (wsFilter == null && BackupRestoreDataPage.this.backupRestoreFileResource.wsFilter != null) {
                    wsFilter = BackupRestoreDataPage.this.backupRestoreFileResource.wsFilter;
                }
                if (siFilter == null && BackupRestoreDataPage.this.backupRestoreFileResource.siFilter != null) {
                    siFilter = BackupRestoreDataPage.this.backupRestoreFileResource.siFilter;
                }
                if (liFilter == null && BackupRestoreDataPage.this.backupRestoreFileResource.liFilter != null) {
                    liFilter = BackupRestoreDataPage.this.backupRestoreFileResource.liFilter;
                }
                Hints hints = new Hints(new HashMap(2));
                Boolean restoreOptDryRun = (Boolean)((CheckBox)form.get("restoreOptDryRun")).getModelObject();
                if (restoreOptDryRun.booleanValue()) {
                    hints.add((RenderingHints)new Hints((RenderingHints.Key)new Hints.OptionKey(new String[]{"BK_DRY_RUN"}), (Object)"BK_DRY_RUN"));
                }
                if ((restoreOptBestEffort = (Boolean)((CheckBox)form.get("restoreOptBestEffort")).getModelObject()).booleanValue()) {
                    hints.add((RenderingHints)new Hints((RenderingHints.Key)new Hints.OptionKey(new String[]{"BK_BEST_EFFORT"}), (Object)"BK_BEST_EFFORT"));
                }
                if ((restoreOptCleanTemp = (Boolean)((CheckBox)form.get("restoreOptCleanTemp")).getModelObject()).booleanValue()) {
                    hints.add((RenderingHints)new Hints((RenderingHints.Key)new Hints.OptionKey(new String[]{"BK_CLEANUP_TEMP"}), (Object)"BK_CLEANUP_TEMP"));
                }
                Backup backupFacade = BackupRestoreWebUtils.backupFacade();
                return backupFacade.runRestoreAsync(archiveFile, wsFilter, siFilter, liFilter, hints).getId();
            }
        }});
        form.add(new Component[]{new AjaxLink<Long>("cancel", (IModel)new Model()){

            protected void disableLink(ComponentTag tag) {
                super.disableLink(tag);
                tag.setName("a");
                tag.addBehavior((Behavior)AttributeModifier.replace((String)"class", (Serializable)((Object)"disabled")));
            }

            public void onClick(AjaxRequestTarget target) {
                Long jobid = (Long)this.getModelObject();
                if (jobid != null) {
                    try {
                        BackupRestoreWebUtils.backupFacade().stopExecution(jobid);
                        this.setResponsePage(BackupRestoreDataPage.class);
                    }
                    catch (JobExecutionNotRunningException | NoSuchJobExecutionException e) {
                        LOGGER.log(Level.WARNING, "", e);
                    }
                }
                this.setEnabled(false);
                target.add(new Component[]{this});
            }
        }.setOutputMarkupId(true).setEnabled(false)});
        this.restoreExecutionsTable = new BackupRestoreExecutionsTable("restores", new BackupRestoreExecutionsProvider(true, RestoreExecutionAdapter.class){

            @Override
            protected List<GeoServerDataProvider.Property<AbstractExecutionAdapter>> getProperties() {
                return Arrays.asList(ID, STATE, STARTED, PROGRESS, ARCHIVEFILE, OPTIONS);
            }
        }, true, RestoreExecutionAdapter.class){

            protected void onSelectionUpdate(AjaxRequestTarget target) {
            }
        };
        this.restoreExecutionsTable.setOutputMarkupId(true);
        this.restoreExecutionsTable.setFilterable(false);
        this.restoreExecutionsTable.setSortable(false);
        form.add(new Component[]{this.restoreExecutionsTable});
    }

    protected Resource getBackupRestoreArchiveResource(boolean isBackup) throws Exception {
        Resource archiveFile = null;
        try {
            archiveFile = this.backupRestoreFileResource.getResource();
        }
        catch (NullPointerException e) {
            throw new Exception("Restore Archive File is Mandatory!");
        }
        if (archiveFile == null || !isBackup && !Resources.exists((Resource)archiveFile) || archiveFile.getType() == Resource.Type.DIRECTORY || FilenameUtils.getExtension((String)archiveFile.name()).isEmpty()) {
            throw new Exception("Archive File is Mandatory, must exists and should not be a Directory or URI.");
        }
        return archiveFile;
    }

    protected void resetButtons(Form<?> form, AjaxRequestTarget target, String buttonId) {
        form.get(buttonId).setEnabled(true);
        this.statusLabel.setDefaultModelObject((Object)"");
        this.statusLabel.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)""))});
        target.add(new Component[]{form.get(buttonId)});
        target.add(new Component[]{form.get("status")});
    }
}

