/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.AbstractExecutionAdapter;
import org.geoserver.backuprestore.BackupExecutionAdapter;
import org.geoserver.backuprestore.RestoreExecutionAdapter;
import org.geoserver.backuprestore.web.BackupRestoreWebUtils;
import org.geotools.util.logging.Logging;

public class BackupRestoreExecutionModel<T extends AbstractExecutionAdapter>
extends LoadableDetachableModel<AbstractExecutionAdapter> {
    static Logger LOGGER = Logging.getLogger(BackupRestoreExecutionModel.class);
    long id;
    private Class<T> clazz;

    public BackupRestoreExecutionModel(AbstractExecutionAdapter exec, Class<T> clazz) {
        this(exec.getId(), clazz);
    }

    public BackupRestoreExecutionModel(long id, Class<T> clazz) {
        this.id = id;
        this.clazz = clazz;
    }

    public Class<T> getType() {
        return this.clazz;
    }

    protected AbstractExecutionAdapter load() {
        try {
            if (this.getType() == BackupExecutionAdapter.class) {
                return (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getBackupExecutions().get(this.id);
            }
            if (this.getType() == RestoreExecutionAdapter.class) {
                return (AbstractExecutionAdapter)BackupRestoreWebUtils.backupFacade().getRestoreExecutions().get(this.id);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to load execution " + this.id, e);
            return null;
        }
    }
}

