/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.backuprestore.web;

import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.geoserver.backuprestore.web.ResourceFilePanel;
import org.geoserver.backuprestore.web.StoreModel;
import org.geoserver.backuprestore.web.WorkspaceModel;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.web.GeoServerApplication;

public class LayerModel<T extends LayerInfo>
extends LoadableDetachableModel<T> {
    private static final long serialVersionUID = 1619470274815042758L;
    private ResourceFilePanel resourceFilePanel;
    IModel workspace;
    IModel store;
    String name;

    private LayerModel(T store) {
        super(store);
        this.setObject(store);
    }

    public LayerModel(ResourceFilePanel resourceFilePanel, T layer) {
        this(layer);
        this.resourceFilePanel = resourceFilePanel;
    }

    public void setObject(T object) {
        super.setObject(object);
        if (object != null) {
            this.workspace = new WorkspaceModel<WorkspaceInfo>(this.resourceFilePanel, object.getResource().getStore().getWorkspace());
            this.store = new StoreModel<StoreInfo>(this.resourceFilePanel, object.getResource().getStore());
            this.name = object.getName();
        } else {
            this.name = null;
        }
    }

    protected T load() {
        LayerInfo li;
        if (this.store == null) {
            return null;
        }
        if (this.name == null) {
            return null;
        }
        if (this.resourceFilePanel != null && this.resourceFilePanel.getLayers() != null && !this.resourceFilePanel.getLayers().isEmpty() && this.store.getObject() != null && this.resourceFilePanel.getLayers().containsKey(((StoreInfo)this.store.getObject()).getName())) {
            for (LayerInfo ly : this.resourceFilePanel.getLayers().get(((StoreInfo)this.store.getObject()).getName())) {
                if (!ly.getName().equals(this.name)) continue;
                return (T)ly;
            }
        }
        if ((li = GeoServerApplication.get().getCatalog().getLayerByName(this.name)) != null && li.getResource() != null && li.getResource().getStore() != null && li.getResource().getStore().getName().equals(((StoreInfo)this.store.getObject()).getName())) {
            return (T)li;
        }
        return (T)((LayerInfo)this.getObject());
    }

    public void detach() {
        super.detach();
        if (this.store != null) {
            this.store.detach();
        }
    }
}

