/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.opensdi2.mvc;

import it.geosolutions.httpproxy.service.ProxyConfig;
import it.geosolutions.httpproxy.service.ProxyService;
import it.geosolutions.opensdi.dto.CRUDResponseWrapper;
import it.geosolutions.opensdi2.crud.api.PagebleEntityCRUDController;
import it.geosolutions.opensdi2.exceptions.RESTControllerException;
import it.geosolutions.opensdi2.model.mapping.EndPointMapping;
import it.geosolutions.opensdi2.model.mapping.facade.ProxyConfigBean;
import it.geosolutions.opensdi2.service.impl.URLFacadeImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Controller
@RequestMapping(value={"/OpenSDIInfo"})
public class EndpointDocController
implements PagebleEntityCRUDController<EndPointMapping> {
    private final RequestMappingHandlerMapping handlerMapping;
    @Autowired
    private URLFacadeImpl urlFacade;

    @Autowired
    public EndpointDocController(RequestMappingHandlerMapping handlerMapping) {
        this.handlerMapping = handlerMapping;
    }

    @ResponseBody
    public List<EndPointMapping> show() {
        ArrayList<EndPointMapping> results = new ArrayList<EndPointMapping>();
        Map mappings = this.handlerMapping.getHandlerMethods();
        for (RequestMappingInfo info : mappings.keySet()) {
            EndPointMapping result = new EndPointMapping();
            result.setMethod((HandlerMethod)mappings.get(info));
            result.setInfo(info);
            results.add(result);
        }
        return results;
    }

    @RequestMapping(value={"endpointdoc"}, method={RequestMethod.GET})
    @ResponseBody
    public CRUDResponseWrapper<EndPointMapping> list(Integer start, Integer limit) throws RESTControllerException {
        CRUDResponseWrapper response = new CRUDResponseWrapper();
        List<EndPointMapping> results = this.show();
        response.setData(results);
        response.setCount(results.size());
        response.setTotalCount((long)results.size());
        return response;
    }

    @RequestMapping(value={"facade"}, method={RequestMethod.GET})
    @ResponseBody
    public CRUDResponseWrapper<Map<String, Object>> listfacade(Integer start, Integer limit) throws RESTControllerException {
        CRUDResponseWrapper response = new CRUDResponseWrapper();
        Map results = this.urlFacade.getCustomizedProxies();
        ArrayList list = new ArrayList();
        for (String key : results.keySet()) {
            HashMap<String, String> obj = new HashMap<String, String>();
            obj.put("path", key);
            obj.put("proxy", (String)this.getProxyConfig(((ProxyService)results.get(key)).getProxyConfig()));
            obj.put("urlWrapped", (String)this.urlFacade.getUrlsWrapped().get(key));
            list.add(obj);
        }
        response.setData(list);
        response.setCount(list.size());
        response.setTotalCount((long)list.size());
        return response;
    }

    private ProxyConfig getProxyConfig(ProxyConfig proxyConfig) {
        return new ProxyConfigBean(proxyConfig);
    }
}

