/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.rest.config;

import it.geosolutions.mapstore.controllers.BaseConfigController;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.HandlerMapping;

@Controller
public class LoadAssetsController
extends BaseConfigController {
    @Value(value="${allowed.resources:localConfig,pluginsConfig,extensions,config,new}")
    protected String allowedResources = "localConfig,pluginsConfig,extensions,config,new";

    @RequestMapping(value={"/load/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] loadResource(@PathVariable(value="resource") String resourceName, @RequestParam(value="overrides", defaultValue="true") boolean applyOverrides) throws IOException {
        if (this.isAllowed(resourceName = this.normalizeResource(resourceName, "json"))) {
            return this.toBytes(this.readResource(resourceName + ".json", applyOverrides, resourceName + ".json.patch"));
        }
        throw new BaseConfigController.ResourceNotAllowedException(this, "Resource is not allowed");
    }

    private String normalizeResource(String name, String extension) {
        if (name.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return name.substring(0, name.length() - 1 - extension.length());
        }
        return name;
    }

    @RequestMapping(value={"/loadasset/**"}, method={RequestMethod.GET})
    public void loadAsset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resourcePath = ((String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE)).split("/loadasset/")[0];
        if (Paths.get(resourcePath, new String[0]).isAbsolute()) {
            throw new IOException("Absolute paths are not allowed!");
        }
        BaseConfigController.Resource resource = this.readResource(resourcePath, false, "");
        response.setContentType(resource.type);
        IOUtils.copy((InputStream)this.toStream(resource), (OutputStream)response.getOutputStream());
    }

    protected boolean isAllowed(final String resourceName) {
        return Stream.of(this.allowedResources.split(",")).anyMatch(new Predicate<String>(){

            @Override
            public boolean test(String p) {
                return p.equals(resourceName);
            }
        });
    }
}

