/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.controllers.configs;

import it.geosolutions.mapstore.controllers.BaseConfigController;
import java.io.IOException;
import java.nio.file.Paths;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class ConfigsController
extends BaseConfigController {
    @RequestMapping(value={"/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] loadResource(@PathVariable(value="resource") String resourceName, @RequestParam(value="overrides", defaultValue="true") boolean applyOverrides) throws IOException {
        return this.toBytes(this.readResource(Paths.get(this.getConfigsFolder(), this.normalizeExtension(resourceName, "json")).toString(), applyOverrides, Paths.get(this.getConfigsFolder(), this.normalizePatchExtension(resourceName, "json", "patch")).toString()));
    }

    private String normalizeExtension(String name, String extension) {
        if (name.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return name;
        }
        return String.valueOf(name) + "." + extension;
    }

    private String normalizePatchExtension(String name, String extension, String patchExtension) {
        if (name.toLowerCase().endsWith("." + extension.toLowerCase())) {
            return String.valueOf(name) + "." + patchExtension;
        }
        return String.valueOf(name) + "." + extension + "." + patchExtension;
    }
}

