/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.ServletContext;

public class ResourceUtils {
    public static Optional<String> findExisting(String[] candidates) {
        return Stream.of(candidates).filter(new Predicate<String>(){

            @Override
            public boolean test(String path) {
                return path != null && new File(path).exists();
            }
        }).findFirst();
    }

    public static Optional<File> findResource(String baseFolders, ServletContext context, final String resourceName) {
        String[] candidates = (String[])Stream.concat(Stream.of(baseFolders.split(",")).filter(new Predicate<String>(){

            @Override
            public boolean test(String string) {
                return string != null && !"".equals(string);
            }
        }).map(new Function<String, String>(){

            @Override
            public String apply(String f) {
                return f + "/" + resourceName;
            }
        }), Stream.of(new String[]{context.getRealPath(resourceName)})).toArray((IntFunction<A[]>)new IntFunction<String[]>(){

            @Override
            public String[] apply(int size) {
                return new String[size];
            }
        });
        Optional<String> resourcePath = ResourceUtils.findExisting(candidates);
        if (resourcePath.isPresent()) {
            return Optional.of(new File(resourcePath.get()));
        }
        return Optional.empty();
    }

    public static String getResourcePath(String baseFolder, ServletContext context, String path) {
        return ResourceUtils.getResourcePath(baseFolder, context, path, false);
    }

    public static String getResourcePath(String baseFolder, ServletContext context, String path, boolean write) {
        return baseFolder.isEmpty() ? ResourceUtils.getContextPath(context, path, write) : baseFolder + "/" + path;
    }

    private static String getContextPath(ServletContext context, String path, boolean write) {
        String candidate = context.getRealPath(path);
        if (candidate == null && write) {
            candidate = context.getRealPath("") + "/" + path;
        }
        return candidate;
    }

    public static void storeJSONConfig(String baseFolder, ServletContext context, Object config, String configName) throws FileNotFoundException, IOException {
        String outputFile = ResourceUtils.getResourcePath(baseFolder, context, configName, true);
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            output.write(config.toString().getBytes());
        }
    }
}

