/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.mapstore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import it.geosolutions.mapstore.utils.ResourceUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.HandlerMapping;

@Controller
public class ConfigController {
    private ObjectMapper jsonMapper = new ObjectMapper();
    @Value(value="${datadir.location:}")
    private String dataDir = "";
    @Value(value="${allowed.resources:localConfig,pluginsConfig,extensions,config,new}")
    private String allowedResources = "localConfig,pluginsConfig,extensions,config,new";
    @Value(value="${overrides.mappings:}")
    private String mappings;
    @Value(value="${overrides.config:}")
    private String overrides = "";
    @Autowired
    private ServletContext context;

    @RequestMapping(value={"/load/{resource}"}, method={RequestMethod.GET})
    @ResponseBody
    public byte[] loadResource(@PathVariable(value="resource") String resourceName, @RequestParam(value="overrides", defaultValue="true") boolean applyOverrides) throws IOException {
        if (this.isAllowed(resourceName)) {
            return this.toBytes(this.readResource(resourceName + ".json", applyOverrides, resourceName + ".json.patch"));
        }
        throw new ResourceNotAllowedException("Resource is not allowed");
    }

    public byte[] loadAsset(String resourcePath) throws IOException {
        return this.toBytes(this.readResource(resourcePath, false, ""));
    }

    @RequestMapping(value={"/loadasset/**"}, method={RequestMethod.GET})
    public void loadAsset(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resourcePath = ((String)request.getAttribute(HandlerMapping.PATH_WITHIN_HANDLER_MAPPING_ATTRIBUTE)).split("/loadasset/")[0];
        if (Paths.get(resourcePath, new String[0]).isAbsolute()) {
            throw new IOException("Absolute paths are not allowed!");
        }
        Resource resource = this.readResource(resourcePath, false, "");
        response.setContentType(resource.type);
        IOUtils.copy((InputStream)this.toStream(resource), (OutputStream)response.getOutputStream());
    }

    private InputStream toStream(Resource resource) throws IOException {
        if (resource.data != null) {
            byte[] bytes = this.toBytes(resource);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return in;
        }
        if (resource.file != null) {
            return new FileInputStream(resource.file);
        }
        return null;
    }

    private byte[] toBytes(Resource resource) throws UnsupportedEncodingException {
        return resource.data.getBytes("UTF-8");
    }

    private Resource readResource(String resourceName, boolean applyOverrides, String patchName) throws IOException {
        Optional<File> resourcePatch;
        Optional<File> resource = ResourceUtils.findResource(this.dataDir, this.context, resourceName);
        Optional<File> optional = resourcePatch = patchName.isEmpty() ? Optional.empty() : ResourceUtils.findResource(this.dataDir, this.context, patchName);
        if (!resource.isPresent()) {
            throw new ResourceNotFoundException(resourceName);
        }
        return this.readResourceFromFile(resource.get(), applyOverrides, resourcePatch);
    }

    private Resource readResourceFromFile(File file, boolean applyOverrides, Optional<File> patch) throws IOException {
        Resource resource = new Resource();
        resource.file = file;
        MimeType type = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((File)file));
        resource.type = type != null ? type.toString() : null;
        try (Stream<String> stream = Files.lines(Paths.get(file.getAbsolutePath(), new String[0]), StandardCharsets.UTF_8);){
            Properties props = this.readOverrides();
            if (applyOverrides && (!"".equals(this.mappings) && props != null || patch.isPresent())) {
                resource.data = this.resourceWithPatch(stream, props, patch);
                Resource resource2 = resource;
                return resource2;
            }
            try {
                final StringBuilder contentBuilder = new StringBuilder();
                stream.forEach(new Consumer<String>(){

                    @Override
                    public void accept(String s) {
                        contentBuilder.append(s).append("\n");
                    }
                });
                resource.data = contentBuilder.toString();
            }
            catch (Exception e) {
                resource.file = file;
            }
            Resource resource3 = resource;
            return resource3;
        }
    }

    private String resourceWithPatch(Stream<String> stream, Properties props, Optional<File> patch) throws IOException {
        JsonNode jsonObject = this.readJsonConfig(stream);
        if (patch.isPresent()) {
            jsonObject = this.mergeJSON(jsonObject, (JsonPatch)this.jsonMapper.readValue(patch.get(), JsonPatch.class));
        }
        if (!"".equals(this.mappings) && props != null) {
            for (String mapping : this.mappings.split(",")) {
                jsonObject = this.fillMapping(mapping, props, jsonObject);
            }
        }
        return jsonObject.toString();
    }

    private JsonNode mergeJSON(JsonNode orig, JsonPatch patch) throws IOException {
        try {
            return patch.apply(orig);
        }
        catch (JsonPatchException e) {
            throw new IOException("Error applying patch", e);
        }
    }

    private Properties readOverrides() throws FileNotFoundException, IOException {
        Optional<File> resource;
        if (!"".equals(this.overrides) && (resource = ResourceUtils.findResource(this.dataDir, this.context, this.overrides)).isPresent()) {
            try (FileReader reader = new FileReader(resource.get());){
                Properties props = new Properties();
                props.load(reader);
                Properties properties = props;
                return properties;
            }
        }
        return null;
    }

    private JsonNode readJsonConfig(Stream<String> stream) throws IOException {
        final StringBuilder contentBuilder = new StringBuilder();
        stream.forEach(new Consumer<String>(){

            @Override
            public void accept(String s) {
                contentBuilder.append(s).append("\n");
            }
        });
        String json = contentBuilder.toString();
        JsonNode jsonObject = this.jsonMapper.readTree(json);
        return jsonObject;
    }

    private JsonNode fillMapping(String mapping, Properties props, JsonNode jsonObject) throws IOException {
        String[] parts = mapping.split("=");
        if (parts.length != 2 || parts[0].trim().isEmpty() || parts[1].trim().isEmpty()) {
            return jsonObject;
        }
        String path = parts[0];
        String propName = parts[1];
        String value = props.getProperty(propName, "");
        return this.setJsonProperty(jsonObject, path.split("\\."), value);
    }

    private JsonNode setJsonProperty(JsonNode jsonObject, String[] path, String value) throws IOException {
        String propertyPath = "/" + StringUtils.join((Object[])path, (String)"/");
        JsonPatch patch = (JsonPatch)this.jsonMapper.readValue("[{\"op\":\"replace\",\"path\":\"" + propertyPath + "\",\"value\":\"" + value + "\"}]", JsonPatch.class);
        try {
            return this.mergeJSON(jsonObject, patch);
        }
        catch (IOException e) {
            return jsonObject;
        }
    }

    private boolean isAllowed(final String resourceName) {
        return Stream.of(this.allowedResources.split(",")).anyMatch(new Predicate<String>(){

            @Override
            public boolean test(String p) {
                return p.equals(resourceName);
            }
        });
    }

    public void setContext(ServletContext context) {
        this.context = context;
    }

    public void setDataDir(String dataDir) {
        this.dataDir = dataDir;
    }

    public void setMappings(String mappings) {
        this.mappings = mappings;
    }

    public void setOverrides(String overrides) {
        this.overrides = overrides;
    }

    static {
        MimeUtil.registerMimeDetector((String)"eu.medsea.mimeutil.detector.ExtensionMimeDetector");
    }

    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    public class ResourceNotAllowedException
    extends RuntimeException {
        public ResourceNotAllowedException(String message) {
            super(message);
        }
    }

    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public class ResourceNotFoundException
    extends RuntimeException {
        public ResourceNotFoundException(String message) {
            super(message);
        }
    }

    public class Resource {
        String data;
        String type;
        File file;
    }
}

