/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.zonal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.index.strtree.STRtree;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.zonal.ZonalStatsDescriptor;
import it.geosolutions.jaiext.zonal.ZoneGeometry;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.iterator.RandomIter;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZonalStatsTest
extends TestBase {
    private static final double TOLERANCE = 0.1;
    private static final boolean CLASSIFIER = Boolean.getBoolean("JAI.Ext.Classifier");
    private static Statistics.StatsType[] stats;
    private static RenderedImage[] sourceIMG;
    private static List<ROI> roiList;
    private static RenderedImage classifier;
    private static STRtree[][] spatial;
    private static List<ZoneGeometry>[][] zonesLists;
    private static Rectangle union;
    private static int[] bands;
    private static byte noDataB;
    private static short noDataU;
    private static short noDataS;
    private static int noDataI;
    private static float noDataF;
    private static double noDataD;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static double[] minBound;
    private static double[] maxBound;
    private static int[] numBins;
    private static List<Range>[] rangeList;
    private static ROI roiObject;

    @BeforeClass
    public static void initialSetup() {
        minBound = new double[]{-3.0, -3.0, -3.0};
        maxBound = new double[]{3.0, 3.0, 3.0};
        numBins = new int[]{4, 4, 4};
        stats = new Statistics.StatsType[]{Statistics.StatsType.MEAN, Statistics.StatsType.SUM, Statistics.StatsType.MAX, Statistics.StatsType.MIN, Statistics.StatsType.EXTREMA, Statistics.StatsType.VARIANCE, Statistics.StatsType.DEV_STD, Statistics.StatsType.HISTOGRAM, Statistics.StatsType.MODE, Statistics.StatsType.MEDIAN};
        roiList = new ArrayList<ROI>();
        int initial_value = 10;
        int final_value = 30;
        int dimension = final_value - initial_value;
        int interval = dimension / 10;
        for (int i = 0; i < 10; ++i) {
            ROIShape roiGeom = new ROIShape((Shape)new Rectangle(initial_value, initial_value, dimension, dimension));
            roiList.add((ROI)roiGeom);
            initial_value += interval;
        }
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roiObject = new ROIShape((Shape)roiBounds);
        rangeList = new ArrayList[6];
        ZonalStatsTest.rangeList[0] = new ArrayList<Range>(1);
        ZonalStatsTest.rangeList[1] = new ArrayList<Range>(1);
        ZonalStatsTest.rangeList[2] = new ArrayList<Range>(1);
        ZonalStatsTest.rangeList[3] = new ArrayList<Range>(1);
        ZonalStatsTest.rangeList[4] = new ArrayList<Range>(1);
        ZonalStatsTest.rangeList[5] = new ArrayList<Range>(1);
        rangeList[0].add(RangeFactory.create((byte)0, (boolean)true, (byte)100, (boolean)true));
        rangeList[1].add(RangeFactory.createU((short)0, (boolean)true, (short)100, (boolean)true));
        rangeList[2].add(RangeFactory.create((short)-1, (boolean)true, (short)100, (boolean)true));
        rangeList[3].add(RangeFactory.create((int)-1, (boolean)true, (int)100, (boolean)true));
        rangeList[4].add(RangeFactory.create((float)-1.0f, (boolean)true, (float)100.0f, (boolean)true, (boolean)false));
        rangeList[5].add(RangeFactory.create((double)-1.0, (boolean)true, (double)100.0, (boolean)true, (boolean)false));
        bands = new int[]{0};
        spatial = new STRtree[6][4];
        zonesLists = new ArrayList[6][4];
        for (int i = 0; i < 6; ++i) {
            ZonalStatsTest.spatial[i][0] = new STRtree();
            ZonalStatsTest.spatial[i][1] = new STRtree();
            ZonalStatsTest.spatial[i][2] = new STRtree();
            ZonalStatsTest.spatial[i][3] = new STRtree();
            ZonalStatsTest.zonesLists[i][0] = new ArrayList<ZoneGeometry>();
            ZonalStatsTest.zonesLists[i][1] = new ArrayList<ZoneGeometry>();
            ZonalStatsTest.zonesLists[i][2] = new ArrayList<ZoneGeometry>();
            ZonalStatsTest.zonesLists[i][3] = new ArrayList<ZoneGeometry>();
        }
        union = new Rectangle(roiList.get(0).getBounds());
        for (ROI roi : roiList) {
            Rectangle rect = roi.getBounds();
            double minX = rect.getMinX();
            double maxX = rect.getMaxX();
            double minY = rect.getMinY();
            double maxY = rect.getMaxY();
            Envelope env = new Envelope(minX, maxX, minY, maxY);
            union = union.union(rect);
            for (int i = 0; i < 6; ++i) {
                for (int z = 0; z < 4; ++z) {
                    ZoneGeometry geom = new ZoneGeometry(roi, rangeList[i], bands, stats, CLASSIFIER, minBound, maxBound, numBins);
                    spatial[i][z].insert(env, (Object)geom);
                    zonesLists[i][z].add(geom);
                }
            }
        }
        classifier = ZonalStatsTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)2, (boolean)false);
        Rectangle rectClass = new Rectangle(classifier.getMinX(), classifier.getMinY(), classifier.getWidth(), classifier.getHeight());
        RandomIter iterator = RandomIterFactory.create((RenderedImage)classifier, (Rectangle)rectClass, (boolean)true, (boolean)true);
        noDataB = (byte)50;
        noDataU = (short)50;
        noDataS = (short)50;
        noDataI = 50;
        noDataF = 50.0f;
        noDataD = 50.0;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        boolean nanIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataU, (boolean)minIncluded, (short)noDataU, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)nanIncluded);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)nanIncluded);
        sourceIMG = new RenderedImage[6];
        IMAGE_FILLER = false;
        ZonalStatsTest.sourceIMG[0] = ZonalStatsTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
        ZonalStatsTest.sourceIMG[1] = ZonalStatsTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataU, (boolean)false);
        ZonalStatsTest.sourceIMG[2] = ZonalStatsTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
        ZonalStatsTest.sourceIMG[3] = ZonalStatsTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
        ZonalStatsTest.sourceIMG[4] = ZonalStatsTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false);
        ZonalStatsTest.sourceIMG[5] = ZonalStatsTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false);
        int minTileX = sourceIMG[0].getMinTileX();
        int minTileY = sourceIMG[0].getMinTileY();
        int maxTileX = minTileX + sourceIMG[0].getNumXTiles();
        int maxTileY = minTileY + sourceIMG[0].getNumYTiles();
        for (int i = minTileX; i < maxTileX; ++i) {
            for (int j = minTileY; j < maxTileY; ++j) {
                Raster arrayRas = sourceIMG[0].getTile(i, j);
                int minX = arrayRas.getMinX();
                int minY = arrayRas.getMinY();
                int maxX = minX + arrayRas.getWidth();
                int maxY = minY + arrayRas.getHeight();
                for (int x = minX; x < maxX; ++x) {
                    for (int y = minY; y < maxY; ++y) {
                        for (int z = 0; z < 4; ++z) {
                            if (!union.contains(x, y)) continue;
                            byte value = (byte)arrayRas.getSample(x, y, 0);
                            Coordinate p = new Coordinate((double)x, (double)y);
                            Envelope searchEnv = new Envelope(p);
                            for (int v = 0; v < 6; ++v) {
                                List geomList = spatial[v][z].query(searchEnv);
                                int classId = 0;
                                if (CLASSIFIER) {
                                    classId = iterator.getSample(x, y, 0);
                                }
                                for (ZoneGeometry zoneGeo : geomList) {
                                    ROI geometry = zoneGeo.getROI();
                                    if (!geometry.contains(x, y)) continue;
                                    switch (z) {
                                        case 0: {
                                            zoneGeo.add((double)value, 0, classId, rangeList[v].get(0));
                                            break;
                                        }
                                        case 1: {
                                            if (noDataByte.contains(value)) break;
                                            zoneGeo.add((double)value, 0, classId, rangeList[v].get(0));
                                            break;
                                        }
                                        case 2: {
                                            if (!roiObject.contains(x, y)) break;
                                            zoneGeo.add((double)value, 0, classId, rangeList[v].get(0));
                                            break;
                                        }
                                        case 3: {
                                            if (noDataByte.contains(value) || !roiObject.contains(x, y)) break;
                                            zoneGeo.add((double)value, 0, classId, rangeList[v].get(0));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Test
    public void testNoNoDataNoROI() {
        boolean noDataRangeUsed = false;
        boolean roiUsed = false;
        boolean useROIAccessor = false;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testOnlyROI() {
        boolean noDataRangeUsed = false;
        boolean roiUsed = true;
        boolean useROIAccessor = false;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testOnlyROIRasterAccessor() {
        boolean noDataRangeUsed = false;
        boolean roiUsed = true;
        boolean useROIAccessor = true;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testOnlyNoData() {
        boolean noDataRangeUsed = true;
        boolean roiUsed = false;
        boolean useROIAccessor = false;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testNoDataAndROI() {
        boolean noDataRangeUsed = true;
        boolean roiUsed = true;
        boolean useROIAccessor = false;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testNoDataAndROIRasterAccessor() {
        boolean noDataRangeUsed = true;
        boolean roiUsed = true;
        boolean useROIAccessor = true;
        this.testZonalStats(sourceIMG[0], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[0]);
        this.testZonalStats(sourceIMG[1], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[1]);
        this.testZonalStats(sourceIMG[2], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[2]);
        this.testZonalStats(sourceIMG[3], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[3]);
        this.testZonalStats(sourceIMG[4], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[4]);
        this.testZonalStats(sourceIMG[5], CLASSIFIER, noDataRangeUsed, roiUsed, useROIAccessor, rangeList[5]);
    }

    @Test
    public void testStatsEntireImageNoROI() {
        int n = 4;
        byte min = rangeList[0].get(0).getMin().byteValue();
        byte max = rangeList[0].get(0).getMax().byteValue();
        byte delta = (byte)((max - min) / n);
        ArrayList<Range> ranges = new ArrayList<Range>();
        byte b = min;
        for (int i = 0; i < n; ++i) {
            byte c = (byte)(b + delta);
            ranges.add(RangeFactory.create((byte)b, (boolean)true, (byte)c, (i == n - 1 ? 1 : 0) != 0));
            b = c;
        }
        RenderedOp destination = ZonalStatsDescriptor.create((RenderedImage)sourceIMG[0], null, null, null, (Range)noDataByte, null, (boolean)false, (int[])bands, (Statistics.StatsType[])new Statistics.StatsType[]{Statistics.StatsType.MEAN}, ranges, (boolean)true, null);
        List result = (List)destination.getProperty("JAI-EXT.zonalstats");
        Map stats = ((ZoneGeometry)result.get(0)).getStatsPerBandPerClass(0, 0);
        Assert.assertEquals((long)4L, (long)stats.size());
    }

    public void testZonalStats(RenderedImage source, boolean classifierUsed, boolean noDataRangeUsed, boolean roiUsed, boolean useROIAccessor, List<Range> rangeList) {
        Range noDataRange;
        RenderedImage classifierIMG = classifierUsed ? classifier : null;
        ROI roi = null;
        if (roiUsed) {
            roi = roiObject;
        }
        if (noDataRangeUsed) {
            int dataType = source.getSampleModel().getDataType();
            switch (dataType) {
                case 0: {
                    noDataRange = noDataByte;
                    break;
                }
                case 1: {
                    noDataRange = noDataUShort;
                    break;
                }
                case 2: {
                    noDataRange = noDataShort;
                    break;
                }
                case 3: {
                    noDataRange = noDataInt;
                    break;
                }
                case 4: {
                    noDataRange = noDataFloat;
                    break;
                }
                case 5: {
                    noDataRange = noDataDouble;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        } else {
            noDataRange = null;
        }
        int statsIndex = 0;
        if (noDataRangeUsed && roiUsed) {
            statsIndex = 3;
        } else if (noDataRangeUsed) {
            statsIndex = 1;
        } else if (roiUsed) {
            statsIndex = 2;
        }
        RenderedOp destination = ZonalStatsDescriptor.create((RenderedImage)source, (RenderedImage)classifierIMG, null, roiList, (Range)noDataRange, (ROI)roi, (boolean)useROIAccessor, (int[])bands, (Statistics.StatsType[])stats, (double[])minBound, (double[])maxBound, (int[])numBins, rangeList, (boolean)false, null);
        List result = (List)destination.getProperty("JAI-EXT.zonalstats");
        int dataType = destination.getSampleModel().getDataType();
        List<ZoneGeometry> zoneList = zonesLists[dataType][statsIndex];
        if (CLASSIFIER) {
            for (int i = 0; i < result.size(); ++i) {
                ZoneGeometry zoneResult = (ZoneGeometry)result.get(i);
                ZoneGeometry zoneCalculated = zoneList.get(i);
                Map resultPerClass = zoneResult.getStatsPerBand(0);
                Set zoneset = resultPerClass.keySet();
                Iterator i$ = zoneset.iterator();
                while (i$.hasNext()) {
                    int zone = (Integer)i$.next();
                    Statistics[] statsResult = zoneResult.getStatsPerBandNoRange(0, zone);
                    Statistics[] statsCalculated = zoneCalculated.getStatsPerBandNoRange(0, zone);
                    Assert.assertEquals((long)statsResult.length, (long)statsCalculated.length);
                    block20: for (int j = 0; j < statsResult.length; ++j) {
                        Statistics statR = statsResult[j];
                        Statistics statC = statsCalculated[j];
                        switch (j) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 5: 
                            case 6: 
                            case 8: 
                            case 9: {
                                double valueR = (Double)statR.getResult();
                                double valueC = (Double)statC.getResult();
                                Assert.assertEquals((double)valueR, (double)valueC, (double)0.1);
                                continue block20;
                            }
                            case 4: {
                                double[] extremaR = (double[])statR.getResult();
                                double maxR = extremaR[1];
                                double minR = extremaR[0];
                                double[] extremaC = (double[])statC.getResult();
                                double maxC = extremaC[1];
                                double minC = extremaC[0];
                                Assert.assertEquals((double)minR, (double)minC, (double)0.1);
                                Assert.assertEquals((double)maxR, (double)maxC, (double)0.1);
                                continue block20;
                            }
                            case 7: {
                                double[] histR = (double[])statR.getResult();
                                double[] histC = (double[])statC.getResult();
                                Assert.assertEquals((long)histR.length, (long)histC.length);
                                for (int bin = 0; bin < histR.length; ++bin) {
                                    double binR = histR[bin];
                                    double binC = histC[bin];
                                    Assert.assertEquals((double)binR, (double)binC, (double)0.1);
                                }
                                continue block20;
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < result.size(); ++i) {
                ZoneGeometry zoneResult = (ZoneGeometry)result.get(i);
                ZoneGeometry zoneCalculated = zoneList.get(i);
                Statistics[] statsResult = zoneResult.getStatsPerBandNoClassifierNoRange(0);
                Statistics[] statsCalculated = zoneCalculated.getStatsPerBandNoClassifier(0, rangeList.get(0));
                Assert.assertEquals((long)statsResult.length, (long)statsCalculated.length);
                block23: for (int j = 0; j < statsResult.length; ++j) {
                    Statistics statR = statsResult[j];
                    Statistics statC = statsCalculated[j];
                    switch (j) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 5: 
                        case 6: 
                        case 8: 
                        case 9: {
                            double valueR = (Double)statR.getResult();
                            double valueC = (Double)statC.getResult();
                            Assert.assertEquals((double)valueR, (double)valueC, (double)0.1);
                            continue block23;
                        }
                        case 4: {
                            double[] extremaR = (double[])statR.getResult();
                            double maxR = extremaR[1];
                            double minR = extremaR[0];
                            double[] extremaC = (double[])statC.getResult();
                            double maxC = extremaC[1];
                            double minC = extremaC[0];
                            Assert.assertEquals((double)minR, (double)minC, (double)0.1);
                            Assert.assertEquals((double)maxR, (double)maxC, (double)0.1);
                            continue block23;
                        }
                        case 7: {
                            double[] histR = (double[])statR.getResult();
                            double[] histC = (double[])statC.getResult();
                            Assert.assertEquals((long)histR.length, (long)histC.length);
                            for (int bin = 0; bin < histR.length; ++bin) {
                                double binR = histR[bin];
                                double binC = histC[bin];
                                Assert.assertEquals((double)binR, (double)binC, (double)0.1);
                            }
                            continue block23;
                        }
                    }
                }
            }
        }
    }
}

