/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatisticsDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.warp.WarpDescriptor;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import javax.media.jai.Warp;
import org.junit.Assert;

public class TestWarp
extends TestBase {
    protected static final double ANGLE_ROTATION = 45.0;
    protected static Warp warpObj;
    protected static final int NUM_IMAGES = 6;
    protected static RenderedImage[] images;
    protected static byte noDataValueB;
    protected static TestBase.InterpolationType interpType;
    protected static short noDataValueU;
    protected static short noDataValueS;
    protected static int noDataValueI;
    protected static float noDataValueF;
    protected static double noDataValueD;

    public void testWarp(RenderedImage source, boolean noDataUsed, boolean roiUsed, Warp warpObj, Number noDataValue, TestBase.InterpolationType interpType, TestBase.TestSelection testSelect) {
        Range noData;
        javax.media.jai.InterpolationBicubic interp;
        int dataType = source.getSampleModel().getDataType();
        Range noDataRange = null;
        this.destinationNoData = 10.0;
        if (noDataUsed) {
            switch (dataType) {
                case 0: {
                    noDataRange = RangeFactory.create((byte)noDataValue.byteValue(), (boolean)true, (byte)noDataValue.byteValue(), (boolean)true);
                    break;
                }
                case 1: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 2: {
                    noDataRange = RangeFactory.create((short)noDataValue.shortValue(), (boolean)true, (short)noDataValue.shortValue(), (boolean)true);
                    break;
                }
                case 3: {
                    noDataRange = RangeFactory.create((int)noDataValue.intValue(), (boolean)true, (int)noDataValue.intValue(), (boolean)true);
                    break;
                }
                case 4: {
                    noDataRange = RangeFactory.create((float)noDataValue.floatValue(), (boolean)true, (float)noDataValue.floatValue(), (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    noDataRange = RangeFactory.create((double)noDataValue.doubleValue(), (boolean)true, (double)noDataValue.doubleValue(), (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        ROIShape roi = null;
        if (roiUsed) {
            roi = this.roiCreation();
        }
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        RenderedOp destinationIMG = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interp = new InterpolationNearest(noDataRange, false, this.destinationNoData, dataType);
                break;
            }
            case BILINEAR_INTERP: {
                interp = new InterpolationBilinear(8, noDataRange, false, this.destinationNoData, dataType);
                break;
            }
            case BICUBIC_INTERP: {
                interp = new InterpolationBicubic(8, noDataRange, false, this.destinationNoData, dataType, true, 8);
                break;
            }
            case GENERAL_INTERP: {
                interp = new javax.media.jai.InterpolationBicubic(8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong interpolation type");
            }
        }
        destinationIMG = WarpDescriptor.create((RenderedImage)source, (Warp)warpObj, (Interpolation)interp, null, (ROI)roi, (RenderingHints)hints);
        if (INTERACTIVE && dataType == 0 && TEST_SELECTOR.intValue() == testSelect.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            destinationIMG.getTiles();
        }
        Assert.assertTrue((destinationIMG.getHeight() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((destinationIMG.getWidth() > 0 ? 1 : 0) != 0);
        Rectangle inputRect = new Rectangle(source.getMinX(), source.getMinY(), source.getWidth(), source.getHeight());
        Rectangle outputRect = warpObj.mapSourceRect(inputRect);
        Assert.assertEquals((long)destinationIMG.getMinX(), (long)outputRect.x);
        Assert.assertEquals((long)destinationIMG.getMinY(), (long)outputRect.y);
        Assert.assertEquals((long)destinationIMG.getHeight(), (long)outputRect.width);
        Assert.assertEquals((long)destinationIMG.getWidth(), (long)outputRect.height);
        Statistics.StatsType[] stats = new Statistics.StatsType[]{Statistics.StatsType.MEAN};
        switch (dataType) {
            case 0: {
                noData = RangeFactory.create((byte)((byte)this.destinationNoData), (boolean)true, (byte)((byte)this.destinationNoData), (boolean)true);
                break;
            }
            case 1: 
            case 2: {
                noData = RangeFactory.create((short)((short)this.destinationNoData), (boolean)true, (short)((short)this.destinationNoData), (boolean)true);
                break;
            }
            case 3: {
                noData = RangeFactory.create((int)((int)this.destinationNoData), (boolean)true, (int)((int)this.destinationNoData), (boolean)true);
                break;
            }
            case 4: {
                noData = RangeFactory.create((float)((float)this.destinationNoData), (boolean)true, (float)((float)this.destinationNoData), (boolean)true, (boolean)true);
                break;
            }
            case 5: {
                noData = RangeFactory.create((double)this.destinationNoData, (boolean)true, (double)this.destinationNoData, (boolean)true, (boolean)true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        RenderedOp statistics = StatisticsDescriptor.create((RenderedImage)destinationIMG, (int)1, (int)1, (ROI)roi, (Range)noData, (boolean)false, (int[])new int[]{0}, (Statistics.StatsType[])stats, null, null, null, (RenderingHints)hints);
        Statistics[][] result = (Statistics[][])statistics.getProperty("JAI-EXT.stats");
        destinationIMG.dispose();
        double mean = (Double)result[0][0].getResult();
        long num = result[0][0].getNumSamples();
        Assert.assertTrue((num > 0L ? 1 : 0) != 0);
        Assert.assertTrue((mean != this.destinationNoData ? 1 : 0) != 0);
        statistics.dispose();
    }

    public void testImage(TestBase.InterpolationType interpType) {
        boolean roiUsed = false;
        boolean noDataUsed = false;
        TestBase.TestSelection testSelect = TestBase.TestSelection.NO_ROI_ONLY_DATA;
        this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        this.testWarp(images[1], noDataUsed, roiUsed, warpObj, noDataValueU, interpType, testSelect);
        this.testWarp(images[2], noDataUsed, roiUsed, warpObj, noDataValueS, interpType, testSelect);
        this.testWarp(images[3], noDataUsed, roiUsed, warpObj, noDataValueI, interpType, testSelect);
        this.testWarp(images[4], noDataUsed, roiUsed, warpObj, Float.valueOf(noDataValueF), interpType, testSelect);
        this.testWarp(images[5], noDataUsed, roiUsed, warpObj, noDataValueD, interpType, testSelect);
    }

    public void testImageROI(TestBase.InterpolationType interpType) {
        boolean roiUsed = true;
        boolean noDataUsed = false;
        TestBase.TestSelection testSelect = TestBase.TestSelection.ROI_ONLY_DATA;
        this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        this.testWarp(images[1], noDataUsed, roiUsed, warpObj, noDataValueU, interpType, testSelect);
        this.testWarp(images[2], noDataUsed, roiUsed, warpObj, noDataValueS, interpType, testSelect);
        this.testWarp(images[3], noDataUsed, roiUsed, warpObj, noDataValueI, interpType, testSelect);
        this.testWarp(images[4], noDataUsed, roiUsed, warpObj, Float.valueOf(noDataValueF), interpType, testSelect);
        this.testWarp(images[5], noDataUsed, roiUsed, warpObj, noDataValueD, interpType, testSelect);
    }

    public void testImageNoData(TestBase.InterpolationType interpType) {
        boolean roiUsed = false;
        boolean noDataUsed = true;
        TestBase.TestSelection testSelect = TestBase.TestSelection.NO_ROI_NO_DATA;
        this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        this.testWarp(images[1], noDataUsed, roiUsed, warpObj, noDataValueU, interpType, testSelect);
        this.testWarp(images[2], noDataUsed, roiUsed, warpObj, noDataValueS, interpType, testSelect);
        this.testWarp(images[3], noDataUsed, roiUsed, warpObj, noDataValueI, interpType, testSelect);
        this.testWarp(images[4], noDataUsed, roiUsed, warpObj, Float.valueOf(noDataValueF), interpType, testSelect);
        this.testWarp(images[5], noDataUsed, roiUsed, warpObj, noDataValueD, interpType, testSelect);
    }

    public void testImageNoDataROI(TestBase.InterpolationType interpType) {
        boolean roiUsed = true;
        boolean noDataUsed = true;
        TestBase.TestSelection testSelect = TestBase.TestSelection.ROI_NO_DATA;
        this.testWarp(images[0], noDataUsed, roiUsed, warpObj, noDataValueB, interpType, testSelect);
        this.testWarp(images[1], noDataUsed, roiUsed, warpObj, noDataValueU, interpType, testSelect);
        this.testWarp(images[2], noDataUsed, roiUsed, warpObj, noDataValueS, interpType, testSelect);
        this.testWarp(images[3], noDataUsed, roiUsed, warpObj, noDataValueI, interpType, testSelect);
        this.testWarp(images[4], noDataUsed, roiUsed, warpObj, Float.valueOf(noDataValueF), interpType, testSelect);
        this.testWarp(images[5], noDataUsed, roiUsed, warpObj, noDataValueD, interpType, testSelect);
    }

    public static void finalStuff() {
        if (images != null) {
            ((TiledImage)images[0]).dispose();
            ((TiledImage)images[1]).dispose();
            ((TiledImage)images[2]).dispose();
            ((TiledImage)images[3]).dispose();
            ((TiledImage)images[4]).dispose();
            ((TiledImage)images[5]).dispose();
        }
    }
}

