/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WarpNearestOpImage
extends WarpOpImage {
    private byte[][] byteLookupTable;

    public WarpNearestOpImage(RenderedImage source, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, ROI sourceROI, Range noData, double[] bkg) {
        super(source, layout, config, false, null, interp, warp, bkg, sourceROI, noData);
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        switch (srcDataType) {
            case 0: {
                if (!this.hasNoData) break;
                int numBands = this.getNumBands();
                this.byteLookupTable = new byte[numBands][256];
                for (int b = 0; b < numBands; ++b) {
                    for (int i = 0; i < this.byteLookupTable.length; ++i) {
                        byte value = (byte)i;
                        this.byteLookupTable[b][i] = this.noDataRange.contains(value) ? (byte)this.backgroundValues[b] : value;
                    }
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (byte)(iter.getSample(sx, sy, b) & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (byte)(iter.getSample(sx, sy, b) & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = this.byteLookupTable[b][iter.getSample(sx, sy, b)];
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || !this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = this.byteLookupTable[b][iter.getSample(sx, sy, b)];
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (short)(iter.getSample(sx, sy, b) & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || !this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (short)(iter.getSample(sx, sy, b) & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            short inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = (short)(iter.getSample(sx, sy, b) & 0xFFFF);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            short inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = (short)(iter.getSample(sx, sy, b) & 0xFFFF);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (short)iter.getSample(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = (short)iter.getSample(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            short inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = (short)iter.getSample(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            short inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = (short)iter.getSample(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (short)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSample(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSample(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            int inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSample(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (int)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            int inputValue = 0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSample(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (int)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSampleFloat(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSampleFloat(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            float inputValue = 0.0f;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSampleFloat(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (float)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            float inputValue = 0.0f;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSampleFloat(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? (float)this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iter = RandomIterFactory.create((RenderedImage)src, (Rectangle)src.getBounds(), (boolean)true, (boolean)true);
        int minX = src.getMinX();
        int maxX = src.getMaxX();
        int minY = src.getMinY();
        int maxY = src.getMaxY();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSampleDouble(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            data[b][pixelOffset + bandOffsets[b]] = iter.getSampleDouble(sx, sy, b);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            double inputValue = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSampleDouble(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            double inputValue = 0.0;
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    int sx = WarpNearestOpImage.round(warpData[count++]);
                    int sy = WarpNearestOpImage.round(warpData[count++]);
                    if (sx < minX || sx >= maxX || sy < minY || sy >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else if (!this.roiBounds.contains(sx, sy) || roiIter.getSample(sx, sy, 0) <= 0) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            inputValue = iter.getSampleDouble(sx, sy, b);
                            data[b][pixelOffset + bandOffsets[b]] = this.noDataRange.contains(inputValue) ? this.backgroundValues[b] : inputValue;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iter.done();
    }
}

