/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.warp.WarpOpImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.Warp;
import javax.media.jai.iterator.RandomIter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class WarpBilinearOpImage
extends WarpOpImage {
    private byte[][] ctable = null;
    private boolean[] booleanLookupTable;

    public WarpBilinearOpImage(RenderedImage source, BorderExtender extender, Map<?, ?> config, ImageLayout layout, Warp warp, Interpolation interp, ROI sourceROI, Range noData, double[] bkg) {
        super(source, layout, config, false, extender, interp, warp, bkg, sourceROI, noData);
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)srcColorModel;
            this.ctable = new byte[3][icm.getMapSize()];
            icm.getReds(this.ctable[0]);
            icm.getGreens(this.ctable[1]);
            icm.getBlues(this.ctable[2]);
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        switch (srcDataType) {
            case 0: {
                if (!this.hasNoData) break;
                this.booleanLookupTable = new boolean[256];
                for (int i = 0; i < this.booleanLookupTable.length; ++i) {
                    byte value = (byte)i;
                    this.booleanLookupTable[i] = this.noDataRange.contains(value);
                }
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
    }

    @Override
    protected void computeRectByte(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        byte[][] data = dst.getByteDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.ctable == null) {
            if (this.caseA || this.caseB && roiContainsTile) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b) & 0xFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s = (s1 - s0) * yfrac + s0;
                                data[b][pixelOffset + bandOffsets[b]] = (byte)s;
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseB) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int b;
                            boolean w11;
                            boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                            boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                            boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                            boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                            if (w00 && w01 && w10 && w11) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    int s00 = iterSource.getSample(xint, yint, b) & 0xFF;
                                    int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFF;
                                    int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFF;
                                    int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFF;
                                    float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                    float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                    float s = (s1 - s0) * yfrac + s0;
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)s;
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        int b;
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b) & 0xFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFF;
                                boolean w00 = this.booleanLookupTable[s00];
                                boolean w01 = this.booleanLookupTable[s01];
                                boolean w10 = this.booleanLookupTable[s10];
                                boolean w11 = this.booleanLookupTable[s11];
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b] : (byte)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFF);
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            } else {
                for (int h = 0; h < dstHeight; ++h) {
                    int pixelOffset = lineOffset;
                    lineOffset += lineStride;
                    this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                    int count = 0;
                    for (int w = 0; w < dstWidth; ++w) {
                        float sx = warpData[count++];
                        float sy = warpData[count++];
                        int xint = WarpBilinearOpImage.floor(sx);
                        int yint = WarpBilinearOpImage.floor(sy);
                        float xfrac = sx - (float)xint;
                        float yfrac = sy - (float)yint;
                        if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                            if (this.setBackground) {
                                for (int b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            }
                        } else {
                            int b;
                            boolean w11Roi;
                            boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                            boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                            boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                            boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                            if (w00Roi && w01Roi && w10Roi && w11Roi) {
                                for (b = 0; b < dstBands; ++b) {
                                    data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                                }
                            } else {
                                for (b = 0; b < dstBands; ++b) {
                                    int s00 = iterSource.getSample(xint, yint, b) & 0xFF;
                                    int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFF;
                                    int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFF;
                                    int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFF;
                                    boolean w00 = this.booleanLookupTable[s00];
                                    boolean w01 = this.booleanLookupTable[s01];
                                    boolean w10 = this.booleanLookupTable[s10];
                                    boolean w11 = this.booleanLookupTable[s11];
                                    data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b] : (byte)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFF);
                                }
                            }
                        }
                        pixelOffset += pixelStride;
                    }
                }
            }
        } else if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                            int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                            int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                            int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s = (s1 - s0) * yfrac + s0;
                            data[b][pixelOffset + bandOffsets[b]] = (byte)s;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                                int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                                int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                                int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s = (s1 - s0) * yfrac + s0;
                                data[b][pixelOffset + bandOffsets[b]] = (byte)s;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            byte[] t = this.ctable[b];
                            int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                            int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                            int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                            int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                            boolean w00 = this.booleanLookupTable[s00];
                            boolean w01 = this.booleanLookupTable[s01];
                            boolean w10 = this.booleanLookupTable[s10];
                            boolean w11 = this.booleanLookupTable[s11];
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b] : (byte)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (byte)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                byte[] t = this.ctable[b];
                                int s00 = t[iterSource.getSample(xint, yint, 0) & 0xFF] & 0xFF;
                                int s01 = t[iterSource.getSample(xint + 1, yint, 0) & 0xFF] & 0xFF;
                                int s10 = t[iterSource.getSample(xint, yint + 1, 0) & 0xFF] & 0xFF;
                                int s11 = t[iterSource.getSample(xint + 1, yint + 1, 0) & 0xFF] & 0xFF;
                                boolean w00 = this.booleanLookupTable[s00];
                                boolean w01 = this.booleanLookupTable[s01];
                                boolean w10 = this.booleanLookupTable[s10];
                                boolean w11 = this.booleanLookupTable[s11];
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (byte)this.backgroundValues[b] : (byte)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFF);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectUShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b) & 0xFFFF;
                            int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFFFF;
                            int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFFFF;
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFFFF;
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s = (s1 - s0) * yfrac + s0;
                            data[b][pixelOffset + bandOffsets[b]] = (short)s;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b) & 0xFFFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFFFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFFFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFFFF;
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s = (s1 - s0) * yfrac + s0;
                                data[b][pixelOffset + bandOffsets[b]] = (short)s;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b) & 0xFFFF;
                            int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFFFF;
                            int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFFFF;
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFFFF;
                            boolean w00 = this.noDataRange.contains((short)s00);
                            boolean w01 = this.noDataRange.contains((short)s01);
                            boolean w10 = this.noDataRange.contains((short)s10);
                            boolean w11 = this.noDataRange.contains((short)s11);
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b] : (short)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFFFF);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b) & 0xFFFF;
                                int s01 = iterSource.getSample(xint + 1, yint, b) & 0xFFFF;
                                int s10 = iterSource.getSample(xint, yint + 1, b) & 0xFFFF;
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b) & 0xFFFF;
                                boolean w00 = this.noDataRange.contains((short)s00);
                                boolean w01 = this.noDataRange.contains((short)s01);
                                boolean w10 = this.noDataRange.contains((short)s10);
                                boolean w11 = this.noDataRange.contains((short)s11);
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b] : (short)((int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11) & 0xFFFF);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectShort(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        short[][] data = dst.getShortDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b);
                            int s01 = iterSource.getSample(xint + 1, yint, b);
                            int s10 = iterSource.getSample(xint, yint + 1, b);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s = (s1 - s0) * yfrac + s0;
                            data[b][pixelOffset + bandOffsets[b]] = (short)s;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b);
                                int s01 = iterSource.getSample(xint + 1, yint, b);
                                int s10 = iterSource.getSample(xint, yint + 1, b);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s = (s1 - s0) * yfrac + s0;
                                data[b][pixelOffset + bandOffsets[b]] = (short)s;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b);
                            int s01 = iterSource.getSample(xint + 1, yint, b);
                            int s10 = iterSource.getSample(xint, yint + 1, b);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                            boolean w00 = this.noDataRange.contains((short)s00);
                            boolean w01 = this.noDataRange.contains((short)s01);
                            boolean w10 = this.noDataRange.contains((short)s10);
                            boolean w11 = this.noDataRange.contains((short)s11);
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b] : (short)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (short)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b);
                                int s01 = iterSource.getSample(xint + 1, yint, b);
                                int s10 = iterSource.getSample(xint, yint + 1, b);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                                boolean w00 = this.noDataRange.contains((short)s00);
                                boolean w01 = this.noDataRange.contains((short)s01);
                                boolean w10 = this.noDataRange.contains((short)s10);
                                boolean w11 = this.noDataRange.contains((short)s11);
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (short)this.backgroundValues[b] : (short)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectInt(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        int[][] data = dst.getIntDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b);
                            int s01 = iterSource.getSample(xint + 1, yint, b);
                            int s10 = iterSource.getSample(xint, yint + 1, b);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                            float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                            float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                            float s = (s1 - s0) * yfrac + s0;
                            data[b][pixelOffset + bandOffsets[b]] = (int)s;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b);
                                int s01 = iterSource.getSample(xint + 1, yint, b);
                                int s10 = iterSource.getSample(xint, yint + 1, b);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                                float s0 = (float)(s01 - s00) * xfrac + (float)s00;
                                float s1 = (float)(s11 - s10) * xfrac + (float)s10;
                                float s = (s1 - s0) * yfrac + s0;
                                data[b][pixelOffset + bandOffsets[b]] = (int)s;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int s00 = iterSource.getSample(xint, yint, b);
                            int s01 = iterSource.getSample(xint + 1, yint, b);
                            int s10 = iterSource.getSample(xint, yint + 1, b);
                            int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (int)this.backgroundValues[b] : (int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (int)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                int s00 = iterSource.getSample(xint, yint, b);
                                int s01 = iterSource.getSample(xint + 1, yint, b);
                                int s10 = iterSource.getSample(xint, yint + 1, b);
                                int s11 = iterSource.getSample(xint + 1, yint + 1, b);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (int)this.backgroundValues[b] : (int)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectFloat(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        float[][] data = dst.getFloatDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            float s;
                            float s00 = iterSource.getSampleFloat(xint, yint, b);
                            float s01 = iterSource.getSampleFloat(xint + 1, yint, b);
                            float s10 = iterSource.getSampleFloat(xint, yint + 1, b);
                            float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b);
                            float s0 = (s01 - s00) * xfrac + s00;
                            float s1 = (s11 - s10) * xfrac + s10;
                            data[b][pixelOffset + bandOffsets[b]] = s = (s1 - s0) * yfrac + s0;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                float s;
                                float s00 = iterSource.getSampleFloat(xint, yint, b);
                                float s01 = iterSource.getSampleFloat(xint + 1, yint, b);
                                float s10 = iterSource.getSampleFloat(xint, yint + 1, b);
                                float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b);
                                float s0 = (s01 - s00) * xfrac + s00;
                                float s1 = (s11 - s10) * xfrac + s10;
                                data[b][pixelOffset + bandOffsets[b]] = s = (s1 - s0) * yfrac + s0;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            float s00 = iterSource.getSampleFloat(xint, yint, b);
                            float s01 = iterSource.getSampleFloat(xint + 1, yint, b);
                            float s10 = iterSource.getSampleFloat(xint, yint + 1, b);
                            float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (float)this.backgroundValues[b] : (float)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = (float)this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                float s00 = iterSource.getSampleFloat(xint, yint, b);
                                float s01 = iterSource.getSampleFloat(xint + 1, yint, b);
                                float s10 = iterSource.getSampleFloat(xint, yint + 1, b);
                                float s11 = iterSource.getSampleFloat(xint + 1, yint + 1, b);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? (float)this.backgroundValues[b] : (float)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11);
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    @Override
    protected void computeRectDouble(PlanarImage src, RasterAccessor dst, RandomIter roiIter, boolean roiContainsTile) {
        RandomIter iterSource = this.getRandomIterator(src, this.extender);
        int minX = src.getMinX();
        int maxX = src.getMaxX() - (this.extended ? 0 : 1);
        int minY = src.getMinY();
        int maxY = src.getMaxY() - (this.extended ? 0 : 1);
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int lineStride = dst.getScanlineStride();
        int pixelStride = dst.getPixelStride();
        int[] bandOffsets = dst.getBandOffsets();
        double[][] data = dst.getDoubleDataArrays();
        float[] warpData = new float[2 * dstWidth];
        int lineOffset = 0;
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double s;
                            double s00 = iterSource.getSampleDouble(xint, yint, b);
                            double s01 = iterSource.getSampleDouble(xint + 1, yint, b);
                            double s10 = iterSource.getSampleDouble(xint, yint + 1, b);
                            double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b);
                            double s0 = (s01 - s00) * (double)xfrac + s00;
                            double s1 = (s11 - s10) * (double)xfrac + s10;
                            data[b][pixelOffset + bandOffsets[b]] = s = (s1 - s0) * (double)yfrac + s0;
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11;
                        boolean w00 = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01 = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10 = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11 = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00 && w01 && w10 && w11) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                double s;
                                double s00 = iterSource.getSampleDouble(xint, yint, b);
                                double s01 = iterSource.getSampleDouble(xint + 1, yint, b);
                                double s10 = iterSource.getSampleDouble(xint, yint + 1, b);
                                double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b);
                                double s0 = (s01 - s00) * (double)xfrac + s00;
                                double s1 = (s11 - s10) * (double)xfrac + s10;
                                data[b][pixelOffset + bandOffsets[b]] = s = (s1 - s0) * (double)yfrac + s0;
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double s00 = iterSource.getSampleDouble(xint, yint, b);
                            double s01 = iterSource.getSampleDouble(xint + 1, yint, b);
                            double s10 = iterSource.getSampleDouble(xint, yint + 1, b);
                            double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b);
                            boolean w00 = this.noDataRange.contains(s00);
                            boolean w01 = this.noDataRange.contains(s01);
                            boolean w10 = this.noDataRange.contains(s10);
                            boolean w11 = this.noDataRange.contains(s11);
                            data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? this.backgroundValues[b] : (double)((float)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11));
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int pixelOffset = lineOffset;
                lineOffset += lineStride;
                this.warp.warpRect(dst.getX(), dst.getY() + h, dstWidth, 1, warpData);
                int count = 0;
                for (int w = 0; w < dstWidth; ++w) {
                    float sx = warpData[count++];
                    float sy = warpData[count++];
                    int xint = WarpBilinearOpImage.floor(sx);
                    int yint = WarpBilinearOpImage.floor(sy);
                    float xfrac = sx - (float)xint;
                    float yfrac = sy - (float)yint;
                    if (xint < minX || xint >= maxX || yint < minY || yint >= maxY) {
                        if (this.setBackground) {
                            for (int b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        }
                    } else {
                        int b;
                        boolean w11Roi;
                        boolean w00Roi = !this.roiBounds.contains(xint, yint) || roiIter.getSample(xint, yint, 0) <= 0;
                        boolean w01Roi = !this.roiBounds.contains(xint + 1, yint) || roiIter.getSample(xint + 1, yint, 0) <= 0;
                        boolean w10Roi = !this.roiBounds.contains(xint, yint + 1) || roiIter.getSample(xint, yint + 1, 0) <= 0;
                        boolean bl = w11Roi = !this.roiBounds.contains(xint + 1, yint + 1) || roiIter.getSample(xint + 1, yint + 1, 0) <= 0;
                        if (w00Roi && w01Roi && w10Roi && w11Roi) {
                            for (b = 0; b < dstBands; ++b) {
                                data[b][pixelOffset + bandOffsets[b]] = this.backgroundValues[b];
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                double s00 = iterSource.getSampleDouble(xint, yint, b);
                                double s01 = iterSource.getSampleDouble(xint + 1, yint, b);
                                double s10 = iterSource.getSampleDouble(xint, yint + 1, b);
                                double s11 = iterSource.getSampleDouble(xint + 1, yint + 1, b);
                                boolean w00 = this.noDataRange.contains(s00);
                                boolean w01 = this.noDataRange.contains(s01);
                                boolean w10 = this.noDataRange.contains(s10);
                                boolean w11 = this.noDataRange.contains(s11);
                                data[b][pixelOffset + bandOffsets[b]] = w00 && w01 && w10 && w11 ? this.backgroundValues[b] : (double)((float)this.computePoint(s00, s01, s10, s11, xfrac, yfrac, w00, w01, w10, w11));
                            }
                        }
                    }
                    pixelOffset += pixelStride;
                }
            }
        }
        iterSource.done();
    }

    private double computePoint(double s00, double s01, double s10, double s11, double xfrac, double yfrac, boolean w00, boolean w01, boolean w10, boolean w11) {
        double s0 = 0.0;
        double s1 = 0.0;
        double s = 0.0;
        double xfracCompl = 1.0 - xfrac;
        double yfracCompl = 1.0 - yfrac;
        if (!(w00 || w01 || w10 || w11)) {
            s0 = (s01 - s00) * xfrac + s00;
            s1 = (s11 - s10) * xfrac + s10;
            s = (s1 - s0) * yfrac + s0;
        } else {
            s0 = w00 && w01 ? 0.0 : (w00 ? s01 * xfrac : (w01 ? s00 * xfracCompl : (s01 - s00) * xfrac + s00));
            s1 = w10 && w11 ? 0.0 : (w10 ? s11 * xfrac : (w11 ? s10 * xfracCompl : (s11 - s10) * xfrac + s10));
            s = w00 && w01 ? s1 * yfrac : (w10 && w11 ? s0 * yfracCompl : (s1 - s0) * yfrac + s0);
        }
        return s;
    }
}

