/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.warp;

import it.geosolutions.jaiext.ConcurrentOperationRegistry;
import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.warp.TestWarp;
import it.geosolutions.jaiext.warp.WarpDescriptor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.Warp;
import javax.media.jai.WarpAffine;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest
extends TestWarp {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final int INTERP_SELECTOR = Integer.getInteger("JAI.Ext.InterpSelector", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static final boolean NATIVE_ACCELERATION = Boolean.getBoolean("JAI.Ext.Acceleration");
    private static final boolean RANGE_USED = Boolean.getBoolean("JAI.Ext.RangeUsed");
    private static final boolean ROI_USED = Boolean.getBoolean("JAI.Ext.ROIUsed");
    private static RenderedImage image;
    private static ROI roi;
    private static Range range;
    private static double destNoData;
    private static Warp warpObj;
    private static double[] backgroundValues;

    @BeforeClass
    public static void initialSetup() {
        ConcurrentOperationRegistry registry = (ConcurrentOperationRegistry)ConcurrentOperationRegistry.initializeRegistry();
        JAIExt.initJAIEXT((ConcurrentOperationRegistry)registry);
        JAI.getDefaultInstance().setOperationRegistry((OperationRegistry)registry);
        IMAGE_FILLER = true;
        byte noDataB = 100;
        short noDataUS = 100;
        short noDataS = 100;
        int noDataI = 100;
        float noDataF = 100.0f;
        double noDataD = 100.0;
        switch (TEST_SELECTOR) {
            case 0: {
                image = ComparisonTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false);
                break;
            }
            case 1: {
                image = ComparisonTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataUS, (boolean)false);
                break;
            }
            case 2: {
                image = ComparisonTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false);
                break;
            }
            case 3: {
                image = ComparisonTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false);
                break;
            }
            case 4: {
                image = ComparisonTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false);
                break;
            }
            case 5: {
                image = ComparisonTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        IMAGE_FILLER = false;
        if (ROI_USED) {
            Rectangle rect = new Rectangle(0, 0, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
            roi = new ROIShape((Shape)rect);
        } else {
            roi = null;
        }
        if (RANGE_USED && !OLD_DESCRIPTOR) {
            switch (TEST_SELECTOR) {
                case 0: {
                    range = RangeFactory.create((byte)noDataB, (boolean)true, (byte)noDataB, (boolean)true);
                    break;
                }
                case 1: {
                    range = RangeFactory.createU((short)noDataUS, (boolean)true, (short)noDataUS, (boolean)true);
                    break;
                }
                case 2: {
                    range = RangeFactory.create((short)noDataS, (boolean)true, (short)noDataS, (boolean)true);
                    break;
                }
                case 3: {
                    range = RangeFactory.create((int)noDataI, (boolean)true, (int)noDataI, (boolean)true);
                    break;
                }
                case 4: {
                    range = RangeFactory.create((float)noDataF, (boolean)true, (float)noDataF, (boolean)true, (boolean)true);
                    break;
                }
                case 5: {
                    range = RangeFactory.create((double)noDataD, (boolean)true, (double)noDataD, (boolean)true, (boolean)true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        AffineTransform transform = AffineTransform.getRotateInstance(Math.toRadians(45.0));
        transform.concatenate(AffineTransform.getTranslateInstance(0.0, -DEFAULT_HEIGHT));
        warpObj = new WarpAffine(transform);
        destNoData = 0.0;
        backgroundValues = new double[]{0.0};
    }

    @Test
    public void testWarp() {
        javax.media.jai.InterpolationBicubic interpolation;
        int dataType = TEST_SELECTOR;
        String description = "Warp";
        if (OLD_DESCRIPTOR) {
            description = "Old " + description;
            if (NATIVE_ACCELERATION) {
                description = description + " accelerated ";
                System.setProperty("com.sun.media.jai.disableMediaLib", "false");
            } else {
                System.setProperty("com.sun.media.jai.disableMediaLib", "true");
            }
        } else {
            description = "New " + description;
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        String dataTypeString = "";
        switch (dataType) {
            case 0: {
                dataTypeString = dataTypeString + "Byte";
                break;
            }
            case 1: {
                dataTypeString = dataTypeString + "UShort";
                break;
            }
            case 2: {
                dataTypeString = dataTypeString + "Short";
                break;
            }
            case 3: {
                dataTypeString = dataTypeString + "Integer";
                break;
            }
            case 4: {
                dataTypeString = dataTypeString + "Float";
                break;
            }
            case 5: {
                dataTypeString = dataTypeString + "Double";
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        switch (INTERP_SELECTOR) {
            case 0: {
                if (OLD_DESCRIPTOR) {
                    interpolation = new javax.media.jai.InterpolationNearest();
                    break;
                }
                interpolation = new InterpolationNearest(range, false, destNoData, dataType);
                break;
            }
            case 1: {
                if (OLD_DESCRIPTOR) {
                    interpolation = new javax.media.jai.InterpolationBilinear(8);
                    break;
                }
                interpolation = new InterpolationBilinear(8, range, false, destNoData, dataType);
                break;
            }
            case 2: {
                if (OLD_DESCRIPTOR) {
                    interpolation = new javax.media.jai.InterpolationBicubic(8);
                    break;
                }
                interpolation = new InterpolationBicubic(8, range, false, destNoData, dataType, true, 8);
                break;
            }
            case 3: {
                interpolation = new javax.media.jai.InterpolationBicubic(8);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong interpolation type");
            }
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageWarp = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            if (OLD_DESCRIPTOR) {
                JAIExt.registerJAIDescriptor((String)"Warp");
                imageWarp = javax.media.jai.operator.WarpDescriptor.create((RenderedImage)image, (Warp)warpObj, (Interpolation)interpolation, (double[])backgroundValues, null);
            } else {
                imageWarp = WarpDescriptor.create((RenderedImage)image, (Warp)warpObj, (Interpolation)interpolation, (double[])backgroundValues, (ROI)roi, null);
            }
            long start = System.nanoTime();
            imageWarp.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println(dataTypeString);
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageWarp instanceof RenderedOp) {
            imageWarp.dispose();
        }
    }
}

