/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import it.geosolutions.jaiext.jts.CoordinateSequence2D;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Dimension;
import java.awt.image.Raster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;

public class VectorBinarizeTest
extends TestBase {
    private static final GeometryFactory gf = new GeometryFactory();
    private static final int TILE_WIDTH = 8;
    WKTReader reader = new WKTReader(gf);

    @Before
    public void setupTileSize() {
        JAI.setDefaultTileSize((Dimension)new Dimension(8, 8));
    }

    @Test
    public void rectanglePolyAcrossTiles() throws Exception {
        int maxx;
        int minx;
        int margin = 3;
        int Ntiles = 3;
        int miny = minx = 3;
        int maxy = maxx = 18;
        String wkt = String.format("POLYGON((%d %d, %d %d, %d %d, %d %d, %d %d))", minx, miny, minx, maxy, maxx, maxy, maxx, miny, minx, miny);
        Polygon poly = (Polygon)this.reader.read(wkt);
        ParameterBlockJAI pb = new ParameterBlockJAI("VectorBinarize");
        pb.setParameter("width", 24);
        pb.setParameter("height", 24);
        pb.setParameter("geometry", (Object)poly);
        RenderedOp dest = JAI.create((String)"VectorBinarize", (ParameterBlock)pb);
        CoordinateSequence2D testPointCS = new CoordinateSequence2D(1);
        Point testPoint = gf.createPoint((CoordinateSequence)testPointCS);
        for (int ytile = 0; ytile < 3; ++ytile) {
            for (int xtile = 0; xtile < 3; ++xtile) {
                Raster tile = dest.getTile(xtile, ytile);
                int y = tile.getMinY();
                for (int iy = 0; iy < tile.getHeight(); ++iy) {
                    testPointCS.setY(0, (double)y + 0.5);
                    int x = tile.getMinX();
                    for (int ix = 0; ix < tile.getWidth(); ++ix) {
                        testPointCS.setX(0, (double)x + 0.5);
                        testPoint.geometryChanged();
                        int expected = poly.intersects((Geometry)testPoint) ? 1 : 0;
                        Assert.assertEquals((String)("Failed test at position " + x + ", " + y + ", expected " + expected + " but got " + tile.getSample(x, y, 0)), (long)expected, (long)tile.getSample(x, y, 0));
                        ++x;
                    }
                    ++y;
                }
            }
        }
    }
}

