/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.vectorbin;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.util.AffineTransformation;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import it.geosolutions.jaiext.jts.CoordinateSequence2D;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.utilities.shape.LiteShape;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileScheduler;
import javax.media.jai.operator.ExtremaDescriptor;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.SubtractDescriptor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class ROIGeometryTest
extends TestBase {
    private static final boolean INTERACTIVE = false;
    private static boolean headless;
    private static boolean isOSX;
    private static GeometryFactory gf;

    @BeforeClass
    public static void beforeClass() {
        GraphicsEnvironment grEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        headless = GraphicsEnvironment.isHeadless();
        String osname = System.getProperty("os.name").replaceAll("\\s", "");
        isOSX = "macosx".equalsIgnoreCase(osname);
        JAI.setDefaultTileSize((Dimension)new Dimension(512, 512));
    }

    @Test
    public void testContains_Point() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        java.awt.Point p0 = new java.awt.Point(-1, 2);
        java.awt.Point p1 = new java.awt.Point(-2, 1);
        Assert.assertTrue((boolean)roi.contains(p0));
        Assert.assertFalse((boolean)roi.contains(p1));
    }

    @Test
    public void testContains_Point2D() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Point2D.Double p0 = new Point2D.Double(-1.0, 2.5);
        Point2D.Double p1 = new Point2D.Double(-2.5, 1.0);
        Assert.assertTrue((boolean)roi.contains((Point2D)p0));
        Assert.assertFalse((boolean)roi.contains((Point2D)p1));
    }

    @Test
    public void testContains_int_int() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.contains(-1, 2));
        Assert.assertFalse((boolean)roi.contains(-2, 1));
    }

    @Test
    public void testContains_double_double() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.contains(-1.0, 2.5));
        Assert.assertFalse((boolean)roi.contains(-2.5, 1.0));
    }

    @Test
    public void testContains_Rectangle() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle r = new Rectangle(-1, -2, 4, 6);
        Assert.assertTrue((boolean)roi.contains(r));
        ++r.width;
        Assert.assertFalse((boolean)roi.contains(r));
    }

    @Test
    public void testContains_Rectangle2D() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle2D.Double r = new Rectangle2D.Double(-1.0, -2.0, 4.0, 6.0);
        Assert.assertTrue((boolean)roi.contains((Rectangle2D)r));
        r = new Rectangle2D.Double(-1.2, -2.0, 4.0, 6.0);
        Assert.assertFalse((boolean)roi.contains((Rectangle2D)r));
    }

    @Test
    public void testContains_intRectArgs() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.contains(-1, -2, 4, 6));
        Assert.assertFalse((boolean)roi.contains(-1, -2, 5, 6));
    }

    @Test
    public void testContains_doubleRectArgs() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.contains(-1.0, -2.0, 4.0, 6.0));
        Assert.assertFalse((boolean)roi.contains(-1.0, -2.0, 5.0, 6.0));
    }

    @Test
    public void testGetBounds() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle expected = new Rectangle(-1, -2, 4, 6);
        Assert.assertTrue((boolean)expected.equals(roi.getBounds()));
    }

    @Test
    public void testGetBounds2D() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle2D.Double expected = new Rectangle2D.Double(-1.1, -2.2, 4.4, 6.6);
        Rectangle2D result = roi.getBounds2D();
        Assert.assertEquals((double)expected.getMinX(), (double)result.getMinX(), (double)1.0E-4);
        Assert.assertEquals((double)expected.getMinY(), (double)result.getMinY(), (double)1.0E-4);
        Assert.assertEquals((double)((RectangularShape)expected).getWidth(), (double)result.getWidth(), (double)1.0E-4);
        Assert.assertEquals((double)((RectangularShape)expected).getHeight(), (double)result.getHeight(), (double)1.0E-4);
    }

    @Test
    public void testIntersects_Rectangle() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle r = new Rectangle(0, 0, 10, 10);
        Assert.assertTrue((boolean)roi.intersects(r));
        r.y = 5;
        r.x = 5;
        Assert.assertFalse((boolean)roi.intersects(r));
    }

    @Test
    public void testIntersects_Rectangle2D() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Rectangle2D.Double r = new Rectangle2D.Double(0.0, 0.0, 10.0, 10.0);
        Assert.assertTrue((boolean)roi.intersects((Rectangle2D)r));
        r = new Rectangle2D.Double(-10.0, -10.0, 5.0, 5.0);
        Assert.assertFalse((boolean)roi.intersects((Rectangle2D)r));
    }

    @Test
    public void testIntersects_intRectArgs() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.intersects(0, 0, 10, 10));
        Assert.assertFalse((boolean)roi.intersects(-10, -10, 5, 5));
    }

    @Test
    public void testIntersects_doubleRectArgs() {
        ROIGeometry roi = this.createRectROI(-1.1, -2.2, 3.3, 4.4);
        Assert.assertTrue((boolean)roi.intersects(-5.0, -5.0, 5.0, 5.0));
        Assert.assertFalse((boolean)roi.intersects(-10.0, -10.0, 5.0, 5.0));
    }

    @Test
    public void canCreateFromEmptyGeometry() {
        this.createEmptyROI();
    }

    @Test
    public void emptyROIContainsPoint() {
        ROIGeometry roi = this.createEmptyROI();
        Assert.assertFalse((boolean)roi.contains(0, 0));
    }

    @Test
    public void emptyROIContainsRect() {
        ROIGeometry empty = this.createEmptyROI();
        Assert.assertFalse((boolean)empty.contains(0, 0, 1, 1));
    }

    @Test
    public void addNonEmptyROIToEmpty() {
        ROIGeometry nonEmpty = this.createRectROI(0.0, 0.0, 10.0, 10.0);
        ROIGeometry empty = this.createEmptyROI();
        ROI result = empty.add((ROI)nonEmpty);
        Assert.assertTrue((boolean)result.getBounds().equals(nonEmpty.getBounds()));
    }

    @Test
    public void addEmptyROIToNonEmptyROI() {
        ROIGeometry nonEmpty = this.createRectROI(0.0, 0.0, 10.0, 10.0);
        ROIGeometry empty = this.createEmptyROI();
        ROI result = nonEmpty.add((ROI)empty);
        Assert.assertTrue((boolean)result.getBounds().equals(nonEmpty.getBounds()));
    }

    @Test
    public void testCheckerBoard() throws Exception {
        String wkt = "MULTIPOLYGON (((4 4, 4 0, 8 0, 8 4, 4 4)), ((4 4, 4 8, 0 8, 0 4, 4 4)))";
        MultiPolygon poly = (MultiPolygon)new WKTReader().read(wkt);
        ROIGeometry g = new ROIGeometry((Geometry)poly);
        ROIShape shape = this.getEquivalentROIShape(g);
        this.assertROIEquivalent((ROI)g, (ROI)shape, "Checkerboard");
    }

    @Test
    public void testLargeConcurrentCheckerBoard() throws Exception {
        String wkt = "MULTIPOLYGON (((400 400, 400 0, 800 0, 800 400, 400 400)), ((400 400, 400 800, 0 800, 0 400, 400 400)))";
        MultiPolygon poly = (MultiPolygon)new WKTReader().read(wkt);
        ImageLayout layout = new ImageLayout(0, 0, 800, 800, 0, 0, 10, 10, null, null);
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        ROIGeometry g = new ROIGeometry((Geometry)poly, hints);
        RenderedOp image = (RenderedOp)g.getAsImage();
        TileScheduler ts = (TileScheduler)image.getRenderingHint(JAI.KEY_TILE_SCHEDULER);
        ts.setParallelism(32);
        ts.setPrefetchParallelism(32);
        ArrayList<java.awt.Point> tiles = new ArrayList<java.awt.Point>();
        for (int i = 0; i < image.getNumXTiles(); ++i) {
            for (int j = 0; j < image.getNumYTiles(); ++j) {
                tiles.add(new java.awt.Point(image.getMinTileX() + i, image.getMinTileY() + j));
            }
        }
        java.awt.Point[] tileArray = tiles.toArray(new java.awt.Point[tiles.size()]);
        ts.prefetchTiles((PlanarImage)image, tileArray);
        Assert.assertEquals((long)0L, (long)image.getMinX());
        Assert.assertEquals((long)0L, (long)image.getMinY());
        Assert.assertEquals((long)10L, (long)image.getTileWidth());
        Assert.assertEquals((long)10L, (long)image.getTileHeight());
        for (int x = 0; x < image.getNumXTiles(); ++x) {
            for (int y = 0; y < image.getNumYTiles(); ++y) {
                Raster tile = image.getTile(x, y);
                int[] pixel = new int[1];
                tile.getPixel(tile.getMinX(), tile.getMinY(), pixel);
                if (x < 40 && y < 40 || x >= 40 && y >= 40) {
                    Assert.assertEquals((String)("Expected 0 at x = " + x + ", y = " + y), (long)0L, (long)pixel[0]);
                    continue;
                }
                Assert.assertEquals((String)("Expected 1 at x = " + x + ", y = " + y), (long)1L, (long)pixel[0]);
            }
        }
    }

    @Test
    public void testTopologyException() throws Exception {
        String wkt = "POLYGON ((4 4, 4 0, 8 0, 8 4, 4 4, 4 0, 8 0, 8 2, 4 4))";
        Polygon poly = (Polygon)new WKTReader().read(wkt);
        ROIGeometry g = new ROIGeometry((Geometry)poly);
        this.assertROIEquivalent((ROI)g, (ROI)g, "Deal with Topology exception");
    }

    @Test
    public void testFractional() throws Exception {
        String wkt = "POLYGON ((0.4 0.4, 0.4 5.6, 4.4 5.6, 4.4 0.4, 0.4 0.4))";
        Polygon poly = (Polygon)new WKTReader().read(wkt);
        ROIGeometry g = new ROIGeometry((Geometry)poly);
        ROIShape shape = this.getEquivalentROIShape(g);
        this.assertROIEquivalent((ROI)g, (ROI)shape, "Fractional");
    }

    @Test
    public void testFractionalUnion() throws Exception {
        String[] coords = new String[]{"1750 1312.5, 508 1312.5, 508 1609, 1750 1609, 1750 1312.5", "508 875, 508 1312, 1750 1312, 1750 875, 508 875", "508 875, 1750 875, 1750 437.5, 508 437.5, 508 875", "508 377, 508 437, 1750 437, 1750 377, 508 377"};
        String[] wkts = new String[]{"POLYGON ((" + coords[0] + "))", "POLYGON ((" + coords[1] + "))", "POLYGON ((" + coords[2] + "))", "POLYGON ((" + coords[3] + "))"};
        int size = wkts.length;
        Polygon[] polygons = new Polygon[size];
        ROIGeometry[] roiGeometries = new ROIGeometry[size];
        ROIShape[] roiShapes = new ROIShape[size];
        ROI unionGeometry = null;
        ROIShape unionShape = null;
        for (int i = 0; i < size; ++i) {
            polygons[i] = (Polygon)new WKTReader().read(wkts[i]);
            roiGeometries[i] = new ROIGeometry((Geometry)polygons[i]);
            GeneralPath gp = new GeneralPath();
            String[] wkt = coords[i].split(",");
            int segments = wkt.length;
            for (int k = 0; k < segments; ++k) {
                String[] x_y = wkt[k].trim().split(" ");
                if (k == 0) {
                    gp.moveTo(Float.valueOf(x_y[0]).floatValue(), Float.valueOf(x_y[1]).floatValue());
                    continue;
                }
                gp.lineTo(Float.valueOf(x_y[0]).floatValue(), Float.valueOf(x_y[1]).floatValue());
            }
            roiShapes[i] = new ROIShape((Shape)gp);
            if (i == 0) {
                unionGeometry = new ROIGeometry(roiGeometries[i].getAsGeometry());
                unionShape = roiShapes[0];
                continue;
            }
            unionGeometry = unionGeometry.add((ROI)roiGeometries[i]);
            unionShape = unionShape.add((ROI)roiShapes[i]);
        }
        this.assertROIEquivalent(unionGeometry, (ROI)unionShape, "Fractional union");
    }

    @Test
    public void testCircles() throws Exception {
        if (isOSX) {
            System.out.println("skipping testCircles on OSX");
        } else {
            int[] buffers = new int[]{3, 5, 7, 8, 10, 15, 20};
            for (int i = 0; i < buffers.length; ++i) {
                Point p = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
                Geometry buffer = p.buffer((double)buffers[i]);
                ROIGeometry g = new ROIGeometry(buffer);
                ROIShape shape = this.getEquivalentROIShape(g);
                this.assertROIEquivalent((ROI)g, (ROI)shape, "Circle");
            }
        }
    }

    @Test
    @Ignore(value="not working on any platform ?")
    public void testUnion() throws Exception {
        Point p1 = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
        Point p2 = new GeometryFactory().createPoint(new Coordinate(20.0, 10.0));
        Geometry buffer1 = p1.buffer(15.0);
        Geometry buffer2 = p2.buffer(15.0);
        ROIGeometry rg1 = new ROIGeometry(buffer1);
        ROIGeometry rg2 = new ROIGeometry(buffer2);
        ROIShape rs1 = this.getEquivalentROIShape(rg1);
        ROIShape rs2 = this.getEquivalentROIShape(rg2);
        this.assertROIEquivalent((ROI)rg1, (ROI)rs1, "circle 1 ROIG, circle 1 ROIS");
        this.assertROIEquivalent((ROI)rg2, (ROI)rs2, "circle 2 ROIG, circle 2 ROIS");
    }

    @Test
    @Ignore(value="not working on any platform ?")
    public void testIntersect() throws Exception {
        Point p1 = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
        Point p2 = new GeometryFactory().createPoint(new Coordinate(20.0, 10.0));
        Geometry buffer1 = p1.buffer(15.0);
        Geometry buffer2 = p2.buffer(15.0);
        ROIGeometry rg1 = new ROIGeometry(buffer1);
        ROIGeometry rg2 = new ROIGeometry(buffer2);
        ROI rgIntersection = rg1.intersect((ROI)rg2);
        ROIShape rs1 = this.getEquivalentROIShape(rg1);
        ROIShape rs2 = this.getEquivalentROIShape(rg2);
        ROI rsIntersection = rs1.intersect((ROI)rs2);
        this.assertROIEquivalent(rgIntersection, rsIntersection, "Intersection");
    }

    @Test
    public void intersectImageROI() throws ParseException {
        ROI leftRight = this.createLeftRightROIImage();
        ROIGeometry topBottom = this.createTopBottomROIGeometry();
        ROI result = topBottom.intersect(leftRight);
        Assert.assertTrue((boolean)result.contains(64, 64));
        Assert.assertFalse((boolean)result.contains(192, 64));
        Assert.assertFalse((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void intersectInvalidPolygon() throws ParseException, IOException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        ROIGeometry bowTie = this.createBowTieROIGeometry();
        ROI result = bowTie.intersect((ROI)leftRight);
        Assert.assertTrue((boolean)result.contains(64, 64));
        Assert.assertFalse((boolean)result.contains(192, 64));
        Assert.assertFalse((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void testSubtract() throws Exception {
        Point p1 = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
        Point p2 = new GeometryFactory().createPoint(new Coordinate(20.0, 10.0));
        Geometry buffer1 = p1.buffer(15.0);
        Geometry buffer2 = p2.buffer(15.0);
        ROIGeometry rg1 = new ROIGeometry(buffer1);
        ROIGeometry rg2 = new ROIGeometry(buffer2);
        ROI rgSubtract = rg1.subtract((ROI)rg2);
        ROIShape rs1 = this.getEquivalentROIShape(rg1);
        ROIShape rs2 = this.getEquivalentROIShape(rg2);
        ROI rsSubtract = rs1.subtract((ROI)rs2);
        this.assertROIEquivalent(rgSubtract, rsSubtract, "Subtract");
    }

    @Test
    public void subtractImageROI() throws ParseException {
        ROI leftRight = this.createLeftRightROIImage();
        ROIGeometry topBottom = this.createTopBottomROIGeometry();
        ROI result = topBottom.subtract(leftRight);
        Assert.assertFalse((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertFalse((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void subtractInvalidPolygon() throws ParseException, IOException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        ROIGeometry bowTie = this.createBowTieROIGeometry();
        ROI result = bowTie.subtract((ROI)leftRight);
        Assert.assertFalse((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertFalse((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void testXor() throws Exception {
        if (isOSX) {
            System.out.println("skipping testXor on OSX");
        } else {
            Point p1 = new GeometryFactory().createPoint(new Coordinate(10.0, 10.0));
            Point p2 = new GeometryFactory().createPoint(new Coordinate(20.0, 10.0));
            Geometry buffer1 = p1.buffer(15.0);
            Geometry buffer2 = p2.buffer(15.0);
            ROIGeometry rg1 = new ROIGeometry(buffer1);
            ROIGeometry rg2 = new ROIGeometry(buffer2);
            ROI rgXor = rg1.exclusiveOr((ROI)rg2);
            ROIShape rs1 = this.getEquivalentROIShape(rg1);
            ROIShape rs2 = this.getEquivalentROIShape(rg2);
            ROI rsXor = rs1.exclusiveOr((ROI)rs2);
            this.assertROIEquivalent(rgXor, rsXor, "Xor");
        }
    }

    @Test
    public void xorImageROI() throws ParseException {
        ROI leftRight = this.createLeftRightROIImage();
        ROIGeometry topBottom = this.createTopBottomROIGeometry();
        ROI result = topBottom.exclusiveOr(leftRight);
        Assert.assertFalse((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertTrue((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void xorInvalidPolygon() throws ParseException, IOException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        ROIGeometry bowTie = this.createBowTieROIGeometry();
        ROI result = bowTie.exclusiveOr((ROI)leftRight);
        Assert.assertFalse((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertTrue((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
        Assert.assertTrue((boolean)result.contains(120, 32));
        Assert.assertTrue((boolean)result.contains(120, 96));
        Assert.assertFalse((boolean)result.contains(140, 32));
        Assert.assertFalse((boolean)result.contains(140, 96));
    }

    @Test
    public void testRotatedRectangle() throws Exception {
        if (isOSX) {
            System.out.println("skipping testRotatedRectangle on OSX");
        } else {
            Polygon polygon = (Polygon)new WKTReader().read("POLYGON((20 0, 50 -30, 30 -50, 0 -20, 20 0))");
            ROIGeometry g = new ROIGeometry((Geometry)polygon);
            ROIShape shape = this.getEquivalentROIShape(g);
            this.assertROIEquivalent((ROI)g, (ROI)shape, "RotatedRectangle");
        }
    }

    @Test
    public void testRotatedRectangleUnion() throws Exception {
        if (isOSX) {
            System.out.println("skipping testRotatedRectangleUnion on OSX");
        } else {
            Polygon polygon1 = (Polygon)new WKTReader().read("POLYGON((20 0, 50 -30, 30 -50, 0 -20, 20 0))");
            Polygon polygon2 = (Polygon)new WKTReader().read("POLYGON((60 -40, 80 -20, 40 20, 20 0, 60 -40))");
            ROIGeometry geom1 = new ROIGeometry((Geometry)polygon1);
            ROIShape shape1 = this.getEquivalentROIShape(geom1);
            ROIGeometry geom2 = new ROIGeometry((Geometry)polygon2);
            ROIShape shape2 = this.getEquivalentROIShape(geom2);
            ROI geomUnion = geom1.add((ROI)geom2);
            ROI shapeUnion = shape1.add((ROI)shape2);
            this.assertROIEquivalent(geomUnion, shapeUnion, "RotatedUnion");
        }
    }

    @Test
    public void testRotatedRectangleIntersection() throws Exception {
        if (isOSX) {
            System.out.println("skipping testRotatedRectangleIntersection on OSX");
        } else {
            Polygon polygon1 = (Polygon)new WKTReader().read("POLYGON((20 0, 50 -30, 30 -50, 0 -20, 20 0))");
            Polygon polygon2 = (Polygon)new WKTReader().read("POLYGON((40 -40, 60 -20, 20 20, 0 0, 40 -40))");
            ROIGeometry geom1 = new ROIGeometry((Geometry)polygon1);
            ROIShape shape1 = this.getEquivalentROIShape(geom1);
            ROIGeometry geom2 = new ROIGeometry((Geometry)polygon2);
            ROIShape shape2 = this.getEquivalentROIShape(geom2);
            ROI geomUnion = geom1.intersect((ROI)geom2);
            ROI shapeUnion = shape1.intersect((ROI)shape2);
            this.assertROIEquivalent(geomUnion, shapeUnion, "RotatedIntersection");
        }
    }

    @Test
    public void testUnionFractional() throws Exception {
        String geom1 = "POLYGON ((256.0156254550953 384.00000013906043, 384.00000082678343 384.00000013906043, 384.00000082678343 256.00000005685433, 256.0000004550675 256.00000005685433, 256.0000004550675 384.00000013906043, 256.0156254550953 384.00000013906043))";
        String geom2 = "POLYGON ((384.0156256825708 128.00000008217478, 512.0000010543083 128.00000008217478, 512.0000010543083 -0.0000000000291038, 384.00000068254303 -0.0000000000291038, 384.00000068254303 128.00000008217478, 384.0156256825708 128.00000008217478))";
        WKTReader wktReader = new WKTReader();
        Geometry geometry1 = wktReader.read("POLYGON ((256.0156254550953 384.00000013906043, 384.00000082678343 384.00000013906043, 384.00000082678343 256.00000005685433, 256.0000004550675 256.00000005685433, 256.0000004550675 384.00000013906043, 256.0156254550953 384.00000013906043))");
        Geometry geometry2 = wktReader.read("POLYGON ((384.0156256825708 128.00000008217478, 512.0000010543083 128.00000008217478, 512.0000010543083 -0.0000000000291038, 384.00000068254303 -0.0000000000291038, 384.00000068254303 128.00000008217478, 384.0156256825708 128.00000008217478))");
        ROIGeometry roiGeom1 = new ROIGeometry(geometry1);
        ROIGeometry roiGeom2 = new ROIGeometry(geometry2);
        ROI roiGeometryUnion = roiGeom1.add((ROI)roiGeom2);
        ROIShape roiShape1 = this.getEquivalentROIShape(roiGeom1);
        ROIShape roiShape2 = this.getEquivalentROIShape(roiGeom2);
        ROI roiShapeUnion = roiShape1.add((ROI)roiShape2);
        this.assertROIEquivalent(roiGeometryUnion, roiShapeUnion, "Union");
    }

    @Test
    public void testUnionTransformedFractional() throws Exception {
        if (isOSX) {
            System.out.println("skipping testUnionTransformedFractional on OSX");
        } else {
            String geom1 = "POLYGON ((256.0156254550953 384.00000013906043, 384.00000082678343 384.00000013906043, 384.00000082678343 256.00000005685433, 256.0000004550675 256.00000005685433, 256.0000004550675 384.00000013906043, 256.0156254550953 384.00000013906043))";
            String geom2 = "POLYGON ((384.0156256825708 128.00000008217478, 512.0000010543083 128.00000008217478, 512.0000010543083 -0.0000000000291038, 384.00000068254303 -0.0000000000291038, 384.00000068254303 128.00000008217478, 384.0156256825708 128.00000008217478))";
            WKTReader wktReader = new WKTReader();
            Geometry geometry1 = wktReader.read("POLYGON ((256.0156254550953 384.00000013906043, 384.00000082678343 384.00000013906043, 384.00000082678343 256.00000005685433, 256.0000004550675 256.00000005685433, 256.0000004550675 384.00000013906043, 256.0156254550953 384.00000013906043))");
            Geometry geometry2 = wktReader.read("POLYGON ((384.0156256825708 128.00000008217478, 512.0000010543083 128.00000008217478, 512.0000010543083 -0.0000000000291038, 384.00000068254303 -0.0000000000291038, 384.00000068254303 128.00000008217478, 384.0156256825708 128.00000008217478))");
            geometry1.apply((CoordinateSequenceFilter)new AffineTransformation(1.1, 1.1, 0.0, 0.0, 1.1, 0.0));
            geometry2.apply((CoordinateSequenceFilter)new AffineTransformation(0.0, 1.1, 0.0, 1.1, 0.0, 0.0));
            ROIGeometry roiGeom1 = new ROIGeometry(geometry1);
            ROIGeometry roiGeom2 = new ROIGeometry(geometry2);
            ROI roiGeometryUnion = roiGeom1.add((ROI)roiGeom2);
            ROIShape roiShape1 = this.getEquivalentROIShape(roiGeom1);
            ROIShape roiShape2 = this.getEquivalentROIShape(roiGeom2);
            ROI roiShapeUnion = roiShape1.add((ROI)roiShape2);
            this.assertROIEquivalent(roiGeometryUnion, roiShapeUnion, "Union");
        }
    }

    @Test
    public void unionImageROI() throws ParseException {
        ROI leftRight = this.createLeftRightROIImage();
        ROIGeometry topBottom = this.createTopBottomROIGeometry();
        ROI result = topBottom.add(leftRight);
        Assert.assertTrue((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertTrue((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
    }

    @Test
    public void unionInvalidPolygon() throws ParseException, IOException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        ROIGeometry bowTie = this.createBowTieROIGeometry();
        ROI result = bowTie.add((ROI)leftRight);
        Assert.assertTrue((boolean)result.contains(64, 64));
        Assert.assertTrue((boolean)result.contains(192, 64));
        Assert.assertTrue((boolean)result.contains(64, 192));
        Assert.assertFalse((boolean)result.contains(192, 192));
        Assert.assertFalse((boolean)result.contains(130, 32));
        Assert.assertFalse((boolean)result.contains(130, 96));
    }

    @Test
    public void testRectangleListSimple() throws ParseException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        LinkedList rectangles = leftRight.getAsRectangleList(-50, -50, 500, 500);
        this.assertSingleLeftRectangle(rectangles, 0, 0, 128, 256);
        rectangles = leftRight.getAsRectangleList(0, 0, 256, 256);
        this.assertSingleLeftRectangle(rectangles, 0, 0, 128, 256);
        rectangles = leftRight.getAsRectangleList(64, 64, 64, 64);
        this.assertSingleLeftRectangle(rectangles, 64, 64, 64, 64);
        rectangles = leftRight.getAsRectangleList(130, 0, 64, 64);
        Assert.assertNull((Object)rectangles);
    }

    private void assertSingleLeftRectangle(LinkedList rectangles, int x, int y, int w, int h) {
        Assert.assertEquals((long)1L, (long)rectangles.size());
        Rectangle r = (Rectangle)rectangles.getFirst();
        this.assertRectangle(x, y, w, h, r);
    }

    private void assertRectangle(int x, int y, int w, int h, Rectangle r) {
        Assert.assertEquals((long)x, (long)r.x);
        Assert.assertEquals((long)y, (long)r.y);
        Assert.assertEquals((long)w, (long)r.width);
        Assert.assertEquals((long)h, (long)r.height);
    }

    @Test
    public void testRectangleListBowTie() throws ParseException {
        ROIGeometry bowTie = this.createBowTieROIGeometry();
        LinkedList rectangles = bowTie.getAsRectangleList(-50, -50, 500, 500);
        Assert.assertEquals((long)254L, (long)rectangles.size());
        int expectedWidth = 1;
        int y = 0;
        for (int i = 0; i < 254; ++i) {
            boolean even = i % 2 == 0;
            int x = even ? 0 : 256 - expectedWidth;
            Rectangle r = (Rectangle)rectangles.get(i);
            Assert.assertEquals((long)x, (long)r.x);
            Assert.assertEquals((long)y, (long)r.y);
            Assert.assertEquals((long)expectedWidth, (long)r.width);
            if (i == 126 || i == 127) {
                Assert.assertEquals((long)2L, (long)r.height);
            } else {
                Assert.assertEquals((long)1L, (long)r.height);
            }
            if (even) continue;
            expectedWidth = i < 126 ? (expectedWidth += 2) : (expectedWidth -= 2);
            if (i == 127) {
                y += 2;
                continue;
            }
            ++y;
        }
    }

    @Test
    public void testRectangleListSimpleReduction() throws IOException, ParseException {
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        ROIGeometry topRight = this.createTopBottomROIGeometry();
        ROI threeQuarters = leftRight.add((ROI)topRight);
        LinkedList rectangles = threeQuarters.getAsRectangleList(0, 0, 256, 256);
        Assert.assertEquals((long)2L, (long)rectangles.size());
        Rectangle r1 = (Rectangle)rectangles.get(0);
        this.assertRectangle(0, 0, 256, 128, r1);
        Rectangle r2 = (Rectangle)rectangles.get(1);
        this.assertRectangle(0, 128, 128, 128, r2);
    }

    @Test
    public void testBitmaskSimple() throws ParseException {
        int j;
        int i;
        ROIGeometry leftRight = this.createLeftRightROIGeometry();
        int[][] mask = leftRight.getAsBitmask(130, 0, 64, 64, (int[][])null);
        Assert.assertNull((Object)mask);
        mask = leftRight.getAsBitmask(0, 0, 256, 256, (int[][])null);
        Assert.assertEquals((long)256L, (long)mask.length);
        for (i = 0; i < mask.length; ++i) {
            Assert.assertEquals((long)8L, (long)mask[i].length);
            for (j = 0; j < mask[i].length; ++j) {
                if (j < 4) {
                    Assert.assertEquals((long)-1L, (long)mask[i][j]);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)mask[i][j]);
            }
        }
        mask = leftRight.getAsBitmask(64, 64, 128, 128, (int[][])null);
        Assert.assertEquals((long)128L, (long)mask.length);
        for (i = 0; i < mask.length; ++i) {
            Assert.assertEquals((long)4L, (long)mask[i].length);
            for (j = 0; j < mask[i].length; ++j) {
                if (j < 2) {
                    Assert.assertEquals((long)-1L, (long)mask[i][j]);
                    continue;
                }
                Assert.assertEquals((long)0L, (long)mask[i][j]);
            }
        }
    }

    ROI createLeftRightROIImage() {
        BufferedImage bi = new BufferedImage(256, 256, 12);
        Graphics2D graphics = bi.createGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, 128, 256);
        graphics.dispose();
        ROI roiImage = new ROI((RenderedImage)bi);
        return roiImage;
    }

    ROIGeometry createBowTieROIGeometry() throws ParseException {
        Polygon bowtie = (Polygon)new WKTReader().read("POLYGON ((0 0, 256 128, 256 0, 0 128, 0 0))");
        ROIGeometry roiGeometry = new ROIGeometry((Geometry)bowtie);
        return roiGeometry;
    }

    ROIGeometry createTopBottomROIGeometry() throws ParseException {
        Polygon rectangle = (Polygon)new WKTReader().read("POLYGON ((0 0, 256 0, 256 128, 0 128, 0 0))");
        ROIGeometry roiGeometry = new ROIGeometry((Geometry)rectangle);
        return roiGeometry;
    }

    ROIGeometry createLeftRightROIGeometry() throws ParseException {
        Polygon rectangle = (Polygon)new WKTReader().read("POLYGON ((0 0, 128 0, 128 256, 0 256, 0 0))");
        ROIGeometry roiGeometry = new ROIGeometry((Geometry)rectangle);
        return roiGeometry;
    }

    ROIShape getEquivalentROIShape(ROIGeometry g) {
        Shape shape = g.getAsShape();
        return new ROIShape(shape);
    }

    void assertROIEquivalent(ROI first, ROI second, String title) throws IOException {
        PlanarImage firstImage = first.getAsImage();
        PlanarImage secondImage = second.getAsImage();
        this.assertImagesEqual((RenderedImage)firstImage, (RenderedImage)secondImage);
    }

    private boolean assertReportErrorImagesEqual(ROI first, ROI second) {
        PlanarImage image1 = first.getAsImage();
        PlanarImage image2 = second.getAsImage();
        boolean isOk = true;
        isOk &= image1.getWidth() == image2.getWidth();
        isOk &= image1.getHeight() == image2.getHeight();
        double[][] extrema = this.computeExtrema((RenderedImage)image1, (RenderedImage)image2);
        for (int band = 0; band < extrema.length; ++band) {
            isOk &= Math.abs(0.0 - extrema[0][band]) < 1.0E-9;
            isOk &= Math.abs(0.0 - extrema[1][band]) < 1.0E-9;
        }
        return isOk;
    }

    private void printError(ROI first, ROI second) {
        if (first == null || second == null) {
            System.out.println("A ROI is missing");
        }
        if (first instanceof ROIGeometry) {
            ROIGeometryTest.printGeometry((ROIGeometry)first, "ROIGeometry");
            ROIGeometryTest.printRoiShape((ROIShape)second, "ROIShape");
        } else {
            ROIGeometryTest.printGeometry((ROIGeometry)second, "ROIGeometry");
            ROIGeometryTest.printRoiShape((ROIShape)first, "ROIShape");
        }
    }

    void assertImagesEqual(RenderedImage image1, RenderedImage image2) {
        Assert.assertEquals((long)image1.getWidth(), (long)image2.getWidth());
        Assert.assertEquals((long)image1.getHeight(), (long)image2.getHeight());
        RenderedOp int1 = FormatDescriptor.create((RenderedImage)image1, (Integer)2, null);
        RenderedOp int2 = FormatDescriptor.create((RenderedImage)image2, (Integer)2, null);
        RenderedOp diff = SubtractDescriptor.create((RenderedImage)int1, (RenderedImage)int2, null);
        RenderedOp extremaImg = ExtremaDescriptor.create((RenderedImage)diff, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)Integer.MAX_VALUE, null);
        double[][] extrema = (double[][])extremaImg.getProperty("extrema");
        for (int band = 0; band < extrema.length; ++band) {
            Assert.assertEquals((String)"Minimum should be 0", (double)0.0, (double)extrema[0][band], (double)1.0E-9);
            Assert.assertEquals((String)"Maximum should be 0", (double)0.0, (double)extrema[1][band], (double)1.0E-9);
        }
    }

    private double[][] computeExtrema(RenderedImage image1, RenderedImage image2) {
        RenderedOp int1 = FormatDescriptor.create((RenderedImage)image1, (Integer)2, null);
        RenderedOp int2 = FormatDescriptor.create((RenderedImage)image2, (Integer)2, null);
        RenderedOp diff = SubtractDescriptor.create((RenderedImage)int1, (RenderedImage)int2, null);
        RenderedOp extremaImg = ExtremaDescriptor.create((RenderedImage)diff, null, (Integer)1, (Integer)1, (Boolean)false, (Integer)Integer.MAX_VALUE, null);
        double[][] extrema = (double[][])extremaImg.getProperty("extrema");
        return extrema;
    }

    private void printRoiShape(ROIShape rs1) {
        PathIterator pt1 = rs1.getAsShape().getPathIterator(null);
        float[] coords = new float[2];
        System.out.print("POLYGON ((");
        while (!pt1.isDone()) {
            pt1.currentSegment(coords);
            System.out.print(coords[0] + " " + coords[1] + ",");
            pt1.next();
        }
        System.out.println("))/n");
    }

    private static void printShape(Shape shape, String title) {
        PathIterator pt1 = shape.getPathIterator(null);
        double[] coords = new double[2];
        StringBuilder sb = new StringBuilder();
        sb.append(title + " POLYGON ((");
        while (!pt1.isDone()) {
            int type = pt1.currentSegment(coords);
            sb.append(ROIGeometryTest.getPathType(type) + "(" + coords[0] + " " + coords[1] + "),");
            pt1.next();
        }
        String string = sb.toString();
        sb = new StringBuilder(string.substring(0, string.length() - 1));
        sb.append("))\n");
        System.out.println(sb.toString());
    }

    private static String getPathType(int pathType) {
        switch (pathType) {
            case 4: {
                return "]";
            }
            case 1: {
                return " ";
            }
            case 0: {
                return "[";
            }
            case 2: {
                return "QUADTO";
            }
            case 3: {
                return "CUBICTO";
            }
        }
        return "UNKNOWN";
    }

    private static void printRoiShape(ROIShape rs1, String title) {
        ROIGeometryTest.printShape(rs1.getAsShape(), title);
    }

    private static void printGeometry(ROIGeometry g, String title) {
        ROIGeometryTest.printShape((Shape)new LiteShape(g.getAsGeometry()), title);
    }

    private ROIGeometry createRectROI(double x0, double y0, double x1, double y1) {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{x0, y0, x0, y1, x1, y1, x1, y0, x0, y0});
        Polygon poly = gf.createPolygon(gf.createLinearRing((CoordinateSequence)cs), null);
        return new ROIGeometry((Geometry)poly, false);
    }

    private ROIGeometry createEmptyROI() {
        Polygon poly = gf.createPolygon(null, null);
        return new ROIGeometry((Geometry)poly, false);
    }

    static {
        gf = new GeometryFactory();
    }
}

