/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.testclasses;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.utilities.ImageUtilities;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ROIShape;
import javax.media.jai.TiledImage;
import org.junit.BeforeClass;

public abstract class TestBase {
    public static int DEFAULT_WIDTH = 256;
    public static int DEFAULT_HEIGHT = 256;
    public static final int DEFAULT_SUBSAMPLE_BITS = 8;
    public static final int DEFAULT_PRECISION_BITS = 8;
    public static boolean INTERACTIVE = Boolean.getBoolean("JAI.Ext.Interactive");
    public static boolean IMAGE_FILLER = Boolean.valueOf(System.getProperty("JAI.Ext.ImageFill", "true"));
    public static Integer INVERSE_SCALE = Integer.getInteger("JAI.Ext.InverseScale", 0);
    public static Integer TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    protected double destinationNoData;
    protected float transX = 0.0f;
    protected float transY = 0.0f;
    protected float scaleX = 0.5f;
    protected float scaleY = 0.5f;

    protected ROIShape roiCreation() {
        int roiHeight = DEFAULT_HEIGHT * 3 / 4;
        int roiWidth = DEFAULT_WIDTH * 3 / 4;
        Rectangle roiBound = new Rectangle(0, 0, roiWidth, roiHeight);
        ROIShape roi = new ROIShape((Shape)roiBound);
        return roi;
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary) {
        return TestBase.createTestImage(dataType, width, height, noDataValue, isBinary, 3);
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary, int bands) {
        return TestBase.createTestImage(dataType, width, height, noDataValue, isBinary, bands, null);
    }

    public static RenderedImage createTestImage(int dataType, int width, int height, Number noDataValue, boolean isBinary, int numBands, Number validData) {
        SampleModel sm;
        if (isBinary) {
            sm = new MultiPixelPackedSampleModel(dataType, width, height, 1);
            numBands = 1;
        } else {
            int imageDim = width * height;
            if (numBands == 3 || numBands == 4) {
                int[] bandOffsets = new int[numBands];
                for (int i = 0; i < numBands; ++i) {
                    bandOffsets[i] = imageDim * i;
                }
                sm = new ComponentSampleModel(dataType, width, height, numBands, width, bandOffsets);
            } else {
                sm = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
            }
        }
        return TestBase.createTestImage(width, height, noDataValue, numBands, validData, sm);
    }

    public static RenderedImage createTestImage(int width, int height, Number noDataValue, int numBands, Number validData, SampleModel sm) {
        TiledImage used;
        boolean isBinary = ImageUtilities.isBinary((SampleModel)sm);
        int valueB = validData != null ? (int)validData.byteValue() : 64;
        int valueUS = validData != null ? (int)validData.shortValue() : 8191;
        int valueS = validData != null ? (int)validData.shortValue() : -50;
        int valueI = validData != null ? validData.intValue() : 100;
        float valueF = validData != null ? validData.floatValue() : 635.0f;
        double valueD = validData != null ? validData.doubleValue() : 1020.0;
        boolean fillImage = IMAGE_FILLER;
        int tileW = (int)Math.ceil((double)width / 8.0);
        int tileH = (int)Math.ceil((double)height / 8.0);
        if (sm instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mpsm = (MultiPixelPackedSampleModel)sm;
            int bits = mpsm.getSampleSize(0);
            int size = (int)Math.pow(2.0, bits);
            byte[] reds = new byte[size];
            byte[] blues = new byte[size];
            byte[] greens = new byte[size];
            for (int i = 0; i < size; ++i) {
                blues[i] = greens[i] = (byte)((double)(255 * size) / (double)(i + 1));
                reds[i] = greens[i];
            }
            IndexColorModel icm = new IndexColorModel(bits, size, reds, blues, greens);
            used = new TiledImage(0, 0, width, height, 0, 0, sm, (ColorModel)icm);
        } else {
            used = new TiledImage(sm, tileW, tileH);
        }
        Byte crossValueByte = 0;
        Short crossValueUShort = 0;
        Short crossValueShort = 0;
        Integer crossValueInteger = 0;
        Float crossValueFloat = Float.valueOf(0.0f);
        Double crossValueDouble = 0.0;
        int dataType = sm.getDataType();
        if (noDataValue != null) {
            switch (dataType) {
                case 0: {
                    crossValueByte = noDataValue.byteValue();
                    break;
                }
                case 1: {
                    crossValueUShort = noDataValue.shortValue();
                    break;
                }
                case 2: {
                    crossValueShort = noDataValue.shortValue();
                    break;
                }
                case 3: {
                    crossValueInteger = noDataValue.intValue();
                    break;
                }
                case 4: {
                    crossValueFloat = Float.valueOf(noDataValue.floatValue());
                    break;
                }
                case 5: {
                    crossValueDouble = noDataValue.doubleValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
        int imgBinX = width / 4;
        int imgBinY = height / 4;
        int imgBinWidth = imgBinX + width / 4;
        int imgBinHeight = imgBinY + height / 4;
        for (int b = 0; b < numBands; ++b) {
            for (int j = 0; j < width; ++j) {
                block65: for (int k = 0; k < height; ++k) {
                    if (noDataValue != null && (j == k || j == width - k - 1)) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                continue block65;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                continue block65;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                continue block65;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                continue block65;
                            }
                            case 4: {
                                used.setSample(j, k, b, crossValueFloat.floatValue());
                                continue block65;
                            }
                            case 5: {
                                used.setSample(j, k, b, crossValueDouble.doubleValue());
                                continue block65;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (!isBinary && fillImage) {
                        if (j >= 20 && j < 50 && k >= 20 && k < 50) {
                            switch (dataType) {
                                case 0: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 1: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 2: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 3: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 4: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                case 5: {
                                    used.setSample(j, k, b, 0);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException("Wrong data type");
                                }
                            }
                            if (j < 30 || j >= 40 || k < 20 || k >= 30) continue;
                            switch (dataType) {
                                case 0: {
                                    used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                    continue block65;
                                }
                                case 1: {
                                    used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                    continue block65;
                                }
                                case 2: {
                                    used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                    continue block65;
                                }
                                case 3: {
                                    used.setSample(j, k, b, crossValueInteger.intValue());
                                    continue block65;
                                }
                                case 4: {
                                    used.setSample(j, k, b, crossValueFloat.floatValue());
                                    continue block65;
                                }
                                case 5: {
                                    used.setSample(j, k, b, crossValueDouble.doubleValue());
                                    continue block65;
                                }
                                default: {
                                    throw new IllegalArgumentException("Wrong data type");
                                }
                            }
                        }
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, valueB + b);
                                continue block65;
                            }
                            case 1: {
                                used.setSample(j, k, b, valueUS + b);
                                continue block65;
                            }
                            case 2: {
                                used.setSample(j, k, b, valueS + b);
                                continue block65;
                            }
                            case 3: {
                                used.setSample(j, k, b, valueI + b);
                                continue block65;
                            }
                            case 4: {
                                float data = valueF + (float)b / 3.0f;
                                used.setSample(j, k, b, data);
                                continue block65;
                            }
                            case 5: {
                                double dataD = valueD + (double)b / 3.0;
                                used.setSample(j, k, b, dataD);
                                continue block65;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (isBinary && j > imgBinX && j < imgBinWidth && j > imgBinY && j < imgBinHeight) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                continue block65;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                continue block65;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                continue block65;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                continue block65;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (noDataValue != null && j >= 2 && j < 10 && k >= 2 && k < 10) {
                        switch (dataType) {
                            case 0: {
                                used.setSample(j, k, b, (int)crossValueByte.byteValue());
                                break;
                            }
                            case 1: {
                                used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                                break;
                            }
                            case 2: {
                                used.setSample(j, k, b, (int)crossValueShort.shortValue());
                                break;
                            }
                            case 3: {
                                used.setSample(j, k, b, crossValueInteger.intValue());
                                break;
                            }
                            case 4: {
                                used.setSample(j, k, b, crossValueFloat.floatValue());
                                break;
                            }
                            case 5: {
                                used.setSample(j, k, b, crossValueDouble.doubleValue());
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Wrong data type");
                            }
                        }
                    }
                    if (j < 150 || j >= 170 || k < 90 || k >= 110) continue;
                    switch (dataType) {
                        case 0: {
                            used.setSample(j, k, b, (int)crossValueByte.byteValue());
                            continue block65;
                        }
                        case 1: {
                            used.setSample(j, k, b, (int)crossValueUShort.shortValue());
                            continue block65;
                        }
                        case 2: {
                            used.setSample(j, k, b, (int)crossValueShort.shortValue());
                            continue block65;
                        }
                        case 3: {
                            used.setSample(j, k, b, crossValueInteger.intValue());
                            continue block65;
                        }
                        case 4: {
                            used.setSample(j, k, b, crossValueFloat.floatValue());
                            continue block65;
                        }
                        case 5: {
                            used.setSample(j, k, b, crossValueDouble.doubleValue());
                            continue block65;
                        }
                        default: {
                            throw new IllegalArgumentException("Wrong data type");
                        }
                    }
                }
            }
        }
        return used;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static RenderedImage createIndexedImage(int defaultWidth, int defaultHeight, boolean transparentPixel, boolean addAlpha) {
        IndexColorModel icm;
        int SIZE = 255;
        byte[] reds = new byte[SIZE];
        byte[] greens = new byte[SIZE];
        byte[] blues = new byte[SIZE];
        byte[] alphas = new byte[SIZE];
        for (int i = 0; i < reds.length; ++i) {
            reds[i] = (byte)(0xFF & i);
            greens[i] = (byte)(0xFF & i);
            blues[i] = (byte)(0xFF & i);
            alphas[i] = (byte)(0xFF & i);
        }
        if (addAlpha) {
            if (transparentPixel) throw new IllegalArgumentException("Unsupported combination, transparent pixel and alpha");
            icm = new IndexColorModel(8, SIZE, reds, greens, blues, alphas);
        } else {
            icm = transparentPixel ? new IndexColorModel(8, SIZE, reds, greens, blues, 0) : new IndexColorModel(8, SIZE, reds, greens, blues);
        }
        BufferedImage bi = new BufferedImage(defaultWidth, defaultHeight, 13, icm);
        int k = 0;
        int[] pixel = new int[1];
        WritableRaster data = bi.getRaster();
        for (int i = 0; i < defaultHeight; ++i) {
            for (int j = 0; j < defaultWidth; ++j) {
                pixel[0] = k;
                data.setPixel(j, i, pixel);
                k = (k + 1) % 255;
            }
        }
        return bi;
    }

    @BeforeClass
    public static void setup() {
        JAIExt.initJAIEXT();
    }

    public static enum TransformationType {
        ROTATE_OP(0),
        TRANSLATE_OP(2),
        SCALE_OP(1),
        ALL(3);

        private int value;

        private TransformationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TestSelection {
        NO_ROI_ONLY_DATA(0),
        ROI_ACCESSOR_ONLY_DATA(1),
        ROI_ONLY_DATA(2),
        ROI_ACCESSOR_NO_DATA(3),
        NO_ROI_NO_DATA(4),
        ROI_NO_DATA(5),
        BINARY_ROI_ACCESSOR_NO_DATA(6);

        private int type;

        private TestSelection(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum ScaleType {
        MAGNIFY(0),
        REDUCTION(1);

        private int type;

        private ScaleType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }

    public static enum InterpolationType {
        NEAREST_INTERP(0),
        BILINEAR_INTERP(1),
        BICUBIC_INTERP(2),
        GENERAL_INTERP(3);

        private int type;

        private InterpolationType(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }
    }
}

