/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.jts;

import it.geosolutions.jaiext.jts.CoordinateSequence2D;
import org.junit.Assert;
import org.junit.Test;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class CoordinateSequence2DTest {
    private static final double TOL = 1.0E-4;

    @Test
    public void emptySequenceInt() {
        CoordinateSequence2D cs = new CoordinateSequence2D(0);
        Assert.assertEquals((long)0L, (long)cs.size());
    }

    @Test
    public void emptySequenceXY() {
        CoordinateSequence2D cs = new CoordinateSequence2D(null);
        Assert.assertEquals((long)0L, (long)cs.size());
    }

    @Test
    public void testGetDimension() {
        CoordinateSequence2D cs = new CoordinateSequence2D(1);
        Assert.assertEquals((long)2L, (long)cs.getDimension());
    }

    @Test
    public void testGetCoordinate() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.1, 1.2, 2.1, 2.2});
        Coordinate c0 = cs.getCoordinate(0);
        Assert.assertEquals((double)1.1, (double)c0.x, (double)1.0E-4);
        Assert.assertEquals((double)1.2, (double)c0.y, (double)1.0E-4);
        Coordinate c1 = cs.getCoordinate(1);
        Assert.assertEquals((double)2.1, (double)c1.x, (double)1.0E-4);
        Assert.assertEquals((double)2.2, (double)c1.y, (double)1.0E-4);
    }

    @Test
    public void testGetCoordinateCopy() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.1, 1.2, 2.1, 2.2});
        Coordinate c0 = cs.getCoordinateCopy(0);
        Assert.assertEquals((double)1.1, (double)c0.x, (double)1.0E-4);
        Assert.assertEquals((double)1.2, (double)c0.y, (double)1.0E-4);
        Coordinate c1 = cs.getCoordinateCopy(1);
        Assert.assertEquals((double)2.1, (double)c1.x, (double)1.0E-4);
        Assert.assertEquals((double)2.2, (double)c1.y, (double)1.0E-4);
    }

    @Test
    public void testGetCoordinate_int_Coordinate() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.1, 1.2, 2.1, 2.2});
        Coordinate c = new Coordinate();
        cs.getCoordinate(0, c);
        Assert.assertEquals((double)1.1, (double)c.x, (double)1.0E-4);
        Assert.assertEquals((double)1.2, (double)c.y, (double)1.0E-4);
        cs.getCoordinate(1, c);
        Assert.assertEquals((double)2.1, (double)c.x, (double)1.0E-4);
        Assert.assertEquals((double)2.2, (double)c.y, (double)1.0E-4);
    }

    @Test
    public void testGetX() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.2, 3.4});
        Assert.assertEquals((double)1.2, (double)cs.getX(0), (double)1.0E-4);
    }

    @Test
    public void testGetY() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.2, 3.4});
        Assert.assertEquals((double)3.4, (double)cs.getY(0), (double)1.0E-4);
    }

    @Test
    public void testGetOrdinate() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.2, 3.4});
        Assert.assertEquals((double)1.2, (double)cs.getOrdinate(0, 0), (double)1.0E-4);
        Assert.assertEquals((double)3.4, (double)cs.getOrdinate(0, 1), (double)1.0E-4);
    }

    @Test
    public void testSize() {
        CoordinateSequence2D cs = new CoordinateSequence2D(42);
        Assert.assertEquals((long)42L, (long)cs.size());
        cs = new CoordinateSequence2D(new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0});
        Assert.assertEquals((long)3L, (long)cs.size());
    }

    @Test
    public void testSetOrdinate() {
        CoordinateSequence2D cs = new CoordinateSequence2D(2);
        cs.setOrdinate(0, 0, 1.1);
        cs.setOrdinate(0, 1, 1.2);
        cs.setOrdinate(1, 0, 2.1);
        cs.setOrdinate(1, 1, 2.2);
        Assert.assertEquals((double)1.1, (double)cs.getX(0), (double)1.0E-4);
        Assert.assertEquals((double)1.2, (double)cs.getY(0), (double)1.0E-4);
        Assert.assertEquals((double)2.1, (double)cs.getX(1), (double)1.0E-4);
        Assert.assertEquals((double)2.2, (double)cs.getY(1), (double)1.0E-4);
    }

    @Test
    public void testSetX() {
        CoordinateSequence2D cs = new CoordinateSequence2D(2);
        cs.setX(1, 42.0);
        Assert.assertEquals((double)42.0, (double)cs.getX(1), (double)1.0E-4);
    }

    @Test
    public void testSetY() {
        CoordinateSequence2D cs = new CoordinateSequence2D(2);
        cs.setY(1, 42.0);
        Assert.assertEquals((double)42.0, (double)cs.getY(1), (double)1.0E-4);
    }

    @Test
    public void testSetXY() {
        CoordinateSequence2D cs = new CoordinateSequence2D(2);
        cs.setXY(1, 42.0, -1.0);
        Assert.assertEquals((double)42.0, (double)cs.getX(1), (double)1.0E-4);
        Assert.assertEquals((double)-1.0, (double)cs.getY(1), (double)1.0E-4);
    }

    @Test
    public void testToCoordinateArray() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.1, 1.2, 2.1, 2.2, 3.1, 3.2});
        Coordinate[] coords = cs.toCoordinateArray();
        Assert.assertEquals((long)3L, (long)coords.length);
        for (int i = 0; i < coords.length; ++i) {
            double x = (double)i + 1.1;
            double y = (double)i + 1.2;
            Assert.assertEquals((double)x, (double)coords[i].x, (double)1.0E-4);
            Assert.assertEquals((double)y, (double)coords[i].y, (double)1.0E-4);
        }
    }

    @Test
    public void testExpandEnvelope() {
        Envelope env = new Envelope();
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{-5.0, 10.0, 5.0, -10.0});
        env = cs.expandEnvelope(env);
        Assert.assertEquals((double)-5.0, (double)env.getMinX(), (double)1.0E-4);
        Assert.assertEquals((double)-10.0, (double)env.getMinY(), (double)1.0E-4);
        Assert.assertEquals((double)5.0, (double)env.getMaxX(), (double)1.0E-4);
        Assert.assertEquals((double)10.0, (double)env.getMaxY(), (double)1.0E-4);
    }

    @Test
    public void testClone() {
        CoordinateSequence2D cs = new CoordinateSequence2D(new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0});
        CoordinateSequence2D copy = (CoordinateSequence2D)cs.clone();
        Assert.assertTrue((cs != copy ? 1 : 0) != 0);
        Assert.assertEquals((long)cs.size(), (long)copy.size());
        for (int i = 0; i < cs.size(); ++i) {
            Assert.assertEquals((double)cs.getX(i), (double)copy.getX(i), (double)1.0E-4);
            Assert.assertEquals((double)cs.getY(i), (double)copy.getY(i), (double)1.0E-4);
        }
    }
}

