/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.range;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RangeTest {
    private static final int BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean SINGLE_POINT = Boolean.getBoolean("JAI.Ext.SinglePoint");
    private static final Integer TEST_SELECTOR = Integer.getInteger("JAI.Ext.TestSelector", 0);
    private static byte[] arrayB;
    private static short[] arrayUS;
    private static short[] arrayS;
    private static int[] arrayI;
    private static float[] arrayF;
    private static double[] arrayD;
    private static long[] arrayL;
    private static Byte[] arrayBtest;
    private static Short[] arrayStest;
    private static Integer[] arrayItest;
    private static Float[] arrayFtest;
    private static Double[] arrayDtest;
    private static Range rangeB2bounds;
    private static Range rangeBpoint;
    private static Range rangeU2bounds;
    private static Range rangeUpoint;
    private static Range rangeS2bounds;
    private static Range rangeSpoint;
    private static Range rangeI2bounds;
    private static Range rangeIpoint;
    private static Range rangeF2bounds;
    private static Range rangeFpoint;
    private static Range rangeD2bounds;
    private static Range rangeDpoint;
    private static Range rangeL2bounds;
    private static Range rangeLpoint;

    @BeforeClass
    public static void initialSetup() {
        arrayB = new byte[]{0, 1, 5, 50, 100};
        arrayUS = new short[]{0, 1, 5, 50, 100};
        arrayS = new short[]{-10, 0, 5, 50, 100};
        arrayI = new int[]{-10, 0, 5, 50, 100};
        arrayF = new float[]{-10.0f, 0.0f, 5.0f, 50.0f, 100.0f};
        arrayD = new double[]{-10.0, 0.0, 5.0, 50.0, 100.0};
        arrayL = new long[]{-10L, 0L, 5L, 50L, 100L};
        rangeB2bounds = RangeFactory.create((byte)2, (boolean)true, (byte)60, (boolean)true);
        rangeBpoint = RangeFactory.create((byte)arrayB[2], (boolean)true, (byte)arrayB[2], (boolean)true);
        rangeU2bounds = RangeFactory.createU((short)2, (boolean)true, (short)60, (boolean)true);
        rangeUpoint = RangeFactory.createU((short)arrayUS[2], (boolean)true, (short)arrayUS[2], (boolean)true);
        rangeS2bounds = RangeFactory.create((short)1, (boolean)true, (short)60, (boolean)true);
        rangeSpoint = RangeFactory.create((short)arrayS[2], (boolean)true, (short)arrayS[2], (boolean)true);
        rangeI2bounds = RangeFactory.create((int)1, (boolean)true, (int)60, (boolean)true);
        rangeIpoint = RangeFactory.create((int)arrayI[2], (boolean)true, (int)arrayI[2], (boolean)true);
        rangeF2bounds = RangeFactory.create((float)0.5f, (boolean)true, (float)60.5f, (boolean)true, (boolean)false);
        rangeFpoint = RangeFactory.create((float)arrayF[2], (boolean)true, (float)arrayF[2], (boolean)true, (boolean)false);
        rangeD2bounds = RangeFactory.create((double)1.5, (boolean)true, (double)60.5, (boolean)true, (boolean)false);
        rangeDpoint = RangeFactory.create((double)arrayD[2], (boolean)true, (double)arrayD[2], (boolean)true, (boolean)false);
        rangeL2bounds = RangeFactory.create((long)1L, (boolean)true, (long)60L, (boolean)true);
        rangeLpoint = RangeFactory.create((long)arrayL[2], (boolean)true, (long)arrayL[2], (boolean)true);
        arrayBtest = new Byte[100];
        arrayStest = new Short[100];
        arrayItest = new Integer[100];
        arrayFtest = new Float[100];
        arrayDtest = new Double[100];
        for (int j = 0; j < 100; ++j) {
            double randomValue = Math.random();
            RangeTest.arrayBtest[j] = (byte)(randomValue * 255.0 + -128.0);
            RangeTest.arrayStest[j] = (short)(randomValue * 65535.0 + -32768.0);
            RangeTest.arrayItest[j] = (int)(randomValue * -1.0 + -2.147483648E9);
            RangeTest.arrayFtest[j] = Float.valueOf((float)(randomValue * 3.4028234663852886E38 + (double)1.4E-45f));
            RangeTest.arrayDtest[j] = randomValue * Double.MAX_VALUE + Double.MIN_VALUE;
        }
    }

    @Test
    public void testRange() {
        for (int i = 0; i < arrayB.length; ++i) {
            boolean check2pointByte = rangeB2bounds.contains(arrayB[i]);
            boolean check1pointByte = rangeBpoint.contains(arrayB[i]);
            boolean check2pointUshort = rangeU2bounds.contains(arrayUS[i]);
            boolean check1pointUshort = rangeUpoint.contains(arrayUS[i]);
            boolean check2pointShort = rangeS2bounds.contains(arrayS[i]);
            boolean check1pointShort = rangeSpoint.contains(arrayS[i]);
            boolean check2pointInt = rangeI2bounds.contains(arrayI[i]);
            boolean check1pointInt = rangeIpoint.contains(arrayI[i]);
            boolean check2pointFloat = rangeF2bounds.contains(arrayF[i]);
            boolean check1pointFloat = rangeFpoint.contains(arrayF[i]);
            boolean check2pointDouble = rangeD2bounds.contains(arrayD[i]);
            boolean check1pointDouble = rangeDpoint.contains(arrayD[i]);
            boolean check2pointLong = rangeL2bounds.contains(arrayL[i]);
            boolean check1pointLong = rangeLpoint.contains(arrayL[i]);
            if (i == 2) {
                Assert.assertTrue((boolean)check1pointByte);
                Assert.assertTrue((boolean)check2pointByte);
                Assert.assertTrue((boolean)check1pointUshort);
                Assert.assertTrue((boolean)check2pointUshort);
                Assert.assertTrue((boolean)check1pointShort);
                Assert.assertTrue((boolean)check2pointShort);
                Assert.assertTrue((boolean)check1pointInt);
                Assert.assertTrue((boolean)check2pointInt);
                Assert.assertTrue((boolean)check1pointFloat);
                Assert.assertTrue((boolean)check2pointFloat);
                Assert.assertTrue((boolean)check1pointDouble);
                Assert.assertTrue((boolean)check2pointDouble);
                Assert.assertTrue((boolean)check1pointLong);
                Assert.assertTrue((boolean)check2pointLong);
                continue;
            }
            if (i == 3) {
                Assert.assertFalse((boolean)check1pointByte);
                Assert.assertTrue((boolean)check2pointByte);
                Assert.assertFalse((boolean)check1pointUshort);
                Assert.assertTrue((boolean)check2pointUshort);
                Assert.assertFalse((boolean)check1pointShort);
                Assert.assertTrue((boolean)check2pointShort);
                Assert.assertFalse((boolean)check1pointInt);
                Assert.assertTrue((boolean)check2pointInt);
                Assert.assertFalse((boolean)check1pointFloat);
                Assert.assertTrue((boolean)check2pointFloat);
                Assert.assertFalse((boolean)check1pointDouble);
                Assert.assertTrue((boolean)check2pointDouble);
                Assert.assertFalse((boolean)check1pointLong);
                Assert.assertTrue((boolean)check2pointLong);
                continue;
            }
            Assert.assertFalse((boolean)check1pointByte);
            Assert.assertFalse((boolean)check2pointByte);
            Assert.assertFalse((boolean)check1pointUshort);
            Assert.assertFalse((boolean)check2pointUshort);
            Assert.assertFalse((boolean)check1pointShort);
            Assert.assertFalse((boolean)check2pointShort);
            Assert.assertFalse((boolean)check1pointInt);
            Assert.assertFalse((boolean)check2pointInt);
            Assert.assertFalse((boolean)check1pointFloat);
            Assert.assertFalse((boolean)check2pointFloat);
            Assert.assertFalse((boolean)check1pointDouble);
            Assert.assertFalse((boolean)check2pointDouble);
            Assert.assertFalse((boolean)check1pointLong);
            Assert.assertFalse((boolean)check2pointLong);
        }
    }

    @Test
    public void testRangeTimeByte1or2Points() {
        block15: {
            block14: {
                if (SINGLE_POINT) break block14;
                switch (TEST_SELECTOR) {
                    case 0: {
                        this.testRangeTimeByte(rangeB2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 2: {
                        this.testRangeTimeShort(rangeS2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 3: {
                        this.testRangeTimeInteger(rangeI2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 4: {
                        this.testRangeTimeFloat(rangeF2bounds, SINGLE_POINT);
                        break block15;
                    }
                    case 5: {
                        this.testRangeTimeDouble(rangeD2bounds, SINGLE_POINT);
                        break block15;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong data type");
                    }
                }
            }
            switch (TEST_SELECTOR) {
                case 0: {
                    this.testRangeTimeByte(rangeBpoint, SINGLE_POINT);
                    break;
                }
                case 2: {
                    this.testRangeTimeShort(rangeSpoint, SINGLE_POINT);
                    break;
                }
                case 3: {
                    this.testRangeTimeInteger(rangeIpoint, SINGLE_POINT);
                    break;
                }
                case 4: {
                    this.testRangeTimeFloat(rangeFpoint, SINGLE_POINT);
                    break;
                }
                case 5: {
                    this.testRangeTimeDouble(rangeDpoint, SINGLE_POINT);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data type");
                }
            }
        }
    }

    public void testRangeTimeByte(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayBtest.length; ++j) {
                testRange.contains(arrayBtest[j].byteValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeShort(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayStest.length; ++j) {
                testRange.contains(arrayStest[j].shortValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Short data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeInteger(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayItest.length; ++j) {
                testRange.contains(arrayItest[j].intValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Integer data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeFloat(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayFtest.length; ++j) {
                testRange.contains(arrayFtest[j].floatValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Float data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    public void testRangeTimeDouble(Range testRange, boolean isPoint) {
        int totalCycles = NOT_BENCHMARK_ITERATION + BENCHMARK_ITERATION;
        long mean = 0L;
        for (int i = 0; i < totalCycles; ++i) {
            long start = System.nanoTime();
            for (int j = 0; j < arrayDtest.length; ++j) {
                testRange.contains(arrayDtest[j].doubleValue());
            }
            long end = System.nanoTime() - start;
            if (i <= NOT_BENCHMARK_ITERATION - 1) continue;
            if (i == NOT_BENCHMARK_ITERATION) {
                mean = end;
                continue;
            }
            mean += end;
        }
        String description = "";
        if (isPoint) {
            description = description + " a single point";
        }
        double meanValue = mean / (long)BENCHMARK_ITERATION;
        System.out.println("Double data");
        System.out.println("\nMean value for" + description + " Range : " + meanValue + " nsec.");
    }

    @Test
    public void testIntersectionValidRange() {
        Range doubleRange = RangeFactory.create((int)-9999, (int)-9999);
        Range byteRange = RangeFactory.create((int)0, (int)255);
        Range intersection = byteRange.intersection(doubleRange);
        Assert.assertNull((Object)intersection);
    }

    @Test
    public void testIntersectionOutsideIntRangeByte() {
        Range doubleRange = RangeFactory.create((double)-1.0E33, (double)-1.0E33);
        Range byteRange = RangeFactory.create((byte)0, (byte)-1);
        Range intersection = byteRange.intersection(doubleRange);
        Assert.assertNull((Object)intersection);
    }

    @Test
    public void testIntersectionOutsideIntRangeShort() {
        Range doubleRange = RangeFactory.create((double)-1.0E33, (double)-1.0E33);
        Range byteRange = RangeFactory.create((short)0, (short)255);
        Range intersection = byteRange.intersection(doubleRange);
        Assert.assertNull((Object)intersection);
    }

    @Test
    public void testConvert() {
        this.checkRangeConversion(RangeFactory.create((byte)-1, (byte)-1));
        this.checkRangeConversion(RangeFactory.create((double)255.0, (double)255.0));
        this.checkRangeConversion(RangeFactory.create((float)255.0f, (float)255.0f));
        this.checkRangeConversion(RangeFactory.create((int)255, (int)255));
        this.checkRangeConversion(RangeFactory.create((short)255, (short)255));
        this.checkRangeConversion(RangeFactory.createU((short)255, (short)255));
    }

    private void checkRangeConversion(Range range) {
        this.checkRangeConversion(range, 0);
        this.checkRangeConversion(range, 5);
        this.checkRangeConversion(range, 4);
        this.checkRangeConversion(range, 3);
        this.checkRangeConversion(range, 2);
        this.checkRangeConversion(range, 1);
    }

    private void checkRangeConversion(Range range, int targetType) {
        Range converted = RangeFactory.convert((Range)range, (int)targetType);
        Assert.assertEquals((long)converted.getMin().intValue(), (long)255L);
        Assert.assertEquals((long)converted.getMax().intValue(), (long)255L);
        Assert.assertTrue((boolean)converted.isMinIncluded);
        Assert.assertTrue((boolean)converted.isMaxIncluded);
        Assert.assertEquals((long)targetType, (long)converted.getDataType().getDataType());
        if (range.getDataType().getDataType() == targetType) {
            Assert.assertSame((Object)range, (Object)converted);
        } else {
            Assert.assertNotSame((Object)range, (Object)converted);
        }
    }

    @Test
    public void testConvertFloatNaN() {
        Range nanDouble = RangeFactory.create((double)Double.NaN, (double)Double.NaN);
        Range nanFloat = RangeFactory.convert((Range)nanDouble, (int)4);
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), (Object)nanFloat.getMin());
        Assert.assertEquals((Object)Float.valueOf(Float.NaN), (Object)nanFloat.getMax());
    }

    @Test
    public void testConvertDoubleNaN() {
        Range nanFloat = RangeFactory.create((float)Float.NaN, (float)Float.NaN);
        Range nanDouble = RangeFactory.convert((Range)nanFloat, (int)5);
        Assert.assertEquals((Object)Double.NaN, (Object)nanDouble.getMin());
        Assert.assertEquals((Object)Double.NaN, (Object)nanDouble.getMax());
    }
}

