/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.translate;

import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.translate.TranslateDescriptor;
import java.awt.image.RenderedImage;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Test;

public class TranslateTest
extends TestBase {
    @Test
    public void testTranslation() {
        float xTrans = -3.0f;
        float yTrans = -3.0f;
        int dataType = 0;
        this.testType(xTrans, yTrans, dataType);
        dataType = 1;
        this.testType(xTrans, yTrans, dataType);
        dataType = 2;
        this.testType(xTrans, yTrans, dataType);
        dataType = 3;
        this.testType(xTrans, yTrans, dataType);
        dataType = 4;
        this.testType(xTrans, yTrans, dataType);
        dataType = 5;
        this.testType(xTrans, yTrans, dataType);
    }

    private void testType(float xTrans, float yTrans, int dataType) {
        RenderedImage testIMG = null;
        switch (dataType) {
            case 0: {
                byte imageValueB = 127;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueB, (boolean)false);
                break;
            }
            case 1: {
                short imageValueUS = -36;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueUS, (boolean)false);
                break;
            }
            case 2: {
                short imageValueS = -300;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueS, (boolean)false);
                break;
            }
            case 3: {
                int imageValueI = 0x7FFFFFFE;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueI, (boolean)false);
                break;
            }
            case 4: {
                float imageValueF = 50.1f;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(imageValueF), (boolean)false);
                break;
            }
            case 5: {
                double imageValueD = Double.MAX_VALUE;
                testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueD, (boolean)false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
        RenderedOp translatedIMG = TranslateDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), null, null);
        translatedIMG.getTiles();
        double actualX = translatedIMG.getMinX();
        double actualY = translatedIMG.getMinY();
        double expectedX = (float)testIMG.getMinX() + xTrans;
        double expectedY = (float)testIMG.getMinY() + yTrans;
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        if (translatedIMG instanceof RenderedOp) {
            translatedIMG.dispose();
        }
    }

    @Test
    public void testException() {
        float xTrans = -3.2f;
        float yTrans = 0.0f;
        int dataType = 0;
        byte imageValueB = 127;
        RenderedImage testIMG = TranslateTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValueB, (boolean)false);
        try {
            RenderedOp renderedOp = TranslateDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), null, null);
        }
        catch (Exception e) {
            String exception = "Translate Operation can be used only for integral displacements. Ifa layout is present, the translate operation cannot deal with";
            Assert.assertEquals((Object)exception, (Object)e.getMessage());
        }
    }
}

