/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.translate;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.translate.TranslateDescriptor;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.junit.BeforeClass;
import org.junit.Test;

public class ComparisonTest {
    private static final Integer BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.BenchmarkCycles", 1);
    private static final int NOT_BENCHMARK_ITERATION = Integer.getInteger("JAI.Ext.NotBenchmarkCycles", 0);
    private static final boolean OLD_DESCRIPTOR = Boolean.getBoolean("JAI.Ext.OldDescriptor");
    private static RenderedImage image;
    private static float transX;
    private static float transY;
    private static InterpolationNearest interpNearOld;

    @BeforeClass
    public static void initialSetup() throws FileNotFoundException, IOException {
        image = ComparisonTest.getSyntheticImage((byte)100);
        interpNearOld = new InterpolationNearest();
        if (OLD_DESCRIPTOR) {
            JAIExt.registerJAIDescriptor((String)"Translate");
        }
    }

    @Test
    public void testNewTranslationDescriptor() {
        if (!OLD_DESCRIPTOR) {
            this.testTranslation(null);
        }
    }

    @Test
    public void testOldTranslationDescriptor() {
        if (OLD_DESCRIPTOR) {
            this.testTranslation((Interpolation)interpNearOld);
        }
    }

    public void testTranslation(Interpolation interp) {
        boolean old;
        String description = "";
        boolean bl = old = interp != null;
        if (old) {
            description = "Old Translate";
            System.setProperty("com.sun.media.jai.disableMediaLib", "false");
        } else {
            description = "New Translate";
            System.setProperty("com.sun.media.jai.disableMediaLib", "true");
        }
        int totalCycles = BENCHMARK_ITERATION + NOT_BENCHMARK_ITERATION;
        RenderedOp imageTranslate = null;
        long mean = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (int i = 0; i < totalCycles; ++i) {
            imageTranslate = old ? javax.media.jai.operator.TranslateDescriptor.create((RenderedImage)image, (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), (Interpolation)interp, null) : TranslateDescriptor.create((RenderedImage)image, (Float)Float.valueOf(transX), (Float)Float.valueOf(transY), null, null);
            long start = System.nanoTime();
            imageTranslate.getTiles();
            long end = System.nanoTime() - start;
            if (i > NOT_BENCHMARK_ITERATION - 1) {
                mean = i == NOT_BENCHMARK_ITERATION ? end : (mean += end);
                if (end > max) {
                    max = end;
                }
                if (end < min) {
                    min = end;
                }
            }
            JAI.getDefaultInstance().getTileCache().flush();
        }
        double meanValue = (double)(mean / (long)BENCHMARK_ITERATION.intValue()) * 1.0E-6;
        double maxD = (double)max * 1.0E-6;
        double minD = (double)min * 1.0E-6;
        System.out.println("\nMean value for " + description + "Descriptor : " + meanValue + " msec.");
        System.out.println("Maximum value for " + description + "Descriptor : " + maxD + " msec.");
        System.out.println("Minimum value for " + description + "Descriptor : " + minD + " msec.");
        if (imageTranslate instanceof RenderedOp) {
            imageTranslate.dispose();
        }
    }

    public static RenderedImage getSyntheticImage(byte value) {
        float width = 256.0f;
        float height = 256.0f;
        ParameterBlock pb = new ParameterBlock();
        Byte[] array = new Byte[]{value, (byte)(value + 1), (byte)(value + 2)};
        pb.add(256.0f);
        pb.add(256.0f);
        pb.add(array);
        return JAI.create((String)"constant", (ParameterBlock)pb);
    }
}

