/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.threshold;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.threshold.ThresholdDescriptor;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ThresholdTest
extends TestBase {
    private Logger logger = Logger.getLogger(ThresholdTest.class.getName());
    private static final double TOLERANCE = 0.1;
    private static RenderedImage[] testImages;
    private static Range noDataByte;
    private static Range noDataUShort;
    private static Range noDataShort;
    private static Range noDataInt;
    private static Range noDataFloat;
    private static Range noDataDouble;
    private static ROI roiObject;
    private static double destNoData;

    @BeforeClass
    public static void initialSetup() {
        byte noDataB = 50;
        short noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        testImages = new RenderedImage[6];
        IMAGE_FILLER = true;
        ThresholdTest.testImages[0] = ThresholdTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataB, (boolean)false, (int)3, (Number)255);
        ThresholdTest.testImages[1] = ThresholdTest.createTestImage((int)1, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)3);
        ThresholdTest.testImages[2] = ThresholdTest.createTestImage((int)2, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataS, (boolean)false, (int)3);
        ThresholdTest.testImages[3] = ThresholdTest.createTestImage((int)3, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataI, (boolean)false, (int)3);
        ThresholdTest.testImages[4] = ThresholdTest.createTestImage((int)4, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)Float.valueOf(noDataF), (boolean)false, (int)3);
        ThresholdTest.testImages[5] = ThresholdTest.createTestImage((int)5, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)noDataD, (boolean)false, (int)3);
        IMAGE_FILLER = false;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        noDataByte = RangeFactory.create((byte)noDataB, (boolean)minIncluded, (byte)noDataB, (boolean)maxIncluded);
        noDataUShort = RangeFactory.createU((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataShort = RangeFactory.create((short)noDataS, (boolean)minIncluded, (short)noDataS, (boolean)maxIncluded);
        noDataInt = RangeFactory.create((int)noDataI, (boolean)minIncluded, (int)noDataI, (boolean)maxIncluded);
        noDataFloat = RangeFactory.create((float)noDataF, (boolean)minIncluded, (float)noDataF, (boolean)maxIncluded, (boolean)true);
        noDataDouble = RangeFactory.create((double)noDataD, (boolean)minIncluded, (double)noDataD, (boolean)maxIncluded, (boolean)true);
        Rectangle roiBounds = new Rectangle(5, 5, DEFAULT_WIDTH / 4, DEFAULT_HEIGHT / 4);
        roiObject = new ROIShape((Shape)roiBounds);
        destNoData = 100.0;
    }

    @Test
    public void test() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        Range noData = null;
        ROI roi = null;
        double[] low = new double[]{0.0, 20.0, 0.0};
        double[] high = new double[]{10.0, 80.0, 100.0};
        double[] constant = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[]{ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[1]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[2]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[3]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[4]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[5])};
        this.check(testImages[0], threshold[0], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[1], threshold[1], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[2], threshold[2], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[3], threshold[3], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[4], threshold[4], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[5], threshold[5], low, high, constant, roiUsed, roi, nodataUsed, noDataDouble);
        if (INTERACTIVE) {
            RenderedImageBrowser.showChain((RenderedImage)threshold[1].createInstance(), (boolean)false, (boolean)false);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int i = 0; i < 6; ++i) {
            threshold[i].dispose();
        }
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean nodataUsed = true;
        ROI roi = null;
        double[] low = new double[]{0.0, 20.0, 0.0};
        double[] high = new double[]{10.0, 80.0, 100.0};
        double[] constant = new double[]{100.0, 100.0, 100.0};
        RenderedOp[] threshold = new RenderedOp[]{ThresholdDescriptor.create((Range)noDataByte, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]), ThresholdDescriptor.create((Range)noDataUShort, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[1]), ThresholdDescriptor.create((Range)noDataShort, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[2]), ThresholdDescriptor.create((Range)noDataInt, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[3]), ThresholdDescriptor.create((Range)noDataFloat, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[4]), ThresholdDescriptor.create((Range)noDataDouble, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[5])};
        this.check(testImages[0], threshold[0], low, high, constant, roiUsed, roi, nodataUsed, noDataByte);
        this.check(testImages[1], threshold[1], low, high, constant, roiUsed, roi, nodataUsed, noDataUShort);
        this.check(testImages[2], threshold[2], low, high, constant, roiUsed, roi, nodataUsed, noDataShort);
        this.check(testImages[3], threshold[3], low, high, constant, roiUsed, roi, nodataUsed, noDataInt);
        this.check(testImages[4], threshold[4], low, high, constant, roiUsed, roi, nodataUsed, noDataFloat);
        this.check(testImages[5], threshold[5], low, high, constant, roiUsed, roi, nodataUsed, noDataDouble);
        for (int i = 0; i < 6; ++i) {
            threshold[i].dispose();
        }
    }

    @Test
    public void testROI() {
        boolean roiUsed = true;
        boolean nodataUsed = false;
        ROI roi = roiObject;
        Range noData = null;
        double[] low = new double[]{0.0, 20.0, 0.0};
        double[] high = new double[]{10.0, 80.0, 100.0};
        double[] constant = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[]{ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]), ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[1]), ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[2]), ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[3]), ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[4]), ThresholdDescriptor.create(noData, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[5])};
        this.check(testImages[0], threshold[0], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[1], threshold[1], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[2], threshold[2], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[3], threshold[3], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[4], threshold[4], low, high, constant, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[5], threshold[5], low, high, constant, roiUsed, roi, nodataUsed, noData);
        for (int i = 0; i < 6; ++i) {
            threshold[i].dispose();
        }
    }

    @Test
    public void testROINoData() {
        boolean roiUsed = true;
        boolean nodataUsed = true;
        ROI roi = roiObject;
        double[] low = new double[]{0.0, 20.0, 0.0};
        double[] high = new double[]{10.0, 80.0, 100.0};
        double[] constant = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[]{ThresholdDescriptor.create((Range)noDataByte, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]), ThresholdDescriptor.create((Range)noDataUShort, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[1]), ThresholdDescriptor.create((Range)noDataShort, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[2]), ThresholdDescriptor.create((Range)noDataInt, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[3]), ThresholdDescriptor.create((Range)noDataFloat, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[4]), ThresholdDescriptor.create((Range)noDataDouble, (double)destNoData, (ROI)roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[5])};
        this.check(testImages[0], threshold[0], low, high, constant, roiUsed, roi, nodataUsed, noDataByte);
        this.check(testImages[1], threshold[1], low, high, constant, roiUsed, roi, nodataUsed, noDataUShort);
        this.check(testImages[2], threshold[2], low, high, constant, roiUsed, roi, nodataUsed, noDataShort);
        this.check(testImages[3], threshold[3], low, high, constant, roiUsed, roi, nodataUsed, noDataInt);
        this.check(testImages[4], threshold[4], low, high, constant, roiUsed, roi, nodataUsed, noDataFloat);
        this.check(testImages[5], threshold[5], low, high, constant, roiUsed, roi, nodataUsed, noDataDouble);
        for (int i = 0; i < 6; ++i) {
            threshold[i].dispose();
        }
    }

    @Test
    public void testParam() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        ROI roi = null;
        Range noData = null;
        double[] low = new double[]{0.0};
        double[] high = new double[]{10.0};
        double[] constant = new double[]{255.0};
        double[] lowC = new double[]{0.0, 0.0, 0.0};
        double[] highC = new double[]{10.0, 10.0, 10.0};
        double[] constantC = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[]{ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[1]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[2]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[3]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[4]), ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[5])};
        this.check(testImages[0], threshold[0], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[1], threshold[1], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[2], threshold[2], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[3], threshold[3], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[4], threshold[4], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        this.check(testImages[5], threshold[5], lowC, highC, constantC, roiUsed, roi, nodataUsed, noData);
        for (int i = 0; i < 6; ++i) {
            threshold[i].dispose();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void textExceptionParam() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        ROI roi = null;
        Range noData = null;
        double[] low = new double[]{10.0, 20.0};
        double[] high = new double[]{10.0};
        double[] constant = new double[]{255.0};
        double[] lowC = new double[]{0.0, 0.0, 0.0};
        double[] highC = new double[]{10.0, 10.0, 10.0};
        double[] constantC = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[6];
        threshold[0] = ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void textExceptionParam2() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        ROI roi = null;
        Range noData = null;
        double[] low = new double[]{};
        double[] high = new double[]{10.0};
        double[] constant = new double[]{255.0};
        double[] lowC = new double[]{0.0, 0.0, 0.0};
        double[] highC = new double[]{10.0, 10.0, 10.0};
        double[] constantC = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[6];
        threshold[0] = ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void textExceptionParam3() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        ROI roi = null;
        Range noData = null;
        double[] low = new double[]{50.0};
        double[] high = new double[]{20.0};
        double[] constant = new double[]{255.0};
        double[] lowC = new double[]{0.0, 0.0, 0.0};
        double[] highC = new double[]{10.0, 10.0, 10.0};
        double[] constantC = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[6];
        threshold[0] = ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, (RenderedImage)testImages[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void textExceptionParam4() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        ROI roi = null;
        Range noData = null;
        double[] low = new double[]{50.0};
        double[] high = new double[]{20.0};
        double[] constant = new double[]{255.0};
        double[] lowC = new double[]{0.0, 0.0, 0.0};
        double[] highC = new double[]{10.0, 10.0, 10.0};
        double[] constantC = new double[]{255.0, 255.0, 255.0};
        RenderedOp[] threshold = new RenderedOp[6];
        threshold[0] = ThresholdDescriptor.create(noData, (double)destNoData, roi, (double[])low, (double[])high, (double[])constant, null, null);
    }

    private void check(RenderedImage src, RenderedOp dest, double[] low, double[] high, double[] con, boolean roiUsed, ROI roi, boolean nodataUsed, Range noData) {
        int tileWidth = dest.getTileWidth();
        int tileHeight = dest.getTileHeight();
        int minTileX = dest.getMinTileX();
        int minTileY = dest.getMinTileY();
        int numXTiles = dest.getNumXTiles();
        int numYTiles = dest.getNumYTiles();
        int maxTileX = minTileX + numXTiles;
        int maxTileY = minTileY + numYTiles;
        Assert.assertEquals((long)dest.getWidth(), (long)src.getWidth());
        Assert.assertEquals((long)dest.getHeight(), (long)src.getHeight());
        Assert.assertEquals((long)dest.getMinX(), (long)src.getMinX());
        Assert.assertEquals((long)dest.getMinY(), (long)src.getMinY());
        Assert.assertEquals((long)minTileX, (long)src.getMinTileX());
        Assert.assertEquals((long)minTileY, (long)src.getMinTileY());
        Assert.assertEquals((long)numXTiles, (long)src.getNumXTiles());
        Assert.assertEquals((long)numYTiles, (long)src.getNumYTiles());
        Assert.assertEquals((long)tileWidth, (long)src.getTileWidth());
        Assert.assertEquals((long)tileHeight, (long)src.getTileHeight());
        int srcBands = src.getSampleModel().getNumBands();
        int dstBands = dest.getNumBands();
        Assert.assertEquals((long)srcBands, (long)dstBands);
        boolean valid = true;
        for (int tileX = minTileX; tileX < maxTileX; ++tileX) {
            for (int tileY = minTileY; tileY < maxTileY; ++tileY) {
                Raster tile = dest.getTile(tileX, tileY);
                Raster srcTile = src.getTile(tileX, tileY);
                int minX = tile.getMinX();
                int minY = tile.getMinY();
                int maxX = minX + tileWidth - 1;
                int maxY = minY + tileHeight - 1;
                int minXsrc = srcTile.getMinX();
                int minYsrc = srcTile.getMinY();
                int xsrc = minXsrc;
                for (int x = minX; x <= maxX; ++x) {
                    int ysrc = minYsrc;
                    for (int y = minY; y <= maxY; ++y) {
                        int b;
                        boolean isValidRoi;
                        boolean bl = isValidRoi = !roiUsed || roiUsed && roi.contains(x, y);
                        if (isValidRoi) {
                            for (b = 0; b < dstBands; ++b) {
                                double samplesource = srcTile.getSampleDouble(xsrc, ysrc, b);
                                double result = tile.getSampleDouble(x, y, b);
                                if (nodataUsed && noData.contains(samplesource)) {
                                    Assert.assertEquals((double)result, (double)destNoData, (double)0.1);
                                } else if (samplesource >= low[b] && samplesource <= high[b] && result != con[b]) {
                                    valid = false;
                                }
                                this.logger.log(Level.FINE, "srcsample: " + samplesource + " dstsample: " + tile.getSampleDouble(x, y, b) + " low: " + low[b] + " high: " + high[b] + " constant: " + con[b]);
                            }
                        } else {
                            for (b = 0; b < dstBands; ++b) {
                                Assert.assertEquals((double)tile.getSampleDouble(x, y, b), (double)destNoData, (double)0.1);
                            }
                        }
                        ++ysrc;
                    }
                    ++xsrc;
                }
            }
        }
    }
}

