/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.threshold;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class ThresholdOpImage
extends PointOpImage {
    private final double[] low;
    private final double[] high;
    private final double[] constant;
    ColorModel colorModel;
    private Range noData;
    private final boolean hasROI;
    private Rectangle roiBounds;
    private final boolean hasNoData;
    private byte destNoDataByte;
    private short destNoDataShort;
    private int destNoDataInt;
    private float destNoDataFloat;
    private double destNoDataDouble;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    private ROI roi;

    public ThresholdOpImage(RenderedImage source, Map config, Range noData, ROI roi, double destinationNoData, ImageLayout layout, double[] low, double[] high, double[] constant) {
        super(source, layout, config, true);
        this.permitInPlaceOperation();
        int numBands = source.getSampleModel().getNumBands();
        if (low.length == 1 && high.length == 1 && constant.length == 1) {
            this.low = new double[numBands];
            this.high = new double[numBands];
            this.constant = new double[numBands];
            for (int i = 0; i < numBands; ++i) {
                this.low[i] = low[0];
                this.high[i] = high[0];
                this.constant[i] = constant[0];
            }
        } else {
            this.low = (double[])low.clone();
            this.high = (double[])high.clone();
            this.constant = (double[])constant.clone();
        }
        this.colorModel = source.getColorModel();
        int dataType = source.getSampleModel().getDataType();
        switch (dataType) {
            case 0: {
                this.destNoDataByte = ImageUtil.clampRoundByte((double)destinationNoData);
                break;
            }
            case 1: 
            case 2: {
                this.destNoDataShort = ImageUtil.clampRoundShort((double)destinationNoData);
                break;
            }
            case 3: {
                this.destNoDataInt = ImageUtil.clampRoundInt((double)destinationNoData);
                break;
            }
            case 4: {
                this.destNoDataFloat = ImageUtil.clampFloat((double)destinationNoData);
                break;
            }
            case 5: {
                this.destNoDataDouble = destinationNoData;
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong image data type");
            }
        }
        if (roi != null) {
            this.hasROI = true;
            this.roi = roi;
            this.roiBounds = roi.getBounds();
        } else {
            this.hasROI = false;
            this.roi = null;
            this.roiBounds = null;
        }
        if (noData != null) {
            this.hasNoData = true;
            this.noData = noData;
        } else {
            this.hasNoData = false;
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        int destType = dest.getTransferType();
        ROI roiTile = null;
        boolean roiContainsTile = false;
        boolean roiDisjointTile = false;
        if (this.hasROI) {
            Rectangle srcRectExpanded = this.mapDestRect(destRect, 0);
            srcRectExpanded.setRect(srcRectExpanded.getMinX() - 1.0, srcRectExpanded.getMinY() - 1.0, srcRectExpanded.getWidth() + 2.0, srcRectExpanded.getHeight() + 2.0);
            roiTile = this.roi.intersect((ROI)new ROIShape((Shape)srcRectExpanded));
            if (!this.roiBounds.intersects(srcRectExpanded)) {
                roiDisjointTile = true;
            } else {
                roiContainsTile = roiTile.contains(srcRectExpanded);
                if (!roiContainsTile && !roiTile.intersects(srcRectExpanded)) {
                    roiDisjointTile = true;
                }
            }
        }
        if (!this.hasROI || !roiDisjointTile) {
            RasterFormatTag[] formatTags = this.getFormatTags();
            Rectangle srcRect = this.mapDestRect(destRect, 0);
            RasterAccessor src = new RasterAccessor(sources[0], srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
            RasterAccessor dst = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
            switch (dst.getDataType()) {
                case 0: {
                    this.byteLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                case 1: {
                    this.ushortLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                case 2: {
                    this.shortLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                case 3: {
                    this.intLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                case 4: {
                    this.floatLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                case 5: {
                    this.doubleLoop(src, dst, roiTile, roiContainsTile);
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong image data type");
                }
            }
            dst.copyDataToRaster();
        } else {
            int numBands = this.getSampleModel().getNumBands();
            double[] background = new double[numBands];
            switch (destType) {
                case 0: {
                    Arrays.fill(background, (double)this.destNoDataByte);
                    break;
                }
                case 1: 
                case 2: {
                    Arrays.fill(background, (double)this.destNoDataShort);
                    break;
                }
                case 3: {
                    Arrays.fill(background, (double)this.destNoDataInt);
                    break;
                }
                case 4: {
                    Arrays.fill(background, (double)this.destNoDataFloat);
                    break;
                }
                case 5: {
                    Arrays.fill(background, this.destNoDataDouble);
                    break;
                }
                default: {
                    throw new RuntimeException("Wrong image data type");
                }
            }
            ImageUtil.fillBackground((WritableRaster)dest, (Rectangle)destRect, (double[])background);
        }
    }

    private void byteLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        byte[][] srcData = src.getByteDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        byte[][] dstData = dst.getByteDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        byte flo = (byte)lo;
                        byte fhi = (byte)hi;
                        byte fco = (byte)co;
                        byte sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            byte flo = (byte)lo;
                            byte fhi = (byte)hi;
                            byte fco = (byte)co;
                            byte sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        byte sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            byte flo = (byte)lo;
                            byte fhi = (byte)hi;
                            byte fco = (byte)co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            byte sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                byte flo = (byte)lo;
                                byte fhi = (byte)hi;
                                byte fco = (byte)co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataByte;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void ushortLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        short flo = (short)lo;
                        short fhi = (short)hi;
                        short fco = (short)co;
                        short sample = ImageUtil.clampRoundUShort((float)srcData[b][srcPixelOffset + srcBandOffsets[b]]);
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            short flo = (short)lo;
                            short fhi = (short)hi;
                            short fco = (short)co;
                            short sample = ImageUtil.clampRoundUShort((float)srcData[b][srcPixelOffset + srcBandOffsets[b]]);
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        short sample = ImageUtil.clampRoundUShort((float)srcData[b][srcPixelOffset + srcBandOffsets[b]]);
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            short flo = (short)lo;
                            short fhi = (short)hi;
                            short fco = (short)co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            short sample = ImageUtil.clampRoundUShort((float)srcData[b][srcPixelOffset + srcBandOffsets[b]]);
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                short flo = (short)lo;
                                short fhi = (short)hi;
                                short fco = (short)co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void shortLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[][] srcData = src.getShortDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[][] dstData = dst.getShortDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        short flo = (short)lo;
                        short fhi = (short)hi;
                        short fco = (short)co;
                        short sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            short flo = (short)lo;
                            short fhi = (short)hi;
                            short fco = (short)co;
                            short sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        short sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            short flo = (short)lo;
                            short fhi = (short)hi;
                            short fco = (short)co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            short sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                short flo = (short)lo;
                                short fhi = (short)hi;
                                short fco = (short)co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataShort;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void intLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        int[][] srcData = src.getIntDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        int[][] dstData = dst.getIntDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        int flo = (int)lo;
                        int fhi = (int)hi;
                        int fco = (int)co;
                        int sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            int flo = (int)lo;
                            int fhi = (int)hi;
                            int fco = (int)co;
                            int sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        int sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            int flo = (int)lo;
                            int fhi = (int)hi;
                            int fco = (int)co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            int sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                int flo = (int)lo;
                                int fhi = (int)hi;
                                int fco = (int)co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataInt;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void floatLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        float[][] srcData = src.getFloatDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        float[][] dstData = dst.getFloatDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        float flo = (float)lo;
                        float fhi = (float)hi;
                        float fco = (float)co;
                        float sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            float flo = (float)lo;
                            float fhi = (float)hi;
                            float fco = (float)co;
                            float sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        float sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            float flo = (float)lo;
                            float fhi = (float)hi;
                            float fco = (float)co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            float sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                float flo = (float)lo;
                                float fhi = (float)hi;
                                float fco = (float)co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataFloat;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }

    private void doubleLoop(RasterAccessor src, RasterAccessor dst, ROI roiTile, boolean roiContainsTile) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        double[][] srcData = src.getDoubleDataArrays();
        int dstWidth = dst.getWidth();
        int dstHeight = dst.getHeight();
        int dstBands = dst.getNumBands();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        double[][] dstData = dst.getDoubleDataArrays();
        int srcLineOffset = 0;
        int dstLineOffset = 0;
        int x0 = 0;
        int y0 = 0;
        int srcX = src.getX();
        int srcY = src.getY();
        if (this.caseA || this.caseB && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double lo = this.low[b];
                        double hi = this.high[b];
                        double co = this.constant[b];
                        double flo = lo;
                        double fhi = hi;
                        double fco = co;
                        double sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseB) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            double flo = lo;
                            double fhi = hi;
                            double fco = co;
                            double sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample >= flo && sample <= fhi ? fco : sample;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else if (this.caseC || this.hasROI && this.hasNoData && roiContainsTile) {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    for (int b = 0; b < dstBands; ++b) {
                        double sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                        if (!this.noData.contains(sample)) {
                            double lo = this.low[b];
                            double hi = this.high[b];
                            double co = this.constant[b];
                            double flo = lo;
                            double fhi = hi;
                            double fco = co;
                            if (sample >= flo && sample <= fhi) {
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                            continue;
                        }
                        dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        } else {
            for (int h = 0; h < dstHeight; ++h) {
                int srcPixelOffset = srcLineOffset;
                int dstPixelOffset = dstLineOffset;
                for (int w = 0; w < dstWidth; ++w) {
                    int b;
                    x0 = srcX + w;
                    y0 = srcY + h;
                    if (!this.roiBounds.contains(x0, y0)) {
                        for (b = 0; b < dstBands; ++b) {
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                        }
                    } else {
                        for (b = 0; b < dstBands; ++b) {
                            double sample = srcData[b][srcPixelOffset + srcBandOffsets[b]];
                            if (!this.noData.contains(sample)) {
                                double lo = this.low[b];
                                double hi = this.high[b];
                                double co = this.constant[b];
                                double flo = lo;
                                double fhi = hi;
                                double fco = co;
                                if (sample >= flo && sample <= fhi) {
                                    dstData[b][dstPixelOffset + dstBandOffsets[b]] = fco;
                                    continue;
                                }
                                dstData[b][dstPixelOffset + dstBandOffsets[b]] = sample;
                                continue;
                            }
                            dstData[b][dstPixelOffset + dstBandOffsets[b]] = this.destNoDataDouble;
                        }
                    }
                    srcPixelOffset += srcPixelStride;
                    dstPixelOffset += dstPixelStride;
                }
                srcLineOffset += srcLineStride;
                dstLineOffset += dstLineStride;
            }
        }
    }
}

