/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.stats.MeanSum;
import it.geosolutions.jaiext.stats.Statistics;
import it.geosolutions.jaiext.stats.StatsFactory;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class StatisticsTest {
    private static final int ARRAY_DIMENSIONS = 100;
    private static final double TOLERANCE = 0.1;
    private static double[] testArray;
    private static Statistics meanObj;
    private static Statistics sumObj;
    private static Statistics maxObj;
    private static Statistics minObj;
    private static Statistics extremaObj;
    private static Statistics varianceObj;
    private static Statistics devstdObj;
    private static Statistics histogramObj;
    private static Statistics modeObj;
    private static Statistics medianObj;
    private static double minBound;
    private static double maxBound;
    private static double binInterval;
    private static int numBins;
    private static Range interval;

    @BeforeClass
    public static void initialSetup() {
        testArray = new double[100];
        minBound = -3.0;
        maxBound = 3.0;
        numBins = 20;
        binInterval = (maxBound - minBound) / (double)numBins;
        interval = RangeFactory.create((double)minBound, (boolean)true, (double)maxBound, (boolean)false, (boolean)false);
        for (int i = 0; i < 100; ++i) {
            StatisticsTest.testArray[i] = Math.random() * 2.0 + 2.0;
        }
        meanObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)0);
        sumObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)1);
        maxObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)2);
        minObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)3);
        extremaObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)4);
        varianceObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)5);
        devstdObj = StatsFactory.createSimpleStatisticsObjectFromInt((int)6);
        histogramObj = StatsFactory.createComplexStatisticsObjectFromInt((int)7, (double)minBound, (double)maxBound, (int)numBins);
        modeObj = StatsFactory.createComplexStatisticsObjectFromInt((int)8, (double)minBound, (double)maxBound, (int)numBins);
        medianObj = StatsFactory.createComplexStatisticsObjectFromInt((int)9, (double)minBound, (double)maxBound, (int)numBins);
    }

    private int getIndex(double sample) {
        int index = (int)((sample - minBound) / binInterval);
        return index;
    }

    @Test
    public void testMeanAndSum() {
        double mean = 0.0;
        double sum = this.calculateSumMean(sumObj, meanObj);
        double sum2 = (Double)sumObj.getResult();
        Assert.assertEquals((double)sum, (double)sum2, (double)0.1);
        mean = sum / 99.0;
        double mean2 = (Double)meanObj.getResult();
        Assert.assertEquals((double)mean, (double)mean2, (double)0.1);
    }

    @Test
    public void testMeanCorrectness() {
        MeanSum mean = new MeanSum(false);
        mean.addSample(2.0);
        mean.addSample(2.0);
        Assert.assertEquals((double)2.0, (double)((Double)mean.getResult()), (double)0.1);
    }

    @Test
    public void testMinMaxExtrema() {
        double[] minMax = this.calculateMaxMinExtrema(minObj, maxObj, extremaObj);
        double min = minMax[0];
        double max = minMax[1];
        double[] array = (double[])extremaObj.getResult();
        double max2 = array[1];
        double min2 = array[0];
        Assert.assertEquals((double)min, (double)min2, (double)0.1);
        Assert.assertEquals((double)max, (double)max2, (double)0.1);
        double min3 = (Double)minObj.getResult();
        Assert.assertEquals((double)min, (double)min3, (double)0.1);
        double max3 = (Double)maxObj.getResult();
        Assert.assertEquals((double)max, (double)max3, (double)0.1);
    }

    @Test
    public void testDevStdVariance() {
        double mean = 0.0;
        double variance = 0.0;
        double std = 0.0;
        double sum = this.calculateVarianceAndStd(varianceObj, devstdObj);
        mean = sum / 99.0;
        double sum2 = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum2 += Math.pow(testArray[i] - mean, 2.0);
        }
        variance = sum2 / 99.0;
        double variance2 = (Double)varianceObj.getResult();
        Assert.assertEquals((double)variance, (double)variance2, (double)0.1);
        std = Math.sqrt(variance);
        double std2 = (Double)devstdObj.getResult();
        Assert.assertEquals((double)std, (double)std2, (double)0.1);
    }

    @Test
    public void testHistModeMedian() {
        double[] hist = new double[numBins];
        ArrayList<Double> listData = new ArrayList<Double>();
        double median = 0.0;
        for (int i = 0; i < 100; ++i) {
            if (interval.contains(testArray[i])) {
                int index;
                int n = index = this.getIndex(testArray[i]);
                hist[n] = hist[n] + 1.0;
                listData.add(testArray[i]);
            }
            modeObj.addSample(testArray[i]);
            histogramObj.addSample(testArray[i]);
            medianObj.addSample(testArray[i]);
        }
        Collections.sort(listData);
        int listSize = listData.size();
        if (listSize == 0) {
            median = Double.NaN;
        } else if (listSize == 1) {
            median = (Double)listData.get(0);
        } else {
            int halfSize = listSize / 2;
            double halfValue = (Double)listData.get(halfSize);
            median = listData.size() % 2 == 1 ? halfValue : (halfValue + (Double)listData.get(halfSize + 1)) / 2.0;
        }
        double max = Double.NEGATIVE_INFINITY;
        double indexMax = 0.0;
        for (int i = 0; i < numBins; ++i) {
            if (!(hist[i] > max)) continue;
            max = hist[i];
            indexMax = i;
        }
        if (max != 0.0) {
            indexMax += minBound;
        }
        double indexMax2 = (Double)modeObj.getResult();
        Assert.assertEquals((double)indexMax, (double)indexMax2, (double)0.1);
        double[] hist2 = (double[])histogramObj.getResult();
        for (int i = 0; i < numBins; ++i) {
            Assert.assertEquals((double)hist[i], (double)hist2[i], (double)0.1);
        }
        double median2 = (Double)medianObj.getResult();
        Assert.assertEquals((double)median, (double)median2, (double)0.1);
    }

    @Test
    public void testCumulativeStats() {
        Statistics oldMeanObj = StatsFactory.createMeanObject();
        Statistics oldSumObj = StatsFactory.createSumObject();
        Statistics oldMaxObj = StatsFactory.createMaxObject();
        Statistics oldMinObj = StatsFactory.createMinObject();
        Statistics oldExtremaObj = StatsFactory.createExtremaObject();
        Statistics oldVarianceObj = StatsFactory.createVarianceObject();
        Statistics oldDevStdObj = StatsFactory.createDevStdObject();
        this.calculateSumMean(oldSumObj, oldMeanObj);
        this.calculateMaxMinExtrema(oldMinObj, oldMaxObj, oldExtremaObj);
        this.calculateVarianceAndStd(oldVarianceObj, oldDevStdObj);
        Statistics newMeanObj = StatsFactory.createMeanObject();
        newMeanObj.addSample(1.0);
        Statistics newSumObj = StatsFactory.createSumObject();
        newSumObj.addSample(1.0);
        Statistics newMaxObj = StatsFactory.createMaxObject();
        newMaxObj.addSample(1.0);
        Statistics newMinObj = StatsFactory.createMinObject();
        newMinObj.addSample(1.0);
        Statistics newExtremaObj = StatsFactory.createExtremaObject();
        newExtremaObj.addSample(1.0);
        Statistics newVarianceObj = StatsFactory.createVarianceObject();
        newVarianceObj.addSample(1.0);
        Statistics newDevStdObj = StatsFactory.createDevStdObject();
        newDevStdObj.addSample(1.0);
        newMeanObj.accumulateStats(oldMeanObj);
        newSumObj.accumulateStats(oldSumObj);
        newMaxObj.accumulateStats(oldMaxObj);
        newMinObj.accumulateStats(oldMinObj);
        newExtremaObj.accumulateStats(oldExtremaObj);
        newVarianceObj.accumulateStats(oldVarianceObj);
        newDevStdObj.accumulateStats(oldDevStdObj);
        double newMeanUpdated = (Double)newMeanObj.getResult();
        double newSumUpdated = (Double)newSumObj.getResult();
        double newMaxUpdated = (Double)newMaxObj.getResult();
        double newMinUpdated = (Double)newMinObj.getResult();
        double[] newExtrema = (double[])newExtremaObj.getResult();
        double newExmin = newExtrema[0];
        double newExmax = newExtrema[1];
        double newVarianceUpdated = (Double)newVarianceObj.getResult();
        double newStdUpdated = (Double)newDevStdObj.getResult();
        double sum = 0.0;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 100; ++i) {
            sum += testArray[i];
            if (testArray[i] > max) {
                max = testArray[i];
            }
            if (!(testArray[i] < min)) continue;
            min = testArray[i];
        }
        double meanCalc = (sum + 1.0) / 100.0;
        double sumCalc = sum + 1.0;
        double maxCalc = 1.0 > max ? 1.0 : max;
        double minCalc = 1.0 < min ? 1.0 : min;
        double varianceCalc = 0.0;
        double stdCalc = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum2 += Math.pow(testArray[i] - meanCalc, 2.0);
        }
        varianceCalc = (sum2 += Math.pow(1.0 - meanCalc, 2.0)) / 100.0;
        stdCalc = Math.sqrt(varianceCalc);
        Assert.assertEquals((double)meanCalc, (double)newMeanUpdated, (double)0.1);
        Assert.assertEquals((double)sumCalc, (double)newSumUpdated, (double)0.1);
        Assert.assertEquals((double)maxCalc, (double)newMaxUpdated, (double)0.1);
        Assert.assertEquals((double)minCalc, (double)newMinUpdated, (double)0.1);
        Assert.assertEquals((double)maxCalc, (double)newExmax, (double)0.1);
        Assert.assertEquals((double)minCalc, (double)newExmin, (double)0.1);
        Assert.assertEquals((double)varianceCalc, (double)newVarianceUpdated, (double)0.1);
        Assert.assertEquals((double)stdCalc, (double)newStdUpdated, (double)0.1);
    }

    @Test
    public void testEmptyStats() {
        Statistics newMeanObj = StatsFactory.createMeanObject();
        newMeanObj.addSample(1.0);
        Statistics newSumObj = StatsFactory.createSumObject();
        newSumObj.addSample(1.0);
        Statistics newMaxObj = StatsFactory.createMaxObject();
        newMaxObj.addSample(1.0);
        Statistics newMinObj = StatsFactory.createMinObject();
        newMinObj.addSample(1.0);
        Statistics newExtremaObj = StatsFactory.createExtremaObject();
        newExtremaObj.addSample(1.0);
        Statistics newVarianceObj = StatsFactory.createVarianceObject();
        newVarianceObj.addSample(1.0);
        Statistics newDevStdObj = StatsFactory.createDevStdObject();
        newDevStdObj.addSample(1.0);
        Statistics newHistObj = StatsFactory.createHistogramObject((int)numBins, (double)minBound, (double)maxBound);
        newHistObj.addSample(1.0);
        Statistics newModeObj = StatsFactory.createModeObject((int)numBins, (double)minBound, (double)maxBound);
        newModeObj.addSample(1.0);
        Statistics newMedianObj = StatsFactory.createMedianObject((double)minBound, (double)maxBound);
        newMedianObj.addSample(1.0);
        newMeanObj.clearStats();
        newSumObj.clearStats();
        newMaxObj.clearStats();
        newMinObj.clearStats();
        newExtremaObj.clearStats();
        newVarianceObj.clearStats();
        newDevStdObj.clearStats();
        newHistObj.clearStats();
        newModeObj.clearStats();
        newMedianObj.clearStats();
        double newMeanUpdated = (Double)newMeanObj.getResult();
        double newSumUpdated = (Double)newSumObj.getResult();
        double newMaxUpdated = (Double)newMaxObj.getResult();
        double newMinUpdated = (Double)newMinObj.getResult();
        double[] newExtrema = (double[])newExtremaObj.getResult();
        double newExmin = newExtrema[0];
        double newExmax = newExtrema[1];
        double newVarianceUpdated = (Double)newVarianceObj.getResult();
        double newStdUpdated = (Double)newDevStdObj.getResult();
        double[] newHistUpdated = (double[])newHistObj.getResult();
        double newModeUpdated = (Double)newModeObj.getResult();
        double newMedianUpdated = (Double)newMedianObj.getResult();
        Assert.assertEquals((double)0.0, (double)newMeanUpdated, (double)0.1);
        Assert.assertEquals((double)0.0, (double)newSumUpdated, (double)0.1);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)newMaxUpdated, (double)0.1);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)newMinUpdated, (double)0.1);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)newExmax, (double)0.1);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)newExmin, (double)0.1);
        Assert.assertEquals((double)Double.NaN, (double)newVarianceUpdated, (double)0.1);
        Assert.assertEquals((double)Double.NaN, (double)newStdUpdated, (double)0.1);
        for (int i = 0; i < numBins; ++i) {
            Assert.assertEquals((double)0.0, (double)newHistUpdated[i], (double)0.1);
        }
        Assert.assertEquals((double)0.0, (double)newModeUpdated, (double)0.1);
        Assert.assertEquals((double)Double.NaN, (double)newMedianUpdated, (double)0.1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMeanException() {
        meanObj.accumulateStats(sumObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSumException() {
        sumObj.accumulateStats(meanObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMaxException() {
        maxObj.accumulateStats(sumObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testMinException() {
        minObj.accumulateStats(sumObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtremaException() {
        extremaObj.accumulateStats(sumObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testVarianceException() {
        varianceObj.accumulateStats(sumObj);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDevStdException() {
        devstdObj.accumulateStats(sumObj);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testHistException() {
        histogramObj.accumulateStats(sumObj);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testModeException() {
        modeObj.accumulateStats(sumObj);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testMedianException() {
        medianObj.accumulateStats(sumObj);
    }

    private double calculateSumMean(Statistics sumObj, Statistics meanObj) {
        double sum = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum += testArray[i];
            sumObj.addSample(testArray[i]);
            meanObj.addSample(testArray[i]);
        }
        return sum;
    }

    private double[] calculateMaxMinExtrema(Statistics minObj, Statistics maxObj, Statistics extremaObj) {
        double[] minMax = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (int i = 0; i < 100; ++i) {
            if (testArray[i] > minMax[1]) {
                minMax[1] = testArray[i];
            }
            if (testArray[i] < minMax[0]) {
                minMax[0] = testArray[i];
            }
            minObj.addSample(testArray[i]);
            maxObj.addSample(testArray[i]);
            extremaObj.addSample(testArray[i]);
        }
        return minMax;
    }

    private double calculateVarianceAndStd(Statistics varianceObj, Statistics devstdObj) {
        double sum = 0.0;
        for (int i = 0; i < 100; ++i) {
            sum += testArray[i];
            varianceObj.addSample(testArray[i]);
            devstdObj.addSample(testArray[i]);
        }
        return sum;
    }
}

