/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.stats;

public abstract class Statistics {
    public static final String STATS_PROPERTY = "JAI-EXT.stats";
    protected StatsType type;
    protected long samples;

    protected StatsType getStatsType() {
        return this.type;
    }

    protected void checkSameStats(Statistics stats) {
        if (stats.getStatsType() != this.type) {
            throw new IllegalArgumentException("These statistics are not the same");
        }
    }

    public abstract void addSample(double var1);

    protected abstract void accumulateStats(Statistics var1);

    public abstract Object getResult();

    protected abstract void clearStats();

    public abstract Long getNumSamples();

    public static enum StatsType {
        MEAN(0),
        SUM(1),
        MAX(2),
        MIN(3),
        EXTREMA(4),
        VARIANCE(5),
        DEV_STD(6),
        HISTOGRAM(7),
        MODE(8),
        MEDIAN(9);

        private int id;

        private StatsType(int id) {
            this.id = id;
        }

        public int getStatsId() {
            return this.id;
        }
    }
}

