/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.contrastenhancement;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class PropertyUtil {
    private static Map<String, ResourceBundle> BUNDLES = new HashMap<String, ResourceBundle>();
    private static String propertiesDir = "it/geosolutions/jaiext/contrastenhancement";

    public static InputStream getFileFromClasspath(String path) throws IOException, FileNotFoundException {
        InputStream is;
        String urlHeader;
        String sep = File.separator;
        String tmpHome = null;
        try {
            tmpHome = System.getProperty("java.home");
        }
        catch (Exception e) {
            tmpHome = null;
        }
        String home = tmpHome;
        String string = urlHeader = tmpHome == null ? null : home + sep + "lib" + sep;
        if (home != null) {
            String libExtPath = urlHeader + "ext" + sep + path;
            File libExtFile = new File(libExtPath);
            try {
                if (libExtFile.exists() && (is = new FileInputStream(libExtFile)) != null) {
                    return is;
                }
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
        if ((is = PropertyUtil.class.getResourceAsStream("/" + path)) != null) {
            return is;
        }
        return null;
    }

    private static ResourceBundle getBundle(String packageName) {
        PropertyResourceBundle bundle = null;
        InputStream in = null;
        try {
            in = PropertyUtil.getFileFromClasspath(propertiesDir + "/" + packageName + ".properties");
            if (in != null) {
                bundle = new PropertyResourceBundle(in);
                BUNDLES.put(packageName, bundle);
                return bundle;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getString(String packageName, String key) {
        ResourceBundle b = BUNDLES.get(packageName);
        if (b == null) {
            b = PropertyUtil.getBundle(packageName);
        }
        return b.getString(key);
    }

    public static String[] getPropertyNames(String[] propertyNames, String prefix) {
        if (propertyNames == null) {
            return null;
        }
        if (prefix == null) {
            throw new IllegalArgumentException("The property name prefix may not be null");
        }
        prefix = prefix.toLowerCase();
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!propertyNames[i].toLowerCase().startsWith(prefix)) continue;
            names.addElement(propertyNames[i]);
        }
        if (names.size() == 0) {
            return null;
        }
        String[] prefixNames = new String[names.size()];
        int count = 0;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            prefixNames[count++] = (String)it.next();
        }
        return prefixNames;
    }
}

