/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AbstractCommand {
    private static Logger LOGGER = LogManager.getLogger(AbstractCommand.class);

    protected static List<File> validateFiles(String[] pathArr) throws BadParamException {
        ArrayList<File> ret = new ArrayList<File>(pathArr.length);
        for (String path : pathArr) {
            ret.add(AbstractCommand.validateFile(path));
        }
        return ret;
    }

    protected static File validateFile(String path) throws BadParamException {
        Path p = Paths.get(path, new String[0]);
        File file = p.toFile();
        if (file.exists()) {
            return file;
        }
        throw new BadParamException("File not found: " + path);
    }

    protected static Double validateDouble(String s) throws BadParamException {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            throw new BadParamException("Bad double value: " + s);
        }
    }

    protected static void dumpParams(CommandLine cl, Options options) {
        ArrayList<String> deferred = new ArrayList<String>();
        LOGGER.info("Options:");
        for (Option option : options.getOptions()) {
            String name;
            String string = name = option.getOpt() != null ? option.getOpt() : option.getLongOpt();
            if (cl.hasOption(name)) {
                if (option.hasArgs()) {
                    LOGGER.info("Option " + name + " = " + Arrays.toString(cl.getOptionValues(name)));
                    continue;
                }
                if (option.hasArg()) {
                    LOGGER.info("Option " + name + " = " + cl.getOptionValue(name));
                    continue;
                }
                LOGGER.info("Option " + name);
                continue;
            }
            deferred.add(name);
        }
        LOGGER.debug("---");
        for (String name : deferred) {
            LOGGER.debug("Option " + name + " not set");
        }
    }

    public static class BadParamException
    extends Exception {
        public BadParamException() {
        }

        public BadParamException(String message) {
            super(message);
        }

        public BadParamException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

