/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.shadedrelief;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefAlgorithm;
import it.geosolutions.jaiext.shadedrelief.ShadedReliefDescriptor;
import it.geosolutions.jaiext.testclasses.TestBase;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.TiledImage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ShadedReliefTest
extends TestBase {
    private Logger logger = Logger.getLogger(ShadedReliefTest.class.getName());
    private static final double DEFAULT_Z = 1.0;
    private static final double DEFAULT_SCALE = 1.0;
    private static final double DEFAULT_ALTITUDE = 64.0;
    private static final double DEFAULT_AZIMUTH = 160.0;
    private static RenderedImage[] testImages;
    private static Range[] srcNoData;
    private static double dstNoData;
    private static String[] typeName;
    private static ROI roiObject;
    private static List<Integer> typesToTest;
    private static TestPoint[] testPoints;

    @BeforeClass
    public static void initialSetup() {
        double min = 10.0;
        double max = 100.0;
        testImages = new RenderedImage[6];
        ShadedReliefTest.testImages[0] = ShadedReliefTest.createTestPyramidImage(0, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        ShadedReliefTest.testImages[1] = ShadedReliefTest.createTestPyramidImage(1, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        ShadedReliefTest.testImages[2] = ShadedReliefTest.createTestPyramidImage(2, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        ShadedReliefTest.testImages[3] = ShadedReliefTest.createTestPyramidImage(3, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        ShadedReliefTest.testImages[4] = ShadedReliefTest.createTestPyramidImage(4, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        ShadedReliefTest.testImages[5] = ShadedReliefTest.createTestPyramidImage(5, DEFAULT_WIDTH, DEFAULT_HEIGHT, min, max, 0);
        int w2 = DEFAULT_WIDTH / 2;
        int w4 = DEFAULT_WIDTH / 4;
        int w34 = 3 * DEFAULT_WIDTH / 4;
        int h2 = DEFAULT_HEIGHT / 2;
        int h4 = DEFAULT_HEIGHT / 4;
        int h34 = 3 * DEFAULT_HEIGHT / 4;
        testPoints = new TestPoint[]{new TestPoint(w2, h4, 236.0), new TestPoint(w34, h2, 189.0), new TestPoint(w2, h34, 88.0), new TestPoint(w4, h2, 135.0)};
        int noDataB = 50;
        int noDataS = 50;
        int noDataI = 50;
        float noDataF = 50.0f;
        double noDataD = 50.0;
        boolean minIncluded = true;
        boolean maxIncluded = true;
        srcNoData = new Range[6];
        ShadedReliefTest.srcNoData[0] = RangeFactory.create((byte)50, (boolean)minIncluded, (byte)50, (boolean)maxIncluded);
        ShadedReliefTest.srcNoData[1] = RangeFactory.createU((short)50, (boolean)minIncluded, (short)50, (boolean)maxIncluded);
        ShadedReliefTest.srcNoData[2] = RangeFactory.create((short)50, (boolean)minIncluded, (short)50, (boolean)maxIncluded);
        ShadedReliefTest.srcNoData[3] = RangeFactory.create((int)50, (boolean)minIncluded, (int)50, (boolean)maxIncluded);
        ShadedReliefTest.srcNoData[4] = RangeFactory.create((float)50.0f, (boolean)minIncluded, (float)50.0f, (boolean)maxIncluded, (boolean)true);
        ShadedReliefTest.srcNoData[5] = RangeFactory.create((double)50.0, (boolean)minIncluded, (double)50.0, (boolean)maxIncluded, (boolean)true);
        typeName = new String[6];
        ShadedReliefTest.typeName[0] = "Byte";
        ShadedReliefTest.typeName[5] = "Double";
        ShadedReliefTest.typeName[4] = "Float";
        ShadedReliefTest.typeName[3] = "Int";
        ShadedReliefTest.typeName[2] = "Short";
        ShadedReliefTest.typeName[1] = "UShort";
        Rectangle roiBounds = new Rectangle(DEFAULT_WIDTH / 6, DEFAULT_HEIGHT / 4, DEFAULT_WIDTH / 6, DEFAULT_HEIGHT / 2);
        roiObject = new ROIShape((Shape)roiBounds);
        dstNoData = 100.0;
        typesToTest = new ArrayList<Integer>();
        typesToTest.add(0);
        typesToTest.add(1);
        typesToTest.add(2);
        typesToTest.add(3);
        typesToTest.add(4);
        typesToTest.add(5);
    }

    @AfterClass
    public static void after() {
        System.out.println("Test class completed");
    }

    @Test
    public void test() {
        boolean roiUsed = false;
        boolean nodataUsed = false;
        double resx = 1.0;
        double resy = 1.0;
        double vex = 1.0;
        double ves = 1.0;
        double alt = 64.0;
        double az = 160.0;
        ShadedReliefAlgorithm algorithm = ShadedReliefAlgorithm.DEFAULT;
        ROI roi = null;
        for (Integer i : typesToTest) {
            RenderedOp shaded = ShadedReliefDescriptor.create((RenderedImage)testImages[i], roi, null, (double)dstNoData, (double)resx, (double)resy, (double)vex, (double)ves, (double)alt, (double)az, (ShadedReliefAlgorithm)algorithm, null);
            this.check(i, testImages[i], shaded, roiUsed, roi, nodataUsed, srcNoData[i]);
            shaded.dispose();
        }
    }

    @Test
    public void testROI() {
        boolean roiUsed = true;
        boolean nodataUsed = false;
        ROI roi = roiObject;
        double resx = 1.0;
        double resy = 1.0;
        double vex = 1.0;
        double ves = 1.0;
        double alt = 64.0;
        double az = 160.0;
        ShadedReliefAlgorithm algorithm = ShadedReliefAlgorithm.DEFAULT;
        for (Integer i : typesToTest) {
            RenderedOp shaded = ShadedReliefDescriptor.create((RenderedImage)testImages[i], (ROI)roi, null, (double)dstNoData, (double)resx, (double)resy, (double)vex, (double)ves, (double)alt, (double)az, (ShadedReliefAlgorithm)algorithm, null);
            this.check(i, testImages[i], shaded, roiUsed, roi, nodataUsed, srcNoData[i]);
            shaded.dispose();
        }
    }

    @Test
    public void testNoData() {
        boolean roiUsed = false;
        boolean nodataUsed = true;
        ROI roi = null;
        double resx = 1.0;
        double resy = 1.0;
        double vex = 1.0;
        double ves = 1.0;
        double alt = 64.0;
        double az = 160.0;
        ShadedReliefAlgorithm algorithm = ShadedReliefAlgorithm.DEFAULT;
        for (Integer i : typesToTest) {
            RenderedOp shaded = ShadedReliefDescriptor.create((RenderedImage)testImages[i], roi, (Range)srcNoData[i], (double)dstNoData, (double)resx, (double)resy, (double)vex, (double)ves, (double)alt, (double)az, (ShadedReliefAlgorithm)algorithm, null);
            this.check(i, testImages[i], shaded, roiUsed, roi, nodataUsed, srcNoData[i]);
            shaded.dispose();
        }
    }

    @Test
    public void testROInoData() {
        boolean roiUsed = true;
        boolean nodataUsed = true;
        ROI roi = roiObject;
        double resx = 1.0;
        double resy = 1.0;
        double vex = 1.0;
        double ves = 1.0;
        double alt = 64.0;
        double az = 160.0;
        ShadedReliefAlgorithm algorithm = ShadedReliefAlgorithm.DEFAULT;
        for (Integer i : typesToTest) {
            RenderedOp shaded = ShadedReliefDescriptor.create((RenderedImage)testImages[i], (ROI)roi, (Range)srcNoData[i], (double)dstNoData, (double)resx, (double)resy, (double)vex, (double)ves, (double)alt, (double)az, (ShadedReliefAlgorithm)algorithm, null);
            this.check(i, testImages[i], shaded, roiUsed, roi, nodataUsed, srcNoData[i]);
            shaded.dispose();
        }
    }

    private void check(int type, RenderedImage src, RenderedOp shaded, boolean roiUsed, ROI roi, boolean nodataUsed, Range noData) {
        int tileWidth = shaded.getTileWidth();
        int tileHeight = shaded.getTileHeight();
        int minTileX = shaded.getMinTileX();
        int minTileY = shaded.getMinTileY();
        int numXTiles = shaded.getNumXTiles();
        int numYTiles = shaded.getNumYTiles();
        int maxTileX = minTileX + numXTiles;
        int maxTileY = minTileY + numYTiles;
        Assert.assertEquals((long)shaded.getWidth(), (long)src.getWidth());
        Assert.assertEquals((long)shaded.getHeight(), (long)src.getHeight());
        Assert.assertEquals((long)shaded.getMinX(), (long)src.getMinX());
        Assert.assertEquals((long)shaded.getMinY(), (long)src.getMinY());
        Assert.assertEquals((long)minTileX, (long)src.getMinTileX());
        Assert.assertEquals((long)minTileY, (long)src.getMinTileY());
        Assert.assertEquals((long)numXTiles, (long)src.getNumXTiles());
        Assert.assertEquals((long)numYTiles, (long)src.getNumYTiles());
        Assert.assertEquals((long)tileWidth, (long)src.getTileWidth());
        Assert.assertEquals((long)tileHeight, (long)src.getTileHeight());
        int srcBands = src.getSampleModel().getNumBands();
        int dstBands = shaded.getNumBands();
        Assert.assertEquals((long)srcBands, (long)dstBands);
        for (TestPoint point : testPoints) {
            double val = shaded.getTile(0, 0).getSampleDouble(point.x, point.y, 0);
            boolean isInRoi = !roiUsed || roiUsed && roi.contains(point.x, point.y);
            double expected = isInRoi ? point.value : dstNoData;
            boolean ok = Double.compare(expected, val) == 0 || Math.abs(expected - val) < 0.5;
            System.out.println((roiUsed ? "ROI" : "   ") + " " + (nodataUsed ? "NODATA" : "      ") + "  TYPE " + typeName[type] + " x:" + point.x + " y:" + point.y + " v:" + point.value + " --> " + val + " " + (isInRoi ? " IN ROI" : "") + " " + (ok ? " OK" : "BAD!! nd=" + dstNoData));
            Assert.assertEquals((String)"Bad shaded value", (double)expected, (double)val, (double)0.5);
        }
    }

    public static RenderedImage createTestPyramidImage(int dataType, int width, int height, Number valueAtBase, Number valueAtTop, Number noDataValue) {
        ComponentSampleModel sm = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        ColorModel cm = TiledImage.createColorModel((SampleModel)sm);
        if (cm == null) {
            if (dataType == 2) {
                ColorSpace cs = ColorSpace.getInstance(1003);
                cm = new ComponentColorModel(cs, false, false, 1, 2);
            } else {
                throw new IllegalStateException("NO COLOR MODEL");
            }
        }
        TiledImage used = new TiledImage(0, 0, width, height, 0, 0, (SampleModel)sm, cm);
        boolean b = false;
        for (int x = 0; x <= width / 2; ++x) {
            for (int y = 0; y < height / 2; ++y) {
                Double value = 0.0;
                value = Math.min((double)x, (double)y);
                ShadedReliefTest.setSample(dataType, used, x, y, value);
                ShadedReliefTest.setSample(dataType, used, width - x - 1, y, value);
                ShadedReliefTest.setSample(dataType, used, width - x - 1, height - y - 1, value);
                ShadedReliefTest.setSample(dataType, used, x, height - y - 1, value);
            }
        }
        return used;
    }

    private static void setSample(int dataType, TiledImage used, int x, int y, Double value) {
        boolean b = false;
        switch (dataType) {
            case 0: {
                used.setSample(x, y, 0, (int)value.byteValue());
                break;
            }
            case 1: {
                used.setSample(x, y, 0, (int)value.shortValue());
                break;
            }
            case 2: {
                used.setSample(x, y, 0, (int)value.shortValue());
                break;
            }
            case 3: {
                used.setSample(x, y, 0, value.intValue());
                break;
            }
            case 4: {
                used.setSample(x, y, 0, value.floatValue());
                break;
            }
            case 5: {
                used.setSample(x, y, 0, value.doubleValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data type");
            }
        }
    }

    static RenderedImage rescale(RenderedImage image, ROI roi) {
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        if (roi != null) {
            pb.add(roi);
        }
        RenderedOp op = JAI.create((String)"extrema", (ParameterBlock)pb);
        double[][] extrema = (double[][])op.getProperty("extrema");
        double[] scale = new double[]{255.0 / (extrema[1][0] - extrema[0][0])};
        double[] offset = new double[]{255.0 * extrema[0][0] / (extrema[0][0] - extrema[1][0])};
        ParameterBlock pbRescale = new ParameterBlock();
        pbRescale.add(scale);
        pbRescale.add(offset);
        pbRescale.addSource(image);
        RenderedOp rescaledImage = JAI.create((String)"Rescale", (ParameterBlock)pbRescale);
        ParameterBlock pbConvert = new ParameterBlock();
        pbConvert.addSource(rescaledImage);
        pbConvert.add(0);
        RenderedOp destImage = JAI.create((String)"format", (ParameterBlock)pbConvert);
        return destImage;
    }

    static class TestPoint {
        int x;
        int y;
        Double value;

        public TestPoint(int x, int y, Double value) {
            this.x = x;
            this.y = y;
            this.value = value;
        }
    }
}

