/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.scale.ScaleDescriptor;
import it.geosolutions.jaiext.scale.TestScale;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.NullOpImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Test;

public class ScaleOpPerformanceTest
extends TestScale {
    @Test(timeout=10000L)
    public void testScaleTilePerformanceUsingTimeout() {
        RenderedImage image = ScaleOpPerformanceTest.testImage(6500, 5300);
        RenderedOp tileImage = ScaleOpPerformanceTest.tileImage(image, 512, 512);
        RenderedImage scaledImage = ScaleOpPerformanceTest.scaleForTest((RenderedImage)tileImage, 0.1f, 0.1f, BorderExtender.createInstance((int)0));
        scaledImage.getData();
        ((RenderedOp)scaledImage).dispose();
    }

    @Test
    public void testScaleTilePerformanceUsingAssert() {
        RenderedImage image = ScaleOpPerformanceTest.testImage(6500, 5300);
        RenderedOp tileImage = ScaleOpPerformanceTest.tileImage(image, 512, 512);
        ScaleOpTestImage testOpImage = new ScaleOpTestImage((RenderedImage)tileImage);
        RenderedImage scaledImage = ScaleOpPerformanceTest.scaleForTest((RenderedImage)((Object)testOpImage), 0.1f, 0.1f, BorderExtender.createInstance((int)0));
        scaledImage.getData();
        ((RenderedOp)scaledImage).dispose();
    }

    private static RenderedImage scaleForTest(RenderedImage image, float scaleX, float scaleY, BorderExtender borderExtender) {
        RenderingHints renderingHints = borderExtender == null ? null : new RenderingHints(JAI.KEY_BORDER_EXTENDER, borderExtender);
        return ScaleDescriptor.create((RenderedImage)image, (Float)Float.valueOf(scaleX), (Float)Float.valueOf(scaleY), (Float)Float.valueOf(1.0f), (Float)Float.valueOf(1.0f), (Interpolation)new InterpolationNearest(), null, (Boolean)false, (Range)RangeFactory.create((float)-999.0f, (boolean)true, (float)-999.0f, (boolean)true, (boolean)true), (double[])new double[]{255.0}, (RenderingHints)renderingHints);
    }

    private static RenderedOp tileImage(RenderedImage image, int tileWidth, int tileHeight) {
        ImageLayout tileLayout = new ImageLayout(image);
        tileLayout.setTileWidth(tileWidth);
        tileLayout.setTileHeight(tileHeight);
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        return JAI.create((String)"format", (ParameterBlock)pb, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, tileLayout));
    }

    private static RenderedImage testImage(int imageWidth, int imageHeight) {
        WritableRaster raster = RasterFactory.createBandedRaster((int)4, (int)imageWidth, (int)imageHeight, (int)1, null);
        float[] dataBuffer = ((DataBufferFloat)raster.getDataBuffer()).getData();
        for (int rowIdx = 0; rowIdx < imageHeight; ++rowIdx) {
            for (int columnIdx = 0; columnIdx < imageWidth; ++columnIdx) {
                dataBuffer[(imageHeight - rowIdx - 1) * imageWidth + columnIdx] = 32.2f;
            }
        }
        int[] dataTypeSize = new int[]{DataBuffer.getDataTypeSize(4)};
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, dataTypeSize, false, true, 1, 4);
        return new BufferedImage(colorModel, raster, false, null);
    }

    static class ScaleOpTestImage
    extends NullOpImage {
        public ScaleOpTestImage(RenderedImage source) {
            super(source, new ImageLayout(source), null, 1);
        }

        public Raster getData(Rectangle region) {
            Assert.assertTrue((String)("Region width " + region.width + " should be smaller/equal than tileWidth " + this.getTileWidth()), (region.width <= this.getTileWidth() ? 1 : 0) != 0);
            Assert.assertTrue((String)("Region height " + region.height + " should be smaller/equal than tileHeight " + this.getTileHeight()), (region.height <= this.getTileHeight() ? 1 : 0) != 0);
            return super.getData(region);
        }
    }
}

