/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.PropertyGeneratorImpl;
import com.vividsolutions.jts.geom.Geometry;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.scale.ScaleGeneralOpImage;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import org.jaitools.imageutils.ImageLayout2;
import org.jaitools.imageutils.ROIGeometry;

class ScalePropertyGenerator
extends PropertyGeneratorImpl {
    public ScalePropertyGenerator() {
        super(new String[]{"ROI"}, new Class[]{ROI.class}, new Class[]{RenderedOp.class});
    }

    public Object getProperty(String name, Object opNode) {
        this.validate(name, opNode);
        if (opNode instanceof RenderedOp && name.equalsIgnoreCase("roi")) {
            RenderedOp op = (RenderedOp)opNode;
            ParameterBlock pb = op.getParameterBlock();
            RenderedImage src = pb.getRenderedSource(0);
            Object property = src.getProperty("ROI");
            if (property == null || property.equals(Image.UndefinedProperty) || !(property instanceof ROI)) {
                if (pb.getObjectParameter(5) != null) {
                    property = pb.getObjectParameter(5);
                } else {
                    return Image.UndefinedProperty;
                }
            }
            ROI srcROI = (ROI)property;
            Interpolation interp = (Interpolation)pb.getObjectParameter(4);
            Rectangle srcBounds = null;
            PlanarImage dst = op.getRendering();
            srcBounds = dst instanceof GeometricOpImage && ((GeometricOpImage)dst).getBorderExtender() == null ? new Rectangle(src.getMinX() + interp.getLeftPadding(), src.getMinY() + interp.getTopPadding(), src.getWidth() - interp.getWidth() + 1, src.getHeight() - interp.getHeight() + 1) : new Rectangle(src.getMinX(), src.getMinY(), src.getWidth(), src.getHeight());
            if (!srcBounds.contains(srcROI.getBounds())) {
                srcROI = srcROI.intersect((ROI)new ROIShape((Shape)srcBounds));
            }
            float sx = pb.getFloatParameter(0);
            float sy = pb.getFloatParameter(1);
            float tx = pb.getFloatParameter(2);
            float ty = pb.getFloatParameter(3);
            Rectangle dstBounds = op.getBounds();
            Object roiImage = null;
            if (interp instanceof InterpolationBilinear) {
                ImageLayout2 layout = new ImageLayout2();
                int minx = (int)srcBounds.getMinX();
                int miny = (int)srcBounds.getMinY();
                int w = (int)srcBounds.getWidth();
                int h = (int)srcBounds.getHeight();
                layout.setMinX(minx);
                layout.setMinY(miny);
                layout.setWidth(w);
                layout.setHeight(h);
                RenderingHints hints = op.getRenderingHints();
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
                RenderedOp constantImage = ConstantDescriptor.create((Float)new Float(w), (Float)new Float(h), (Number[])new Byte[]{(byte)-1}, (RenderingHints)hints);
                BorderExtender extender = BorderExtender.createInstance((int)1);
                RenderingHints scalingHints = op.getRenderingHints();
                scalingHints.remove(JAI.KEY_IMAGE_LAYOUT);
                if (srcROI instanceof ROIGeometry) {
                    ROIGeometry roiGeom = (ROIGeometry)srcROI;
                    Geometry geom = roiGeom.getAsGeometry();
                    if (geom != null && !geom.isEmpty()) {
                        constantImage.setProperty("roi", (Object)srcROI);
                    }
                } else {
                    constantImage.setProperty("roi", (Object)srcROI);
                }
                InterpolationBilinear interpolator = (InterpolationBilinear)interp;
                InterpolationBilinear interpBilinear = new InterpolationBilinear(interpolator.getSubsampleBitsH(), null, false, 0.0, interpolator.getDataType());
                roiImage = new ScaleGeneralOpImage((RenderedImage)constantImage, null, (Map)scalingHints, extender, (Interpolation)interpBilinear, sx, sy, tx, ty, false, null, null);
            } else {
                PlanarImage roiMod = srcROI.getAsImage();
                ParameterBlock paramBlock = new ParameterBlock();
                paramBlock.setSource(roiMod, 0);
                paramBlock.add(Float.valueOf(sx));
                paramBlock.add(Float.valueOf(sy));
                paramBlock.add(Float.valueOf(tx));
                paramBlock.add(Float.valueOf(ty));
                if (interp != null) {
                    if (interp instanceof InterpolationBicubic) {
                        InterpolationBicubic interpBicubic = (InterpolationBicubic)interp;
                        InterpolationBilinear interpBilinear = new InterpolationBilinear(interpBicubic.getSubsampleBitsH(), null, false, 0.0, interpBicubic.getDataType());
                        paramBlock.add(interpBilinear);
                    } else {
                        paramBlock.add(interp);
                    }
                }
                roiImage = JAI.create((String)"Scale", (ParameterBlock)paramBlock);
            }
            ROI dstROI = new ROI((RenderedImage)roiImage, 1);
            if (!dstBounds.contains(dstROI.getBounds())) {
                dstROI = dstROI.intersect((ROI)new ROIShape((Shape)dstBounds));
            }
            return dstROI;
        }
        return Image.UndefinedProperty;
    }
}

