/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleDescriptor;
import it.geosolutions.jaiext.scale.ScalePropertyGenerator;
import it.geosolutions.jaiext.scale.TestScale;
import it.geosolutions.jaiext.translate.TranslateIntOpImage;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.NullDescriptor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CoverageClassTest
extends TestScale {
    @Test
    public void testROIProperty() throws IOException {
        ScaleDescriptor descriptor = new ScaleDescriptor();
        ScalePropertyGenerator propertyGenerator = (ScalePropertyGenerator)descriptor.getPropertyGenerators()[0];
        boolean useROIAccessor = false;
        boolean bicubic2Disabled = false;
        boolean dataType = false;
        Object noDataRange = null;
        javax.media.jai.InterpolationNearest interpNear = new javax.media.jai.InterpolationNearest();
        javax.media.jai.InterpolationBilinear interpBil = new javax.media.jai.InterpolationBilinear(8);
        javax.media.jai.InterpolationBicubic interpBic = new javax.media.jai.InterpolationBicubic(8);
        ROIShape roi = this.roiCreation();
        byte imageValue = 127;
        RenderedImage testImg = CoverageClassTest.createTestImage((int)0, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        RenderedOp testIMG = NullDescriptor.create((RenderedImage)testImg, null);
        RenderedOp scaleImgNear = ScaleDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(this.scaleX), (Float)Float.valueOf(this.scaleY), (Float)Float.valueOf(this.transX), (Float)Float.valueOf(this.transY), (Interpolation)interpNear, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        RenderedOp scaleImgBil = ScaleDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(this.scaleX), (Float)Float.valueOf(this.scaleY), (Float)Float.valueOf(this.transX), (Float)Float.valueOf(this.transY), (Interpolation)interpBil, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        RenderedOp scaleImgBic = ScaleDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(this.scaleX), (Float)Float.valueOf(this.scaleY), (Float)Float.valueOf(this.transX), (Float)Float.valueOf(this.transY), (Interpolation)interpBic, (ROI)roi, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTile(0, 0);
        scaleImgBil.getTile(0, 0);
        scaleImgBic.getTile(0, 0);
        ROI roiNear = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgNear);
        ROI roiBil = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgBil);
        ROI roiBic = (ROI)propertyGenerator.getProperty("roi", (Object)scaleImgBic);
        int roiWidth = roi.getBounds().width;
        int roiHeight = roi.getBounds().height;
        int roiNearWidth = roiNear.getBounds().width;
        int roiNearHeight = roiNear.getBounds().height;
        Rectangle scaleImgBilBounds = new Rectangle(testIMG.getMinX() + interpBil.getLeftPadding(), testIMG.getMinY() + interpBil.getTopPadding(), testIMG.getWidth() - interpBil.getWidth() + 1, testIMG.getHeight() - interpBil.getHeight() + 1);
        int roiBoundWidth = (int)scaleImgBilBounds.getWidth();
        int roiBoundHeight = (int)scaleImgBilBounds.getHeight();
        int roiBilWidth = roiBil.getBounds().width;
        int roiBilHeighth = roiBil.getBounds().height;
        Rectangle scaleImgBicBounds = new Rectangle(testIMG.getMinX() + interpBic.getLeftPadding(), testIMG.getMinY() + interpBic.getTopPadding(), testIMG.getWidth() - interpBic.getWidth() + 2, testIMG.getHeight() - interpBic.getHeight() + 2);
        int roiBoundBicWidth = (int)scaleImgBicBounds.getWidth();
        int roiBoundBicHeight = (int)scaleImgBicBounds.getHeight();
        int roiBicWidth = roiBic.getBounds().width;
        int roiBicHeight = roiBic.getBounds().height;
        Assert.assertEquals((long)((int)((float)roiWidth * this.scaleX)), (long)roiNearWidth);
        Assert.assertEquals((long)((int)((float)roiHeight * this.scaleY)), (long)roiNearHeight);
        Assert.assertEquals((long)((int)((float)roiBoundWidth * this.scaleX)), (long)roiBilWidth);
        Assert.assertEquals((long)((int)((float)roiBoundHeight * this.scaleY)), (long)roiBilHeighth);
        Assert.assertEquals((long)((int)((float)roiBoundBicWidth * this.scaleX)), (long)roiBicWidth);
        Assert.assertEquals((long)((int)((float)roiBoundBicHeight * this.scaleY)), (long)roiBicHeight);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
        if (scaleImgBil instanceof RenderedOp) {
            scaleImgBil.dispose();
        }
        if (scaleImgBic instanceof RenderedOp) {
            scaleImgBic.dispose();
        }
    }

    @Test
    public void testTranslation() {
        boolean useROIAccessor = false;
        int dataType = 0;
        Range noDataRange = null;
        float xScale = 1.0f;
        float yScale = 1.0f;
        float xTrans = 3.0f;
        float yTrans = 3.0f;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpNear);
        InterpolationBilinear interpBilinear = new InterpolationBilinear(8, noDataRange, useROIAccessor, this.destinationNoData, dataType);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpBilinear);
        InterpolationBicubic interpBicubic = new InterpolationBicubic(8, noDataRange, useROIAccessor, this.destinationNoData, dataType, true, 8);
        this.testTranslation(useROIAccessor, dataType, xScale, yScale, xTrans, yTrans, imageValue, (Interpolation)interpBicubic);
    }

    public void testTranslation(boolean useROIAccessor, int dataType, float xScale, float yScale, float xTrans, float yTrans, byte imageValue, Interpolation interpolation) {
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        PlanarImage testImgWithROI = PlanarImage.wrapRenderedImage((RenderedImage)testIMG);
        testImgWithROI.setProperty("roi", (Object)new ROIShape((Shape)new Rectangle(0, 0, DEFAULT_WIDTH / 2, DEFAULT_HEIGHT / 2)));
        RenderedOp scaleImgNear = ScaleDescriptor.create((RenderedImage)testImgWithROI, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), (Interpolation)interpolation, null, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTiles();
        Assert.assertThat((Object)scaleImgNear.getRendering(), (Matcher)CoreMatchers.instanceOf(TranslateIntOpImage.class));
        Object roi = scaleImgNear.getProperty("roi");
        Assert.assertThat((Object)roi, (Matcher)CoreMatchers.instanceOf(ROI.class));
        Assert.assertThat((Object)((ROI)roi).getAsImage(), (Matcher)CoreMatchers.instanceOf(TranslateIntOpImage.class));
        double actualX = scaleImgNear.getMinX();
        double actualY = scaleImgNear.getMinY();
        double expectedX = (float)testIMG.getMinX() + xTrans;
        double expectedY = (float)testIMG.getMinY() + yTrans;
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
    }

    @Test
    public void testCopy() {
        boolean useROIAccessor = false;
        int dataType = 0;
        Range noDataRange = null;
        float xScale = 1.0f;
        float yScale = 1.0f;
        float xTrans = 0.0f;
        float yTrans = 0.0f;
        byte imageValue = 127;
        InterpolationNearest interpNear = new InterpolationNearest(noDataRange, useROIAccessor, this.destinationNoData, dataType);
        RenderedImage testIMG = CoverageClassTest.createTestImage((int)dataType, (int)DEFAULT_WIDTH, (int)DEFAULT_HEIGHT, (Number)imageValue, (boolean)false);
        RenderedOp scaleImgNear = ScaleDescriptor.create((RenderedImage)testIMG, (Float)Float.valueOf(xScale), (Float)Float.valueOf(yScale), (Float)Float.valueOf(xTrans), (Float)Float.valueOf(yTrans), (Interpolation)interpNear, null, (Boolean)useROIAccessor, null, null, null);
        scaleImgNear.getTiles();
        double actualX = scaleImgNear.getMinX();
        double actualY = scaleImgNear.getMinY();
        double expectedX = testIMG.getMinX();
        double expectedY = testIMG.getMinY();
        double tolerance = 0.1f;
        Assert.assertEquals((double)expectedX, (double)actualX, (double)tolerance);
        Assert.assertEquals((double)expectedY, (double)actualY, (double)tolerance);
        if (scaleImgNear instanceof RenderedOp) {
            scaleImgNear.dispose();
        }
    }
}

