/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.Rational;
import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.iterators.RandomIterFactory;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationTable;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.iterator.RandomIter;

public class ScaleGeneralOpImage
extends ScaleOpImage {
    protected InterpolationNearest interpN = null;
    protected InterpolationBilinear interpB = null;
    protected InterpolationBicubic interpBN = null;

    public ScaleGeneralOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues) {
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel && ImageUtil.isBinary((SampleModel)source.getSampleModel())) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        double[] destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues;
        }
        if (this.interpolator instanceof InterpolationNearest) {
            this.isNearestNew = true;
            this.interpN = (InterpolationNearest)this.interpolator;
            this.interp = this.interpN;
            this.interpN.setROIBounds(this.roiBounds);
            if (destNod == null) {
                destNod = new double[]{this.interpN.getDestinationNoData()};
            }
        } else if (this.interpolator instanceof InterpolationBilinear) {
            this.isBilinearNew = true;
            this.interpB = (InterpolationBilinear)this.interpolator;
            this.interp = this.interpB;
            this.interpB.setROIBounds(this.roiBounds);
            if (destNod == null) {
                destNod = new double[]{this.interpB.getDestinationNoData()};
            }
        } else if (this.interpolator instanceof InterpolationBicubic) {
            this.isBicubicNew = true;
            this.interpBN = (InterpolationBicubic)this.interpolator;
            this.interp = this.interpBN;
            this.interpBN.setROIBounds(this.roiBounds);
            if (destNod == null) {
                destNod = new double[]{this.interpBN.getDestinationNoData()};
            }
        } else if (this.backgroundValues != null) {
            destNod = this.backgroundValues;
        }
        if (destNod == null) {
            destNod = new double[]{0.0};
        }
        this.destinationNoDataDouble = destNod;
        if (this.interpolator instanceof InterpolationNoData) {
            InterpolationNoData interpolationNoData = (InterpolationNoData)this.interpolator;
            interpolationNoData.setDestinationNoData(destNod[0]);
            if (nodata != null) {
                this.hasNoData = true;
                interpolationNoData.setNoDataRange(nodata);
            }
            interpolationNoData.setUseROIAccessor(this.useRoiAccessor);
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (this.interpolator instanceof InterpolationTable) {
            InterpolationTable interpTable = (InterpolationTable)this.interpolator;
            this.precisionBits = interpTable.getPrecisionBits();
        }
        this.one = 1 << this.subsampleBits;
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        SampleModel sm = source.getSampleModel();
        switch (sm.getDataType()) {
            case 0: {
                this.destinationNoDataByte = new byte[1];
                this.destinationNoDataByte[0] = (byte)((byte)this.destinationNoDataDouble[0] & 0xFF);
                break;
            }
            case 1: {
                this.destinationNoDataUShort = new short[1];
                this.destinationNoDataUShort[0] = (short)((short)this.destinationNoDataDouble[0] & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = new short[1];
                this.destinationNoDataShort[0] = (short)this.destinationNoDataDouble[0];
                break;
            }
            case 3: {
                this.destinationNoDataInt = new int[1];
                this.destinationNoDataInt[0] = (int)this.destinationNoDataDouble[0];
                break;
            }
            case 4: {
                this.destinationNoDataFloat = new float[1];
                this.destinationNoDataFloat[0] = (float)this.destinationNoDataDouble[0];
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        this.isBinary = sm instanceof MultiPixelPackedSampleModel && sm.getSampleSize(0) == 1 && (sm.getDataType() == 0 || sm.getDataType() == 1 || sm.getDataType() == 3);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        Number[] xfracvalues = null;
        Number[] yfracvalues = null;
        int[] yposRoi = null;
        Integer roiScanlineStride = null;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        RandomIter roiIter = null;
        if (this.hasROI) {
            if (this.useRoiAccessor) {
                roi = this.srcROIImage.getBounds().contains(srcRect) ? this.srcROIImage.getData(srcRect) : this.srcROIImgExt.getData(srcRect);
                roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
                roiScanlineStride = roiAccessor.getScanlineStride();
                yposRoi = new int[dheight];
            } else {
                roiIter = RandomIterFactory.create((RenderedImage)this.srcROIImgExt, (Rectangle)this.roiRect, (boolean)true, (boolean)true);
            }
        }
        this.dataType = dest.getSampleModel().getDataType();
        yfracvalues = new Number[dheight];
        xfracvalues = new Number[dwidth];
        this.preComputePositions(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracvalues, yfracvalues, roiScanlineStride, yposRoi);
        if (this.isBinary) {
            this.computeLoopBynary(srcAccessor, source, dest, destRect, xpos, ypos, yposRoi, xfracvalues, yfracvalues, roi, yposRoi, srcRect.x, srcRect.y, roiIter);
        } else if (this.hasROI) {
            this.computeLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracvalues, yfracvalues, roiAccessor, roiIter, yposRoi);
        } else {
            this.computeLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracvalues, yfracvalues, null, null, null);
        }
    }

    private void preComputePositions(Rectangle destRect, int srcRectX, int srcRectY, int srcPixelStride, int srcScanlineStride, int[] xpos, int[] ypos, Number[] xfracvalues, Number[] yfracvalues, Integer roiScanlineStride, int[] yposRoi) {
        int i;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int dx = destRect.x;
        int dy = destRect.y;
        long syNum = dy;
        long syDenom = 1L;
        syNum = syNum * this.transYRationalDenom - this.transYRationalNum * syDenom;
        syNum = 2L * syNum + (syDenom *= this.transYRationalDenom);
        syDenom *= 2L;
        syNum *= this.invScaleYRationalNum;
        syDenom *= this.invScaleYRationalDenom;
        if (this.interpBN != null || this.interpB != null || this.interpolator instanceof InterpolationBilinear || this.interpolator instanceof InterpolationBicubic || this.interpolator instanceof InterpolationBicubic2) {
            syNum = 2L * syNum - syDenom;
            syDenom *= 2L;
        }
        int srcYInt = Rational.floor((long)syNum, (long)syDenom);
        long srcYFrac = syNum % syDenom;
        if (srcYInt < 0) {
            srcYFrac = syDenom + srcYFrac;
        }
        long commonYDenom = syDenom * this.invScaleYRationalDenom;
        srcYFrac *= this.invScaleYRationalDenom;
        long newInvScaleYFrac = this.invScaleYFrac * syDenom;
        long sxNum = dx;
        long sxDenom = 1L;
        sxNum = sxNum * this.transXRationalDenom - this.transXRationalNum * sxDenom;
        sxNum = 2L * sxNum + (sxDenom *= this.transXRationalDenom);
        sxDenom *= 2L;
        sxNum *= this.invScaleXRationalNum;
        sxDenom *= this.invScaleXRationalDenom;
        if (this.interpBN != null || this.interpB != null || this.interpolator instanceof InterpolationBilinear || this.interpolator instanceof InterpolationBicubic || this.interpolator instanceof InterpolationBicubic2) {
            sxNum = 2L * sxNum - sxDenom;
            sxDenom *= 2L;
        }
        int srcXInt = Rational.floor((long)sxNum, (long)sxDenom);
        long srcXFrac = sxNum % sxDenom;
        if (srcXInt < 0) {
            srcXFrac = sxDenom + srcXFrac;
        }
        long commonXDenom = sxDenom * this.invScaleXRationalDenom;
        srcXFrac *= this.invScaleXRationalDenom;
        long newInvScaleXFrac = this.invScaleXFrac * sxDenom;
        for (i = 0; i < dwidth; ++i) {
            xpos[i] = this.isBinary ? srcXInt : (srcXInt - srcRectX) * srcPixelStride;
            xfracvalues[i] = this.dataType < 4 ? (Number)((int)(1.0f * (float)srcXFrac / (float)commonXDenom * (float)this.one)) : (Number)Float.valueOf(1.0f * (float)srcXFrac / (float)commonXDenom);
            srcXInt = (int)((long)srcXInt + this.invScaleXInt);
            if ((srcXFrac += newInvScaleXFrac) < commonXDenom) continue;
            ++srcXInt;
            srcXFrac -= commonXDenom;
        }
        for (i = 0; i < dheight; ++i) {
            ypos[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * srcScanlineStride;
            if (yposRoi != null) {
                yposRoi[i] = this.isBinary ? srcYInt : (srcYInt - srcRectY) * roiScanlineStride;
            }
            yfracvalues[i] = this.dataType < 4 ? (Number)((int)((float)srcYFrac / (float)commonYDenom * (float)this.one)) : (Number)Float.valueOf((float)srcYFrac / (float)commonYDenom);
            srcYInt = (int)((long)srcYInt + this.invScaleYInt);
            if ((srcYFrac += newInvScaleYFrac) < commonYDenom) continue;
            ++srcYInt;
            srcYFrac -= commonYDenom;
        }
    }

    private void computeLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, Number[] xfracvalues, Number[] yfracvalues, RasterAccessor roi, RandomIter roiIter, int[] yposRoi) {
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArraysByte = src.getByteDataArrays();
        short[][] srcDataArraysUshort = src.getShortDataArrays();
        short[][] srcDataArraysShort = src.getShortDataArrays();
        int[][] srcDataArraysInt = src.getIntDataArrays();
        float[][] srcDataArraysFloat = src.getFloatDataArrays();
        double[][] srcDataArraysDouble = src.getDoubleDataArrays();
        byte[][] dstDataArraysByte = dst.getByteDataArrays();
        short[][] dstDataArraysUshort = dst.getShortDataArrays();
        short[][] dstDataArraysShort = dst.getShortDataArrays();
        int[][] dstDataArraysInt = dst.getIntDataArrays();
        float[][] dstDataArraysFloat = dst.getFloatDataArrays();
        double[][] dstDataArraysDouble = dst.getDoubleDataArrays();
        byte[] dstDataByte = null;
        short[] dstDataUshort = null;
        short[] dstDataShort = null;
        int[] dstDataInt = null;
        float[] dstDataFloat = null;
        double[] dstDataDouble = null;
        byte[] srcDataByte = null;
        short[] srcDataUshort = null;
        short[] srcDataShort = null;
        int[] srcDataInt = null;
        float[] srcDataFloat = null;
        double[] srcDataDouble = null;
        int[][] samples = null;
        float[][] samplesf = null;
        double[][] samplesd = null;
        switch (this.dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                samples = new int[this.interp_height][this.interp_width];
                break;
            }
            case 4: {
                samplesf = new float[this.interp_height][this.interp_width];
                break;
            }
            case 5: {
                samplesd = new double[this.interp_height][this.interp_width];
                break;
            }
        }
        Number s = null;
        for (int k = 0; k < dnumBands; ++k) {
            switch (this.dataType) {
                case 0: {
                    srcDataByte = srcDataArraysByte[k];
                    dstDataByte = dstDataArraysByte[k];
                    break;
                }
                case 1: {
                    srcDataUshort = srcDataArraysUshort[k];
                    dstDataUshort = dstDataArraysUshort[k];
                    break;
                }
                case 2: {
                    srcDataShort = srcDataArraysShort[k];
                    dstDataShort = dstDataArraysShort[k];
                    break;
                }
                case 3: {
                    srcDataInt = srcDataArraysInt[k];
                    dstDataInt = dstDataArraysInt[k];
                    break;
                }
                case 4: {
                    srcDataFloat = srcDataArraysFloat[k];
                    dstDataFloat = dstDataArraysFloat[k];
                    break;
                }
                case 5: {
                    srcDataDouble = srcDataArraysDouble[k];
                    dstDataDouble = dstDataArraysDouble[k];
                    break;
                }
            }
            int dstlineOffset = dstBandOffsets[k];
            int bandOffset = bandOffsets[k];
            for (int j = 0; j < dheight; ++j) {
                int dstPixelOffset = dstlineOffset;
                int posy = ypos[j] + bandOffset;
                Integer posyROI = null;
                if (yposRoi != null && roi != null) {
                    posyROI = yposRoi[j];
                }
                for (int i = 0; i < dwidth; ++i) {
                    int posx = xpos[i];
                    Number[] fracValues = new Number[]{xfracvalues[i], yfracvalues[j]};
                    if (this.interpBN != null) {
                        s = this.interpBN.interpolate(src, k, dnumBands, posx, posy, fracValues, posyROI, roi, roiIter, false);
                    } else if (this.interpB != null) {
                        s = this.interpB.interpolate(src, k, dnumBands, posx, posy, fracValues, posyROI, roi, roiIter, false);
                    } else if (this.interpN != null) {
                        s = this.interpN.interpolate(src, k, dnumBands, posx, posy, posyROI, roi, roiIter, false);
                    } else if (this.interpolator != null) {
                        int start = this.interp_left * srcPixelStride + this.interp_top * srcScanlineStride;
                        start = posx + posy - start;
                        int countH = 0;
                        int countV = 0;
                        for (int yloop = 0; yloop < this.interp_height; ++yloop) {
                            int startY = start;
                            for (int xloop = 0; xloop < this.interp_width; ++xloop) {
                                switch (this.dataType) {
                                    case 0: {
                                        samples[countV][countH++] = srcDataByte[start] & 0xFF;
                                        break;
                                    }
                                    case 1: {
                                        samples[countV][countH++] = srcDataUshort[start] & 0xFFFF;
                                        break;
                                    }
                                    case 2: {
                                        samples[countV][countH++] = srcDataShort[start];
                                        break;
                                    }
                                    case 3: {
                                        samples[countV][countH++] = srcDataInt[start];
                                        break;
                                    }
                                    case 4: {
                                        samplesf[countV][countH++] = srcDataFloat[start];
                                        break;
                                    }
                                    case 5: {
                                        samplesd[countV][countH++] = srcDataDouble[start];
                                        break;
                                    }
                                }
                                start += srcPixelStride;
                            }
                            ++countV;
                            countH = 0;
                            start = startY + srcScanlineStride;
                        }
                        switch (this.dataType) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                s = this.interp.interpolate(samples, fracValues[0].intValue(), fracValues[1].intValue());
                                break;
                            }
                            case 4: {
                                s = Float.valueOf(this.interp.interpolate(samplesf, fracValues[0].floatValue(), fracValues[1].floatValue()));
                                break;
                            }
                            case 5: {
                                s = this.interp.interpolate(samplesd, fracValues[0].floatValue(), fracValues[1].floatValue());
                                break;
                            }
                        }
                    } else {
                        throw new UnsupportedOperationException("Scale operation cannot be performed without an interpolator");
                    }
                    switch (this.dataType) {
                        case 0: {
                            dstDataByte[dstPixelOffset] = (byte)(s.byteValue() & 0xFF);
                            break;
                        }
                        case 1: {
                            dstDataUshort[dstPixelOffset] = (short)(s.shortValue() & 0xFFFF);
                            break;
                        }
                        case 2: {
                            dstDataShort[dstPixelOffset] = s.shortValue();
                            break;
                        }
                        case 3: {
                            dstDataInt[dstPixelOffset] = s.intValue();
                            break;
                        }
                        case 4: {
                            dstDataFloat[dstPixelOffset] = s.floatValue();
                            break;
                        }
                        case 5: {
                            dstDataDouble[dstPixelOffset] = s.doubleValue();
                            break;
                        }
                    }
                    dstPixelOffset += dstPixelStride;
                }
                dstlineOffset += dstScanlineStride;
            }
        }
    }

    private void computeLoopBynary(RasterAccessor src, Raster source, WritableRaster dest, Rectangle destRect, int[] xvalues, int[] yvalues, int[] yvaluesROI, Number[] xfracvalues, Number[] yfracvalues, Raster roi, int[] posYROI, int srcRectX, int srcRectY, RandomIter roiIter) {
        int dx = destRect.x;
        int dy = destRect.y;
        int dwidth = destRect.width;
        int dheight = destRect.height;
        MultiPixelPackedSampleModel sourceSM = (MultiPixelPackedSampleModel)source.getSampleModel();
        int sourceTransX = source.getSampleModelTranslateX();
        int sourceTransY = source.getSampleModelTranslateY();
        int sourceDataBitOffset = sourceSM.getDataBitOffset();
        int sourceScanlineStride = sourceSM.getScanlineStride();
        int sourcePixelStride = sourceSM.getPixelBitStride();
        MultiPixelPackedSampleModel roiSM = null;
        int roiTransY = 0;
        int roiScanlineStride = 0;
        DataBuffer roiDB = null;
        if (roi != null) {
            roiSM = (MultiPixelPackedSampleModel)roi.getSampleModel();
            roiTransY = roi.getSampleModelTranslateY();
            roiScanlineStride = roiSM.getScanlineStride();
            roiDB = roi.getDataBuffer();
        }
        MultiPixelPackedSampleModel destSM = (MultiPixelPackedSampleModel)dest.getSampleModel();
        int destTransX = dest.getSampleModelTranslateX();
        int destTransY = dest.getSampleModelTranslateY();
        int destDataBitOffset = destSM.getDataBitOffset();
        int destScanlineStride = destSM.getScanlineStride();
        int[] sIntShortBytenum = new int[dwidth];
        int[] sshift = new int[dwidth];
        Number[] destData = null;
        Number[] sourceData = null;
        DataBuffer destDB = dest.getDataBuffer();
        DataBuffer sourceDB = source.getDataBuffer();
        byte[] sourceDataB = null;
        byte[] destDataB = null;
        short[] sourceDataS = null;
        short[] destDataS = null;
        int[] sourceDataI = null;
        int[] destDataI = null;
        int[] roiData = null;
        int bitshift = 0;
        int bitNum = 0;
        this.dataType = destSM.getDataType();
        switch (this.dataType) {
            case 0: {
                int ii;
                DataBufferByte destDBByte = (DataBufferByte)destDB;
                DataBufferByte sourceDBByte = (DataBufferByte)sourceDB;
                sourceDataB = sourceDBByte.getData();
                destDataB = destDBByte.getData();
                destData = new Number[destDataB.length];
                for (ii = 0; ii < destDataB.length; ++ii) {
                    destData[ii] = destDataB[ii];
                }
                sourceData = new Number[sourceDataB.length];
                for (ii = 0; ii < sourceDataB.length; ++ii) {
                    sourceData[ii] = sourceDataB[ii];
                }
                bitshift = 3;
                bitNum = 7;
                break;
            }
            case 1: 
            case 2: {
                int ii;
                DataBufferUShort destDBShort = (DataBufferUShort)destDB;
                DataBufferUShort sourceDBShort = (DataBufferUShort)sourceDB;
                sourceDataS = sourceDBShort.getData();
                destDataS = destDBShort.getData();
                destData = new Number[destDataS.length];
                for (ii = 0; ii < destDataS.length; ++ii) {
                    destData[ii] = destDataS[ii];
                }
                sourceData = new Number[sourceDataS.length];
                for (ii = 0; ii < sourceDataS.length; ++ii) {
                    sourceData[ii] = sourceDataS[ii];
                }
                bitshift = 4;
                bitNum = 15;
                break;
            }
            case 3: {
                int ii;
                DataBufferInt destDBInt = (DataBufferInt)destDB;
                DataBufferInt sourceDBInt = (DataBufferInt)sourceDB;
                sourceDataI = sourceDBInt.getData();
                destDataI = destDBInt.getData();
                destData = new Number[destDataI.length];
                for (ii = 0; ii < destDataI.length; ++ii) {
                    destData[ii] = destDataI[ii];
                }
                sourceData = new Number[sourceDataI.length];
                for (ii = 0; ii < sourceDataI.length; ++ii) {
                    sourceData[ii] = sourceDataI[ii];
                }
                bitshift = 5;
                bitNum = 31;
            }
        }
        if (roi != null) {
            DataBufferByte roiDBByte = (DataBufferByte)roiDB;
            byte[] roiDataB = roiDBByte.getData();
            roiData = new int[roiDataB.length];
            for (int ii = 0; ii < roiDataB.length; ++ii) {
                roiData[ii] = roiDataB[ii];
            }
        }
        int sourceDBOffset = sourceDB.getOffset();
        int roiDBOffset = 0;
        int destDBOffset = destDB.getOffset();
        if (roi != null) {
            roiDBOffset = roiDB.getOffset();
        }
        for (int i = 0; i < dwidth; ++i) {
            int x = xvalues[i];
            int sbitnum = sourceDataBitOffset + (x - sourceTransX);
            sIntShortBytenum[i] = sbitnum >> bitshift;
            sshift[i] = bitNum - (sbitnum & bitNum);
        }
        int destYOffset = (dy - destTransY) * destScanlineStride + destDBOffset;
        int dbitnum = destDataBitOffset + (dx - destTransX);
        int[] coordinates = new int[2];
        for (int j = 0; j < dheight; ++j) {
            int y = yvalues[j];
            int yfrac = yfracvalues[j].intValue();
            int sourceYOffset = (y - sourceTransY) * sourceScanlineStride + sourceDBOffset;
            dbitnum = destDataBitOffset + (dx - destTransX);
            int yROI = 0;
            int roiYOffset = 0;
            if (roi != null) {
                yROI = posYROI[j];
                roiYOffset = (yROI - roiTransY) * roiScanlineStride + roiDBOffset;
            }
            for (int i = 0; i < dwidth; ++i) {
                int s;
                int xfrac = xfracvalues[i].intValue();
                int x = xvalues[i];
                coordinates[0] = src.getX() + (x - srcRectX) * sourcePixelStride;
                coordinates[1] = src.getY() + (y - srcRectY) * sourceScanlineStride / sourceScanlineStride;
                int xNextBitNo = sourceDataBitOffset + (x + 1 - sourceTransX);
                if (this.interpN != null) {
                    s = this.interpN.interpolateBinary(xNextBitNo, sourceData, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride, roiIter);
                } else if (this.interpB != null) {
                    s = this.interpB.interpolateBinary(xNextBitNo, sourceData, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride, roiIter);
                } else if (this.interpBN != null) {
                    s = this.interpBN.interpolateBinary(xNextBitNo, sourceData, xfrac, yfrac, sourceYOffset, sourceScanlineStride, coordinates, roiData, roiYOffset, roiScanlineStride, roiIter);
                } else {
                    throw new UnsupportedOperationException("Binary interpolation not supported by interpolator different fromthe ones that belong to InterpolationNearest2, InterpolationBilinear2 or InterpolationBicubicclass.");
                }
                int destByteShortIntNum = dbitnum >> bitshift;
                int destBitShift = bitNum - (dbitnum & bitNum);
                if (s == 1) {
                    switch (this.dataType) {
                        case 0: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataB[n] = (byte)(destDataB[n] | 1 << destBitShift);
                            break;
                        }
                        case 1: 
                        case 2: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataS[n] = (short)(destDataS[n] | 1 << destBitShift);
                            break;
                        }
                        case 3: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataI[n] = destDataI[n] | 1 << destBitShift;
                        }
                    }
                } else {
                    switch (this.dataType) {
                        case 0: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataB[n] = (byte)(destDataB[n] & 255 - (1 << destBitShift));
                            break;
                        }
                        case 1: 
                        case 2: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataS[n] = (short)(destDataS[n] & 65535 - (1 << destBitShift));
                            break;
                        }
                        case 3: {
                            int n = destYOffset + destByteShortIntNum;
                            destDataI[n] = destDataI[n] & -1 - (1 << destBitShift);
                        }
                    }
                }
                ++dbitnum;
            }
            destYOffset += destScanlineStride;
        }
    }
}

