/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReader;
import com.sun.media.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import it.geosolutions.jaiext.scale.ScaleDescriptor;
import it.geosolutions.jaiext.scale.TestScale;
import it.geosolutions.jaiext.testclasses.TestBase;
import it.geosolutions.jaiext.testclasses.TestData;
import it.geosolutions.rendered.viewer.RenderedImageBrowser;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.media.jai.BorderExtender;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RenderedOp;
import org.junit.Assert;
import org.junit.Test;

public class ImageRGBTest
extends TestScale {
    private int imageWidth;
    private int imageHeigth;
    protected double destinationNoData = 255.0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterpolationScale() throws Throwable {
        boolean bicubic2Disabled = true;
        boolean useROIAccessor = true;
        boolean roiUsed = true;
        TIFFImageReader reader = null;
        ImageInputStreamImpl stream_in = null;
        try {
            reader = (TIFFImageReader)new TIFFImageReaderSpi().createReaderInstance();
            File inputFile = TestData.file((Object)((Object)this), (String)"testImageLittle.tif");
            stream_in = new FileImageInputStream(inputFile);
            reader.setInput((Object)stream_in);
            RenderedImage image = reader.readAsRenderedImage(0, null);
            this.imageWidth = image.getWidth();
            this.imageHeigth = image.getHeight();
            int dataType = image.getSampleModel().getDataType();
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.MAGNIFY, dataType, TestBase.InterpolationType.NEAREST_INTERP);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.MAGNIFY, dataType, TestBase.InterpolationType.BILINEAR_INTERP);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.MAGNIFY, dataType, TestBase.InterpolationType.BICUBIC_INTERP);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.REDUCTION, dataType, TestBase.InterpolationType.NEAREST_INTERP);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.REDUCTION, dataType, TestBase.InterpolationType.BILINEAR_INTERP);
            this.testImage(image, useROIAccessor, roiUsed, bicubic2Disabled, TestBase.ScaleType.REDUCTION, dataType, TestBase.InterpolationType.BICUBIC_INTERP);
        }
        finally {
            try {
                if (reader != null) {
                    reader.dispose();
                }
            }
            catch (Exception e) {}
            try {
                if (stream_in != null) {
                    stream_in.flush();
                    ((FileImageInputStream)stream_in).close();
                }
            }
            catch (Exception e) {}
        }
    }

    protected ROIShape roiCreation() {
        int roiHeight = this.imageHeigth / 2;
        int roiWidth = this.imageWidth / 2;
        Rectangle roiBound = new Rectangle(0, 0, roiWidth, roiHeight);
        ROIShape roi = new ROIShape((Shape)roiBound);
        return roi;
    }

    private void testImage(RenderedImage sourceImage, boolean useROIAccessor, boolean roiUsed, boolean bicubic2Disabled, TestBase.ScaleType scaleValue, int dataType, TestBase.InterpolationType interpType) {
        if (scaleValue == TestBase.ScaleType.REDUCTION) {
            this.scaleX = 0.5f;
            this.scaleY = 0.5f;
        } else {
            this.scaleX = 1.5f;
            this.scaleY = 1.5f;
        }
        RenderingHints hints = null;
        ROIShape roi = null;
        if (roiUsed) {
            if (useROIAccessor) {
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)0));
            }
            roi = this.roiCreation();
        } else {
            useROIAccessor = false;
        }
        InterpolationNearest interp = null;
        switch (interpType) {
            case NEAREST_INTERP: {
                interp = new InterpolationNearest();
                break;
            }
            case BILINEAR_INTERP: {
                interp = new InterpolationBilinear(8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
            case BICUBIC_INTERP: {
                interp = new InterpolationBicubic(8);
                if (hints != null) {
                    hints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1)));
                    break;
                }
                hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                break;
            }
            default: {
                throw new IllegalArgumentException("...");
            }
        }
        RenderedOp destinationIMG = ScaleDescriptor.create((RenderedImage)sourceImage, (Float)Float.valueOf(this.scaleX), (Float)Float.valueOf(this.scaleY), (Float)Float.valueOf(this.transX), (Float)Float.valueOf(this.transY), (Interpolation)interp, (ROI)roi, (Boolean)useROIAccessor, null, null, (RenderingHints)hints);
        if (INTERACTIVE && TEST_SELECTOR.intValue() == interpType.getType() && INVERSE_SCALE.intValue() == scaleValue.getType()) {
            RenderedImageBrowser.showChain((RenderedImage)destinationIMG, (boolean)false, (boolean)roiUsed);
            try {
                System.in.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            ((PlanarImage)destinationIMG).getTiles();
        }
        Raster simpleTile = destinationIMG.getTile(destinationIMG.getMinTileX(), destinationIMG.getMinTileY());
        int tileWidth = simpleTile.getWidth();
        int tileHeight = simpleTile.getHeight();
        int minValue = Integer.MAX_VALUE;
        int maxValue = Integer.MIN_VALUE;
        for (int i = 0; i < tileHeight; ++i) {
            for (int j = 0; j < tileWidth; ++j) {
                int value = simpleTile.getSample(j, i, 0);
                if (value > maxValue) {
                    maxValue = value;
                }
                if (value >= minValue) continue;
                minValue = value;
            }
        }
        Assert.assertFalse((minValue == maxValue ? 1 : 0) != 0);
        Assert.assertFalse((minValue == Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertFalse((maxValue == Integer.MIN_VALUE ? 1 : 0) != 0);
        PlanarImage planarIMG = (PlanarImage)destinationIMG;
        int imgWidthROI = destinationIMG.getWidth() / 2 - 1;
        int imgHeightROI = destinationIMG.getHeight() / 2 - 1;
        int tileInROIx = planarIMG.XToTileX(imgWidthROI);
        int tileInROIy = planarIMG.YToTileY(imgHeightROI);
        Raster testTile = destinationIMG.getTile(tileInROIx, tileInROIy);
        int value = testTile.getSample(testTile.getMinX() + 2, testTile.getMinY() + 2, 0);
        Assert.assertFalse((value == (int)this.destinationNoData ? 1 : 0) != 0);
        Assert.assertEquals((long)((int)((float)this.imageWidth * this.scaleX)), (long)destinationIMG.getWidth());
        Assert.assertEquals((long)((int)((float)this.imageHeigth * this.scaleY)), (long)destinationIMG.getHeight());
        if (destinationIMG instanceof RenderedOp) {
            destinationIMG.dispose();
        }
    }
}

