/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationBilinear;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class ScaleBilinearOpImage
extends ScaleOpImage {
    protected boolean dataINT = false;
    protected final byte[] byteLookupTable = new byte[256];
    protected InterpolationBilinear interpB = null;

    public ScaleBilinearOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        Range nod = nodata;
        Double destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues[0];
        }
        if (interp instanceof InterpolationBilinear) {
            this.isBilinearNew = true;
            this.interpB = (InterpolationBilinear)interp;
            this.interp = this.interpB;
            this.interpB.setROIdata(this.roiBounds, this.roiIter);
            if (nod == null) {
                nod = this.interpB.getNoDataRange();
            }
            if (destNod == null) {
                destNod = this.interpB.getDestinationNoData();
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues[0];
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift = 29 - this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        this.destinationNoDataByte = (byte)((byte)this.destinationNoDataDouble & 0xFF);
        this.destinationNoDataUShort = (short)((short)this.destinationNoDataDouble & 0xFFFF);
        this.destinationNoDataShort = (short)this.destinationNoDataDouble;
        this.destinationNoDataInt = (int)this.destinationNoDataDouble;
        this.destinationNoDataFloat = (float)this.destinationNoDataDouble;
        boolean bl = this.dataINT = srcDataType == 0;
        if (this.hasNoData) {
            for (int i = 0; i < this.byteLookupTable.length; ++i) {
                byte value = (byte)i;
                this.byteLookupTable[i] = this.noData.contains(value) ? this.destinationNoDataByte : value;
            }
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources, dest, destRect, null);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect, Raster[] rois) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        if (this.useRoiAccessor) {
            roi = rois[0];
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            roiScanlineStride = roiAccessor.getScanlineStride();
            yposRoi = new int[dheight];
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        float[] xfracValuesFloat = new float[dwidth];
        float[] yfracValuesFloat = new float[dheight];
        this.dataType = dest.getSampleModel().getDataType();
        if (this.dataType < 4) {
            this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        } else {
            this.preComputePositionsFloat(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiScanlineStride, yposRoi);
        }
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValuesFloat, yfracValuesFloat, roiAccessor, yposRoi, roiScanlineStride);
            }
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos] & 0xFF;
                        int s01 = srcData[pos + srcPixelStride] & 0xFF;
                        int s10 = srcData[pos + srcScanlineStride] & 0xFF;
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFF;
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (byte)(s & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos] & 0xFF;
                            int s01 = srcData[pos + srcPixelStride] & 0xFF;
                            int s10 = srcData[pos + srcScanlineStride] & 0xFF;
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFF;
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                            int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                            int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                            if (baseIndex > roiDataLength || w00 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            } else {
                                int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                dstData[dstPixelOffset] = (byte)(s & 0xFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    int s00 = srcData[posx + posy] & 0xFF;
                                    int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                                    int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                                    int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                                    int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                    int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                    int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                    dstData[dstPixelOffset] = (byte)(s & 0xFF);
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataByte;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            int w00 = 0;
            int w01 = 0;
            int w10 = 0;
            int w11 = 0;
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy] & 0xFF;
                        int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                        int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                        w00 = this.byteLookupTable[s00] == this.destinationNoDataByte ? 0 : 1;
                        w01 = this.byteLookupTable[s01] == this.destinationNoDataByte ? 0 : 1;
                        w10 = this.byteLookupTable[s10] == this.destinationNoDataByte ? 0 : 1;
                        w11 = this.byteLookupTable[s11] == this.destinationNoDataByte ? 0 : 1;
                        dstData[dstPixelOffset] = w00 + w01 + w10 + w11 == 0 ? this.destinationNoDataByte : (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int baseIndex;
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy] & 0xFF;
                        int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                        int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        } else {
                            w00 = this.byteLookupTable[s00] == this.destinationNoDataByte ? 0 : 1;
                            w01 = this.byteLookupTable[s01] == this.destinationNoDataByte ? 0 : 1;
                            w10 = this.byteLookupTable[s10] == this.destinationNoDataByte ? 0 : 1;
                            w11 = this.byteLookupTable[s11] == this.destinationNoDataByte ? 0 : 1;
                            dstData[dstPixelOffset] = (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                int s00 = srcData[posx + posy] & 0xFF;
                                int s01 = srcData[posx + srcPixelStride + posy] & 0xFF;
                                int s10 = srcData[posx + posy + srcScanlineStride] & 0xFF;
                                int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFF;
                                w00 = this.byteLookupTable[s00] == this.destinationNoDataByte ? 0 : 1;
                                w01 = this.byteLookupTable[s01] == this.destinationNoDataByte ? 0 : 1;
                                w10 = this.byteLookupTable[s10] == this.destinationNoDataByte ? 0 : 1;
                                w11 = this.byteLookupTable[s11] == this.destinationNoDataByte ? 0 : 1;
                                dstData[dstPixelOffset] = (byte)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFF);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos] & 0xFFFF;
                        int s01 = srcData[pos + srcPixelStride] & 0xFFFF;
                        int s10 = srcData[pos + srcScanlineStride] & 0xFFFF;
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFFFF;
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos] & 0xFFFF;
                            int s01 = srcData[pos + srcPixelStride] & 0xFFFF;
                            int s10 = srcData[pos + srcScanlineStride] & 0xFFFF;
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride] & 0xFFFF;
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFFFF : 0;
                            int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFFFF : 0;
                            int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFFFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFFFF : 0;
                            if (baseIndex > roiDataLength || w00 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            } else {
                                int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    int s00 = srcData[posx + posy] & 0xFFFF;
                                    int s01 = srcData[posx + srcPixelStride + posy] & 0xFFFF;
                                    int s10 = srcData[posx + posy + srcScanlineStride] & 0xFFFF;
                                    int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF;
                                    int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                    int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                    int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                    dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataUShort;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                        short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                        short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                        short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                        int w00 = 1;
                        int w01 = 1;
                        int w10 = 1;
                        int w11 = 1;
                        if (this.noData.contains(s00)) {
                            w00 = 0;
                        }
                        if (this.noData.contains(s01)) {
                            w01 = 0;
                        }
                        if (this.noData.contains(s10)) {
                            w10 = 0;
                        }
                        if (this.noData.contains(s11)) {
                            w11 = 0;
                        }
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataUShort : (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w11;
                        int baseIndex;
                        int posx = xpos[i];
                        short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                        short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                        short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                        short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        int w00 = w00index < roiDataLength ? roiDataArray[w00index] & 0xFFFF : 0;
                        int w01 = w01index < roiDataLength ? roiDataArray[w01index] & 0xFFFF : 0;
                        int w10 = w10index < roiDataLength ? roiDataArray[w10index] & 0xFFFF : 0;
                        int n = w11 = w11index < roiDataLength ? roiDataArray[w11index] & 0xFFFF : 0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        } else {
                            w00 = this.noData.contains(s00) ? 0 : 1;
                            w01 = this.noData.contains(s01) ? 0 : 1;
                            w10 = this.noData.contains(s10) ? 0 : 1;
                            w11 = this.noData.contains(s11) ? 0 : 1;
                            dstData[dstPixelOffset] = (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                short s00 = (short)(srcData[posx + posy] & 0xFFFF);
                                short s01 = (short)(srcData[posx + srcPixelStride + posy] & 0xFFFF);
                                short s10 = (short)(srcData[posx + posy + srcScanlineStride] & 0xFFFF);
                                short s11 = (short)(srcData[posx + srcPixelStride + posy + srcScanlineStride] & 0xFFFF);
                                w00 = this.noData.contains(s00) ? 0 : 1;
                                w01 = this.noData.contains(s01) ? 0 : 1;
                                w10 = this.noData.contains(s10) ? 0 : 1;
                                w11 = this.noData.contains(s11) ? 0 : 1;
                                dstData[dstPixelOffset] = (short)(this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]) & 0xFFFF);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short s00 = srcData[pos];
                        short s01 = srcData[pos + srcPixelStride];
                        short s10 = srcData[pos + srcScanlineStride];
                        short s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstData[dstPixelOffset] = (short)s;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            short s00 = srcData[pos];
                            short s01 = srcData[pos + srcPixelStride];
                            short s10 = srcData[pos + srcScanlineStride];
                            short s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            if (baseIndex > roiDataLength || w00 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            } else {
                                int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                dstData[dstPixelOffset] = (short)s;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    short s00 = srcData[posx + posy];
                                    short s01 = srcData[posx + srcPixelStride + posy];
                                    short s10 = srcData[posx + posy + srcScanlineStride];
                                    short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                    int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                                    int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                                    int s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                                    dstData[dstPixelOffset] = (short)s;
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataShort;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        short s00 = srcData[posx + posy];
                        short s01 = srcData[posx + srcPixelStride + posy];
                        short s10 = srcData[posx + posy + srcScanlineStride];
                        short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00 = 1;
                        int w01 = 1;
                        int w10 = 1;
                        int w11 = 1;
                        if (this.noData.contains(s00)) {
                            w00 = 0;
                        }
                        if (this.noData.contains(s01)) {
                            w01 = 0;
                        }
                        if (this.noData.contains(s10)) {
                            w10 = 0;
                        }
                        if (this.noData.contains(s11)) {
                            w11 = 0;
                        }
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataShort : (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        short s00 = srcData[posx + posy];
                        short s01 = srcData[posx + srcPixelStride + posy];
                        short s10 = srcData[posx + posy + srcScanlineStride];
                        short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : 1;
                            w01 = this.noData.contains(s01) ? (byte)0 : 1;
                            w10 = this.noData.contains(s10) ? (byte)0 : 1;
                            w11 = this.noData.contains(s11) ? (byte)0 : 1;
                            dstData[dstPixelOffset] = (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                short s00 = srcData[posx + posy];
                                short s01 = srcData[posx + srcPixelStride + posy];
                                short s10 = srcData[posx + posy + srcScanlineStride];
                                short s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                w00 = this.noData.contains(s00) ? 0 : 1;
                                w01 = this.noData.contains(s01) ? 0 : 1;
                                w10 = this.noData.contains(s10) ? 0 : 1;
                                w11 = this.noData.contains(s11) ? 0 : 1;
                                dstData[dstPixelOffset] = (short)this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int s00 = srcData[pos];
                        int s01 = srcData[pos + srcPixelStride];
                        int s10 = srcData[pos + srcScanlineStride];
                        int s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        int s0 = (s01 - s00) * xfrac[i] + (s00 << this.subsampleBits);
                        int s1 = (s11 - s10) * xfrac[i] + (s10 << this.subsampleBits);
                        dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int s00 = srcData[pos];
                            int s01 = srcData[pos + srcPixelStride];
                            int s10 = srcData[pos + srcScanlineStride];
                            int s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            dstData[dstPixelOffset] = baseIndex > roiDataLength || w00 == 0 ? this.destinationNoDataInt : (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataInt : this.computeValue(s00, s01, s10, s11, 1, 1, 1, 1, xfrac[i], yfrac[j]));
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    int s00 = srcData[posx + posy];
                                    int s01 = srcData[posx + srcPixelStride + posy];
                                    int s10 = srcData[posx + posy + srcScanlineStride];
                                    int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                    dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, 1, 1, 1, 1, xfrac[i], yfrac[j]);
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataInt;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy];
                        int s01 = srcData[posx + srcPixelStride + posy];
                        int s10 = srcData[posx + posy + srcScanlineStride];
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00 = 1;
                        int w01 = 1;
                        int w10 = 1;
                        int w11 = 1;
                        if (this.noData.contains(s00)) {
                            w00 = 0;
                        }
                        if (this.noData.contains(s01)) {
                            w01 = 0;
                        }
                        if (this.noData.contains(s10)) {
                            w10 = 0;
                        }
                        if (this.noData.contains(s11)) {
                            w11 = 0;
                        }
                        dstData[dstPixelOffset] = w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0 ? this.destinationNoDataInt : this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        int s00 = srcData[posx + posy];
                        int s01 = srcData[posx + srcPixelStride + posy];
                        int s10 = srcData[posx + posy + srcScanlineStride];
                        int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : 1;
                            w01 = this.noData.contains(s01) ? (byte)0 : 1;
                            w10 = this.noData.contains(s10) ? (byte)0 : 1;
                            w11 = this.noData.contains(s11) ? (byte)0 : 1;
                            dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                int s00 = srcData[posx + posy];
                                int s01 = srcData[posx + srcPixelStride + posy];
                                int s10 = srcData[posx + posy + srcScanlineStride];
                                int s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                w00 = this.noData.contains(s00) ? 0 : 1;
                                w01 = this.noData.contains(s01) ? 0 : 1;
                                w10 = this.noData.contains(s10) ? 0 : 1;
                                w11 = this.noData.contains(s11) ? 0 : 1;
                                dstData[dstPixelOffset] = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j]);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, float[] xfrac, float[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        float s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float s00 = srcData[pos];
                        float s01 = srcData[pos + srcPixelStride];
                        float s10 = srcData[pos + srcScanlineStride];
                        float s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        float s0 = (s01 - s00) * xfrac[i] + s00;
                        float s1 = (s11 - s10) * xfrac[i] + s10;
                        dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + s0;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            float s00 = srcData[pos];
                            float s01 = srcData[pos + srcPixelStride];
                            float s10 = srcData[pos + srcScanlineStride];
                            float s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            if (baseIndex > roiDataLength || w00 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            } else {
                                float s;
                                float s0 = (s01 - s00) * xfrac[i] + s00;
                                float s1 = (s11 - s10) * xfrac[i] + s10;
                                dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + s0;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    float s;
                                    float s00 = srcData[posx + posy];
                                    float s01 = srcData[posx + srcPixelStride + posy];
                                    float s10 = srcData[posx + posy + srcScanlineStride];
                                    float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                    float s0 = (s01 - s00) * xfrac[i] + s00;
                                    float s1 = (s11 - s10) * xfrac[i] + s10;
                                    dstData[dstPixelOffset] = s = (s1 - s0) * yfrac[j] + s0;
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataFloat;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        float s00 = srcData[posx + posy];
                        float s01 = srcData[posx + srcPixelStride + posy];
                        float s10 = srcData[posx + posy + srcScanlineStride];
                        float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        boolean w00 = true;
                        boolean w01 = true;
                        boolean w10 = true;
                        boolean w11 = true;
                        if (this.noData.contains(s00)) {
                            w00 = false;
                        }
                        if (this.noData.contains(s01)) {
                            w01 = false;
                        }
                        if (this.noData.contains(s10)) {
                            w10 = false;
                        }
                        if (this.noData.contains(s11)) {
                            w11 = false;
                        }
                        dstData[dstPixelOffset] = !w00 && !w01 && !w10 && !w11 ? this.destinationNoDataFloat : (float)this.computeValueDouble(s00, s01, s10, s11, (double)w00, (double)w01, (double)w10, (double)w11, xfrac[i], yfrac[j], this.dataType);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        float s00 = srcData[posx + posy];
                        float s01 = srcData[posx + srcPixelStride + posy];
                        float s10 = srcData[posx + posy + srcScanlineStride];
                        float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : 1;
                            w01 = this.noData.contains(s01) ? (byte)0 : 1;
                            w10 = this.noData.contains(s10) ? (byte)0 : 1;
                            w11 = this.noData.contains(s11) ? (byte)0 : 1;
                            dstData[dstPixelOffset] = (float)this.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], this.dataType);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                float s00 = srcData[posx + posy];
                                float s01 = srcData[posx + srcPixelStride + posy];
                                float s10 = srcData[posx + posy + srcScanlineStride];
                                float s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                w00 = this.noData.contains(s00) ? 0 : 1;
                                w01 = this.noData.contains(s01) ? 0 : 1;
                                w10 = this.noData.contains(s10) ? 0 : 1;
                                w11 = this.noData.contains(s11) ? 0 : 1;
                                dstData[dstPixelOffset] = (float)this.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], this.dataType);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, float[] xfrac, float[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        double s;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double s00 = srcData[pos];
                        double s01 = srcData[pos + srcPixelStride];
                        double s10 = srcData[pos + srcScanlineStride];
                        double s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                        double s0 = (s01 - s00) * (double)xfrac[i] + s00;
                        double s1 = (s11 - s10) * (double)xfrac[i] + s10;
                        dstData[dstPixelOffset] = s = (s1 - s0) * (double)yfrac[j] + s0;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            byte w11;
                            int baseIndex;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            double s00 = srcData[pos];
                            double s01 = srcData[pos + srcPixelStride];
                            double s10 = srcData[pos + srcScanlineStride];
                            double s11 = srcData[pos + srcPixelStride + srcScanlineStride];
                            int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                            int w01index = baseIndex + 1;
                            int w10index = baseIndex + roiScanlineStride;
                            int w11index = baseIndex + 1 + roiScanlineStride;
                            byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                            byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                            byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                            byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                            if (baseIndex > roiDataLength || w00 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            } else {
                                double s;
                                double s0 = (s01 - s00) * (double)xfrac[i] + s00;
                                double s1 = (s11 - s10) * (double)xfrac[i] + s10;
                                dstData[dstPixelOffset] = s = (s1 - s0) * (double)yfrac[j] + s0;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int y0;
                            int posx = xpos[i];
                            int x0 = src.getX() + posx / srcPixelStride;
                            if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                                int w00 = this.roiIter.getSample(x0, y0, 0);
                                int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                                int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                                int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                                if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                    double s;
                                    double s00 = srcData[posx + posy];
                                    double s01 = srcData[posx + srcPixelStride + posy];
                                    double s10 = srcData[posx + posy + srcScanlineStride];
                                    double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                    double s0 = (s01 - s00) * (double)xfrac[i];
                                    double s1 = (s11 - s10) * (double)xfrac[i];
                                    dstData[dstPixelOffset] = s = (s1 - s0) * (double)yfrac[j] + s0;
                                } else {
                                    dstData[dstPixelOffset] = this.destinationNoDataDouble;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        double s00 = srcData[posx + posy];
                        double s01 = srcData[posx + srcPixelStride + posy];
                        double s10 = srcData[posx + posy + srcScanlineStride];
                        double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        boolean w00 = true;
                        boolean w01 = true;
                        boolean w10 = true;
                        boolean w11 = true;
                        if (this.noData.contains(s00)) {
                            w00 = false;
                        }
                        if (this.noData.contains(s01)) {
                            w01 = false;
                        }
                        if (this.noData.contains(s10)) {
                            w10 = false;
                        }
                        if (this.noData.contains(s11)) {
                            w11 = false;
                        }
                        dstData[dstPixelOffset] = !w00 && !w01 && !w10 && !w11 ? this.destinationNoDataDouble : this.computeValueDouble(s00, s01, s10, s11, (double)w00, (double)w01, (double)w10, (double)w11, xfrac[i], yfrac[j], this.dataType);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        byte w11;
                        int baseIndex;
                        int posx = xpos[i];
                        double s00 = srcData[posx + posy];
                        double s01 = srcData[posx + srcPixelStride + posy];
                        double s10 = srcData[posx + posy + srcScanlineStride];
                        double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                        int w00index = baseIndex = posx / dnumBands + yposRoi[j];
                        int w01index = baseIndex + 1;
                        int w10index = baseIndex + roiScanlineStride;
                        int w11index = baseIndex + 1 + roiScanlineStride;
                        byte w00 = w00index < roiDataLength ? roiDataArray[w00index] : (byte)0;
                        byte w01 = w01index < roiDataLength ? roiDataArray[w01index] : (byte)0;
                        byte w10 = w10index < roiDataLength ? roiDataArray[w10index] : (byte)0;
                        byte by = w11 = w11index < roiDataLength ? roiDataArray[w11index] : (byte)0;
                        if (baseIndex > roiDataLength || w00 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        } else if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        } else {
                            w00 = this.noData.contains(s00) ? (byte)0 : 1;
                            w01 = this.noData.contains(s01) ? (byte)0 : 1;
                            w10 = this.noData.contains(s10) ? (byte)0 : 1;
                            w11 = this.noData.contains(s11) ? (byte)0 : 1;
                            dstData[dstPixelOffset] = this.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], this.dataType);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int w00 = this.roiIter.getSample(x0, y0, 0);
                            int w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                            int w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                            int w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) {
                                double s00 = srcData[posx + posy];
                                double s01 = srcData[posx + srcPixelStride + posy];
                                double s10 = srcData[posx + posy + srcScanlineStride];
                                double s11 = srcData[posx + srcPixelStride + posy + srcScanlineStride];
                                w00 = this.noData.contains(s00) ? 0 : 1;
                                w01 = this.noData.contains(s01) ? 0 : 1;
                                w10 = this.noData.contains(s10) ? 0 : 1;
                                w11 = this.noData.contains(s11) ? 0 : 1;
                                dstData[dstPixelOffset] = this.computeValueDouble(s00, s01, s10, s11, w00, w01, w10, w11, xfrac[i], yfrac[j], this.dataType);
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private int computeValue(int s00, int s01, int s10, int s11, byte weight, int xfrac, int yfrac) {
        int xfracCompl = this.one - xfrac;
        int yfracCompl = this.one - yfrac;
        switch (weight) {
            case 1: {
                int s0 = s00 * xfracCompl;
                return s0 * yfracCompl + this.round2 >> this.shift2;
            }
            case 2: {
                int s0 = s01 * xfrac;
                return s0 * yfracCompl + this.round2 >> this.shift2;
            }
            case 3: {
                if (this.dataINT) {
                    long s0L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits);
                    return (int)(s0L * (long)yfracCompl + (long)this.round2 >> this.shift2);
                }
                int s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                return s0 * yfracCompl + this.round2 >> this.shift2;
            }
            case 4: {
                int s1 = s10 * xfracCompl;
                return s1 * yfrac + this.round2 >> this.shift2;
            }
            case 5: {
                if (this.dataINT) {
                    long s0L = s00 * xfracCompl;
                    long s1L = s10 * xfracCompl;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s00 * xfracCompl;
                int s1 = s10 * xfracCompl;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 6: {
                if (this.dataINT) {
                    long s0L = s01 * xfrac;
                    long s1L = s10 * xfracCompl;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s01 * xfrac;
                int s1 = s10 * xfracCompl;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 7: {
                if (this.dataINT) {
                    long s0L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits);
                    long s1L = s10 * xfracCompl;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                int s1 = s10 * xfracCompl;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 8: {
                int s1 = s11 * xfrac;
                return s1 * yfrac + this.round2 >> this.shift2;
            }
            case 9: {
                if (this.dataINT) {
                    long s0L = s00 * xfracCompl;
                    long s1L = s11 * xfrac;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s00 * xfracCompl;
                int s1 = s11 * xfrac;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 10: {
                if (this.dataINT) {
                    long s0L = s01 * xfrac;
                    long s1L = s11 * xfrac;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s01 * xfrac;
                int s1 = s11 * xfrac;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 11: {
                if (this.dataINT) {
                    long s0L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits);
                    long s1L = s11 * xfrac;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                int s1 = s11 * xfrac;
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 12: {
                if (this.dataINT) {
                    long s1L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits);
                    return (int)(s1L * (long)yfrac + (long)this.round2 >> this.shift2);
                }
                int s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                return s1 * yfrac + this.round2 >> this.shift2;
            }
            case 13: {
                if (this.dataINT) {
                    long s1L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits);
                    long s0L = s00 * xfracCompl;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s00 * xfracCompl;
                int s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 14: {
                if (this.dataINT) {
                    long s1L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits);
                    long s0L = s01 * xfrac;
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = s01 * xfrac;
                int s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
            case 15: {
                if (this.dataINT) {
                    long s1L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits);
                    long s0L = (s00 | s10) >>> this.shift == 0 ? ((s01 | s11) >>> this.shift == 0 ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits);
                    return (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
                int s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                int s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                return (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
            }
        }
        throw new IllegalArgumentException("Wrong Number of No Data");
    }

    private int computeValue(int s00, int s01, int s10, int s11, int w00, int w01, int w10, int w11, int xfrac, int yfrac) {
        boolean dataINT;
        int shift;
        boolean w1z;
        int s0 = 0;
        int s1 = 0;
        int s = 0;
        long s0L = 0L;
        long s1L = 0L;
        int xfracCompl = this.one - xfrac;
        int yfracCompl = this.one - yfrac;
        boolean w00z = w00 == 0;
        boolean w01z = w01 == 0;
        boolean w10z = w10 == 0;
        boolean w11z = w11 == 0;
        boolean w0z = w00z && w01z;
        boolean bl = w1z = w10z && w11z;
        if (w0z && w1z) {
            switch (this.dataType) {
                case 0: {
                    return this.destinationNoDataByte;
                }
                case 1: {
                    return this.destinationNoDataUShort;
                }
                case 2: {
                    return this.destinationNoDataShort;
                }
                case 3: {
                    return this.destinationNoDataInt;
                }
            }
        }
        boolean s0Long = (s00 | s10) >>> (shift = 29 - this.subsampleBits) == 0;
        boolean s1Long = (s01 | s11) >>> shift == 0;
        boolean bl2 = dataINT = this.dataType == 3;
        if (w00z || w01z || w10z || w11z) {
            if (dataINT) {
                s0L = w0z ? 0L : (w00z ? (long)(s01 * xfrac) : (w01z ? (long)(s00 * xfracCompl) : (s0Long ? (s1Long ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits)) : (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits))));
                s1L = w1z ? 0L : (w10z ? (long)(s11 * xfrac) : (w11z ? (long)(s10 * xfracCompl) : (s0Long ? (s1Long ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits)) : (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits))));
                s = w0z ? (int)(s1L * (long)yfrac + (long)this.round2 >> this.shift2) : (w1z ? (int)(s0L * (long)yfracCompl + (long)this.round2 >> this.shift2) : (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2));
            } else {
                s0 = w0z ? 0 : (w00z ? s01 * xfrac : (w01z ? s00 * xfracCompl : (s01 - s00) * xfrac + (s00 << this.subsampleBits)));
                s1 = w1z ? 0 : (w10z ? s11 * xfrac : (w11z ? s10 * xfracCompl : (s11 - s10) * xfrac + (s10 << this.subsampleBits)));
                s = w0z ? s1 * yfrac + this.round2 >> this.shift2 : (w1z ? s0 * yfracCompl + this.round2 >> this.shift2 : (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2);
            }
        } else if (dataINT) {
            if (s0Long) {
                if (s1Long) {
                    s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                    s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                    s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                } else {
                    s0L = (1L * (long)s01 - (long)s00) * (long)xfrac + (long)(s00 << this.subsampleBits);
                    s1L = (1L * (long)s11 - (long)s10) * (long)xfrac + (long)(s10 << this.subsampleBits);
                    s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
            } else {
                s0L = (1L * (long)s01 - (long)s00) * (long)xfrac + (1L * (long)s00 << this.subsampleBits);
                s1L = (1L * (long)s11 - (long)s10) * (long)xfrac + (1L * (long)s10 << this.subsampleBits);
                s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
            }
        } else {
            s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
            s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
            s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
        }
        return s;
    }

    private double computeValueDouble(double s00, double s01, double s10, double s11, double w00, double w01, double w10, double w11, double xfrac, double yfrac, int dataType) {
        double s0 = 0.0;
        double s1 = 0.0;
        double s = 0.0;
        double xfracCompl = 1.0 - xfrac;
        double yfracCompl = 1.0 - yfrac;
        if (w00 == 0.0 && w01 == 0.0 && w10 == 0.0 && w11 == 0.0) {
            switch (dataType) {
                case 4: {
                    return this.destinationNoDataFloat;
                }
                case 5: {
                    return this.destinationNoDataDouble;
                }
            }
        }
        if (w00 == 0.0 || w01 == 0.0 || w10 == 0.0 || w11 == 0.0) {
            s0 = w00 == 0.0 && w01 == 0.0 ? 0.0 : (w00 == 0.0 ? s01 * xfrac : (w01 == 0.0 ? s00 * xfracCompl : (s01 - s00) * xfrac + s00));
            s1 = w10 == 0.0 && w11 == 0.0 ? 0.0 : (w10 == 0.0 ? s11 * xfrac : (w11 == 0.0 ? s10 * xfracCompl : (s11 - s10) * xfrac + s10));
            s = w00 == 0.0 && w01 == 0.0 ? s1 * yfrac : (w10 == 0.0 && w11 == 0.0 ? s0 * yfracCompl : (s1 - s0) * yfrac + s0);
        } else {
            s0 = (s01 - s00) * xfrac + s00;
            s1 = (s11 - s10) * xfrac + s10;
            s = (s1 - s0) * yfrac + s0;
        }
        return s;
    }
}

