/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationBicubic;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class ScaleBicubicOpImage
extends ScaleOpImage {
    protected InterpolationBicubic interpBN = null;
    private int[] dataHi;
    private int[] dataVi;
    private float[] dataHf;
    private float[] dataVf;
    private double[] dataHd;
    private double[] dataVd;
    private final byte[] byteLookupTable = new byte[256];

    public ScaleBicubicOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        Range nod = nodata;
        Double destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues[0];
        }
        if (this.interpolator instanceof InterpolationBicubic) {
            this.isBicubicNew = true;
            this.interpBN = (InterpolationBicubic)this.interpolator;
            this.interp = this.interpBN;
            switch (srcDataType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.dataHi = this.interpBN.getHorizontalTableData();
                    this.dataVi = this.interpBN.getVerticalTableData();
                    break;
                }
                case 4: {
                    this.dataHf = this.interpBN.getHorizontalTableDataFloat();
                    this.dataVf = this.interpBN.getVerticalTableDataFloat();
                    break;
                }
                case 5: {
                    this.dataHd = this.interpBN.getHorizontalTableDataDouble();
                    this.dataVd = this.interpBN.getVerticalTableDataDouble();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Wrong data Type");
                }
            }
            this.interpBN.setROIdata(this.roiBounds, this.roiIter);
            this.noData = this.interpBN.getNoDataRange();
            this.precisionBits = this.interpBN.getPrecisionBits();
            if (nod == null) {
                nod = this.interpBN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = this.interpBN.getDestinationNoData();
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues[0];
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        if (this.precisionBits > 0) {
            this.round = 1 << this.precisionBits - 1;
        }
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        switch (srcDataType) {
            case 0: {
                this.destinationNoDataByte = (byte)((byte)this.destinationNoDataDouble & 0xFF);
                if (!this.hasNoData) break;
                for (int i = 0; i < this.byteLookupTable.length; ++i) {
                    byte value = (byte)i;
                    this.byteLookupTable[i] = this.noData.contains(value) ? this.destinationNoDataByte : value;
                }
                break;
            }
            case 1: {
                this.destinationNoDataUShort = (short)((short)this.destinationNoDataDouble & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = (short)this.destinationNoDataDouble;
                break;
            }
            case 3: {
                this.destinationNoDataInt = (int)this.destinationNoDataDouble;
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)this.destinationNoDataDouble;
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources, dest, destRect, null);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect, Raster[] rois) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        if (this.useRoiAccessor) {
            roi = rois[0];
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            roiScanlineStride = roiAccessor.getScanlineStride();
            yposRoi = new int[dheight];
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        this.dataType = dest.getSampleModel().getDataType();
        this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        switch (this.dataType) {
            case 0: {
                this.byteLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, xfracValues, yfracValues, roiAccessor, yposRoi, roiScanlineStride);
            }
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                        }
                        s = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s > 255) {
                            s = 255;
                        } else if (s < 0) {
                            s = 0;
                        }
                        dstData[dstPixelOffset] = (byte)(s & 0xFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataByte;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > 255) {
                                        s = 255;
                                    } else if (s < 0) {
                                        s = 0;
                                    }
                                    dstData[dstPixelOffset] = (byte)(s & 0xFF);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataByte;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > 255) {
                                        s = 255;
                                    } else if (s < 0) {
                                        s = 0;
                                    }
                                    dstData[dstPixelOffset] = (byte)(s & 0xFF);
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            long[] emptyArray = new long[4];
            long tempSum = 0L;
            long sum = 0L;
            byte temp = 0;
            int s = 0;
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                weight = this.byteLookupTable[(int)pixelKernel[h][z]] != this.destinationNoDataByte ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        } else {
                            weight = 0;
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weightVert = 0;
                            tempSum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            if (s > 255) {
                                s = 255;
                            } else if (s < 0) {
                                s = 0;
                            }
                            dstData[dstPixelOffset] = (byte)(s & 0xFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long[] emptyArray = new long[4];
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (byte)(roiDataArray[index] & 0xFF) != 0 ? 1 : 0;
                                    }
                                    weight = this.byteLookupTable[(int)pixelKernel[h][z]] != this.destinationNoDataByte ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weightVert = 0;
                                weight = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > 255) {
                                    s = 255;
                                } else if (s < 0) {
                                    s = 0;
                                }
                                dstData[dstPixelOffset] = (byte)(s & 0xFF);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long[] emptyArray = new long[4];
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFF;
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFF;
                                    weight = this.byteLookupTable[(int)pixelKernel[h][z]] != this.destinationNoDataByte ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataByte;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > 255) {
                                    s = 255;
                                } else if (s < 0) {
                                    s = 0;
                                }
                                dstData[dstPixelOffset] = (byte)(s & 0xFF);
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                        }
                        s = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s > 65536) {
                            s = 65536;
                        } else if (s < 0) {
                            s = 0;
                        }
                        dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (short)(roiDataArray[index] & 0xFFFF) != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataUShort;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > 65536) {
                                        s = 65536;
                                    } else if (s < 0) {
                                        s = 0;
                                    }
                                    dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFFFF;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataUShort;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > 65536) {
                                        s = 65536;
                                    } else if (s < 0) {
                                        s = 0;
                                    }
                                    dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        } else {
                            temp = 0;
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            if (s > 65536) {
                                s = 65536;
                            } else if (s < 0) {
                                s = 0;
                            }
                            dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (short)(roiDataArray[index] & 0xFFFF) != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > 65536) {
                                    s = 65536;
                                } else if (s < 0) {
                                    s = 0;
                                }
                                dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride] & 0xFFFF;
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0) & 0xFFFF;
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataUShort;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > 65536) {
                                    s = 65536;
                                } else if (s < 0) {
                                    s = 0;
                                }
                                dstData[dstPixelOffset] = (short)(s & 0xFFFF);
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                short pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                        }
                        s = (int)(sum + (long)this.round >> this.precisionBits);
                        if (s > Short.MAX_VALUE) {
                            s = Short.MAX_VALUE;
                        } else if (s < Short.MIN_VALUE) {
                            s = Short.MIN_VALUE;
                        }
                        dstData[dstPixelOffset] = (short)s;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += (short)roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataShort;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > Short.MAX_VALUE) {
                                        s = Short.MAX_VALUE;
                                    } else if (s < Short.MIN_VALUE) {
                                        s = Short.MIN_VALUE;
                                    }
                                    dstData[dstPixelOffset] = (short)s;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    short[] srcData = srcDataArrays[k];
                    short[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataShort;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    s = (int)(sum + (long)this.round >> this.precisionBits);
                                    if (s > Short.MAX_VALUE) {
                                        s = Short.MAX_VALUE;
                                    } else if (s < Short.MIN_VALUE) {
                                        s = Short.MIN_VALUE;
                                    }
                                    dstData[dstPixelOffset] = (short)s;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else {
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            if (s > Short.MAX_VALUE) {
                                s = Short.MAX_VALUE;
                            } else if (s < Short.MIN_VALUE) {
                                s = Short.MIN_VALUE;
                            }
                            dstData[dstPixelOffset] = (short)s;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += (short)roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > Short.MAX_VALUE) {
                                    s = Short.MAX_VALUE;
                                } else if (s < Short.MIN_VALUE) {
                                    s = Short.MIN_VALUE;
                                }
                                dstData[dstPixelOffset] = (short)s;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                short[] srcData = srcDataArrays[k];
                short[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    weight = !this.noData.contains((short)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataShort;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                s = (int)(sum + (long)this.round >> this.precisionBits);
                                if (s > Short.MAX_VALUE) {
                                    s = Short.MAX_VALUE;
                                } else if (s < Short.MIN_VALUE) {
                                    s = Short.MIN_VALUE;
                                }
                                dstData[dstPixelOffset] = (short)s;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        long sum = 0L;
                        int s = 0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            long temp = 0L;
                            for (int z = 0; z < 4; ++z) {
                                int pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                temp += (long)(pixelValue * this.dataHi[offsetX + z]);
                            }
                            sum += (temp + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                        }
                        dstData[dstPixelOffset] = s = (int)(sum + (long)this.round >> this.precisionBits);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int[][] pixelKernel = new int[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataInt;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    dstData[dstPixelOffset] = s = (int)(sum + (long)this.round >> this.precisionBits);
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    int[] srcData = srcDataArrays[k];
                    int[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            int[][] pixelKernel = new int[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataInt;
                                } else {
                                    long sum = 0L;
                                    int s = 0;
                                    for (int h = 0; h < 4; ++h) {
                                        long tempSum = 0L;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (long)(pixelKernel[h][z] * this.dataHi[offsetX + z]);
                                        }
                                        sum += (tempSum + (long)this.round >> this.precisionBits) * (long)this.dataVi[offsetY + h];
                                    }
                                    dstData[dstPixelOffset] = s = (int)(sum + (long)this.round >> this.precisionBits);
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            long tempSum = 0L;
            long sum = 0L;
            int s = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * (long)this.dataHi[offsetX] + tempData[1] * (long)this.dataHi[offsetX + 1] + tempData[2] * (long)this.dataHi[offsetX + 2] + tempData[3] * (long)this.dataHi[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else {
                            long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (long)this.dataVi[offsetY] + tempData[1] * (long)this.dataVi[offsetY + 1] + tempData[2] * (long)this.dataVi[offsetY + 2] + tempData[3] * (long)this.dataVi[offsetY + 3];
                            s = (int)(sum + (long)this.round >> this.precisionBits);
                            sum = 0L;
                            dstData[dstPixelOffset] = s;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                dstData[dstPixelOffset] = s = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            long[][] pixelKernel = new long[4][4];
            long[] sumArray = new long[4];
            long[] emptyArray = new long[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                int[] srcData = srcDataArrays[k];
                int[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    weight = !this.noData.contains((int)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataInt;
                            } else {
                                long sum = 0L;
                                int s = 0;
                                for (int h = 0; h < 4; ++h) {
                                    long tempSum = 0L;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    long[] tempData = this.bicubicInpainting(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (long)this.dataHi[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum + (long)this.round >> this.precisionBits;
                                }
                                long[] tempData = this.bicubicInpainting(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (long)this.dataVi[offsetY + h];
                                }
                                dstData[dstPixelOffset] = s = (int)(sum + (long)this.round >> this.precisionBits);
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double sum = 0.0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            double temp = 0.0;
                            for (int z = 0; z < 4; ++z) {
                                float pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                temp += (double)(pixelValue * this.dataHf[offsetX + z]);
                            }
                            sum += temp * (double)this.dataVf[offsetY + h];
                        }
                        if (sum > 3.4028234663852886E38) {
                            sum = 3.4028234663852886E38;
                        } else if (sum < -3.4028234663852886E38) {
                            sum = -3.4028234663852886E38;
                        }
                        dstData[dstPixelOffset] = (float)sum;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            float[][] pixelKernel = new float[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataFloat;
                                } else {
                                    double sum = 0.0;
                                    for (int h = 0; h < 4; ++h) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (double)(pixelKernel[h][z] * this.dataHf[offsetX + z]);
                                        }
                                        sum += tempSum * (double)this.dataVf[offsetY + h];
                                    }
                                    if (sum > 3.4028234663852886E38) {
                                        sum = 3.4028234663852886E38;
                                    } else if (sum < -3.4028234663852886E38) {
                                        sum = -3.4028234663852886E38;
                                    }
                                    dstData[dstPixelOffset] = (float)sum;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    float[] srcData = srcDataArrays[k];
                    float[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            float[][] pixelKernel = new float[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataFloat;
                                } else {
                                    double sum = 0.0;
                                    for (int h = 0; h < 4; ++h) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += (double)(pixelKernel[h][z] * this.dataHf[offsetX + z]);
                                        }
                                        sum += tempSum * (double)this.dataVf[offsetY + h];
                                    }
                                    if (sum > 3.4028234663852886E38) {
                                        sum = 3.4028234663852886E38;
                                    } else if (sum < -3.4028234663852886E38) {
                                        sum = -3.4028234663852886E38;
                                    }
                                    dstData[dstPixelOffset] = (float)sum;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                weight = !this.noData.contains((float)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * (double)this.dataHf[offsetX] + tempData[1] * (double)this.dataHf[offsetX + 1] + tempData[2] * (double)this.dataHf[offsetX + 2] + tempData[3] * (double)this.dataHf[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        } else {
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            sum = tempData[0] * (double)this.dataVf[offsetY] + tempData[1] * (double)this.dataVf[offsetY + 1] + tempData[2] * (double)this.dataVf[offsetY + 2] + tempData[3] * (double)this.dataVf[offsetY + 3];
                            if (sum > 3.4028234663852886E38) {
                                sum = 3.4028234663852886E38;
                            } else if (sum < -3.4028234663852886E38) {
                                sum = -3.4028234663852886E38;
                            }
                            dstData[dstPixelOffset] = (float)sum;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains((float)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            } else {
                                double sum = 0.0;
                                for (int h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (double)this.dataVf[offsetY + h];
                                }
                                if (sum > 3.4028234663852886E38) {
                                    sum = 3.4028234663852886E38;
                                } else if (sum < -3.4028234663852886E38) {
                                    sum = -3.4028234663852886E38;
                                }
                                dstData[dstPixelOffset] = (float)sum;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                float[] srcData = srcDataArrays[k];
                float[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    weight = !this.noData.contains((float)pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataFloat;
                            } else {
                                double sum = 0.0;
                                for (int h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * (double)this.dataHf[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * (double)this.dataVf[offsetY + h];
                                }
                                if (sum > 3.4028234663852886E38) {
                                    sum = 3.4028234663852886E38;
                                } else if (sum < -3.4028234663852886E38) {
                                    sum = -3.4028234663852886E38;
                                }
                                dstData[dstPixelOffset] = (float)sum;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, int[] xfrac, int[] yfrac, RasterAccessor roi, int[] yposRoi, int roiScanlineStride) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double sum = 0.0;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            double temp = 0.0;
                            for (int z = 0; z < 4; ++z) {
                                double pixelValue = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                temp += pixelValue * this.dataHd[offsetX + z];
                            }
                            sum += temp * this.dataVd[offsetY + h];
                        }
                        dstData[dstPixelOffset] = sum;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            double[][] pixelKernel = new double[4][4];
                            int baseIndex = posx / dnumBands + yposRoi[j];
                            if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            } else {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                        if (index >= roiDataLength) continue;
                                        temp += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataDouble;
                                } else {
                                    double sum = 0.0;
                                    for (int h = 0; h < 4; ++h) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += pixelKernel[h][z] * this.dataHd[offsetX + z];
                                        }
                                        sum += tempSum * this.dataVd[offsetY + h];
                                    }
                                    dstData[dstPixelOffset] = sum;
                                }
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    double[] srcData = srcDataArrays[k];
                    double[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int offsetY = 4 * yfrac[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            int y0 = src.getY() + (posy - bandOffset) / srcScanlineStride;
                            double[][] pixelKernel = new double[4][4];
                            if (this.roiBounds.contains(x0, y0)) {
                                int temp = 0;
                                int offsetX = 4 * xfrac[i];
                                for (int h = 0; h < 4; ++h) {
                                    for (int z = 0; z < 4; ++z) {
                                        pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                        temp += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    }
                                }
                                if (temp == 0) {
                                    dstData[dstPixelOffset] = this.destinationNoDataDouble;
                                } else {
                                    double sum = 0.0;
                                    for (int h = 0; h < 4; ++h) {
                                        double tempSum = 0.0;
                                        for (int z = 0; z < 4; ++z) {
                                            tempSum += pixelKernel[h][z] * this.dataHd[offsetX + z];
                                        }
                                        sum += tempSum * this.dataVd[offsetY + h];
                                    }
                                    dstData[dstPixelOffset] = sum;
                                }
                            } else {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            }
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            double tempSum = 0.0;
            double sum = 0.0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int offsetX = 4 * xfrac[i];
                        for (int h = 0; h < 4; ++h) {
                            for (int z = 0; z < 4; ++z) {
                                pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                weight = !this.noData.contains(pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                            }
                            temp = (byte)(weight >> 4 * h & 0xF);
                            double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                            tempSum = tempData[0] * this.dataHd[offsetX] + tempData[1] * this.dataHd[offsetX + 1] + tempData[2] * this.dataHd[offsetX + 2] + tempData[3] * this.dataHd[offsetX + 3];
                            weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                            sumArray[h] = tempSum;
                        }
                        if (weight == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        } else {
                            double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                            weight = 0;
                            weightVert = 0;
                            dstData[dstPixelOffset] = sum = tempData[0] * this.dataVd[offsetY] + tempData[1] * this.dataVd[offsetY + 1] + tempData[2] * this.dataVd[offsetY + 2] + tempData[3] * this.dataVd[offsetY + 3];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int baseIndex = posx / dnumBands + yposRoi[j];
                        if (baseIndex > roiDataLength || roiDataArray[baseIndex] == 0) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        } else {
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    int index = baseIndex - 1 + z + (h - 1) * roiScanlineStride;
                                    if (index < roiDataLength) {
                                        tempROI += roiDataArray[index] != 0 ? 1 : 0;
                                    }
                                    weight = !this.noData.contains(pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            } else {
                                double sum = 0.0;
                                for (int h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * this.dataHd[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * this.dataVd[offsetY + h];
                                }
                                dstData[dstPixelOffset] = sum;
                            }
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            double[][] pixelKernel = new double[4][4];
            double[] sumArray = new double[4];
            double[] emptyArray = new double[4];
            int weight = 0;
            int weightVert = 0;
            byte temp = 0;
            for (int k = 0; k < dnumBands; ++k) {
                double[] srcData = srcDataArrays[k];
                double[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int offsetY = 4 * yfrac[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int y0;
                        int posx = xpos[i];
                        int x0 = src.getX() + posx / srcPixelStride;
                        if (this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride)) {
                            int pos = posx + posy;
                            int tempROI = 0;
                            int offsetX = 4 * xfrac[i];
                            for (int h = 0; h < 4; ++h) {
                                for (int z = 0; z < 4; ++z) {
                                    pixelKernel[h][z] = srcData[pos + (z - 1) * srcPixelStride + (h - 1) * srcScanlineStride];
                                    tempROI += this.roiIter.getSample(x0 + h - 1, y0 + z - 1, 0);
                                    weight = !this.noData.contains(pixelKernel[h][z]) ? (int)((short)(weight | 1 << 4 * h + z)) : (int)((short)(weight & 65535 - (1 << 4 * h + z)));
                                }
                            }
                            if (weight == 0 || tempROI == 0) {
                                dstData[dstPixelOffset] = this.destinationNoDataDouble;
                            } else {
                                double sum = 0.0;
                                for (int h = 0; h < 4; ++h) {
                                    double tempSum = 0.0;
                                    temp = (byte)(weight >> 4 * h & 0xF);
                                    double[] tempData = this.bicubicInpaintingDouble(pixelKernel[h], temp, emptyArray);
                                    for (int z = 0; z < 4; ++z) {
                                        tempSum += tempData[z] * this.dataHd[offsetX + z];
                                    }
                                    weightVert = temp > 0 ? (int)((byte)(weightVert | 1 << h)) : (int)((byte)(weightVert & 15 - (1 << h)));
                                    sumArray[h] = tempSum;
                                }
                                double[] tempData = this.bicubicInpaintingDouble(sumArray, (short)weightVert, emptyArray);
                                weight = 0;
                                weightVert = 0;
                                for (int h = 0; h < 4; ++h) {
                                    sum += tempData[h] * this.dataVd[offsetY + h];
                                }
                                dstData[dstPixelOffset] = sum;
                            }
                        } else {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private long[] bicubicInpainting(long[] array, short weightSum, long[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        long s_ = array[0];
        long s0 = array[1];
        long s1 = array[2];
        long s2 = array[3];
        emptyArray[0] = 0L;
        emptyArray[1] = 0L;
        emptyArray[2] = 0L;
        emptyArray[3] = 0L;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2L;
                emptyArray[2] = (s_ + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2L;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2L;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }

    private double[] bicubicInpaintingDouble(double[] array, short weightSum, double[] emptyArray) {
        if (weightSum == 15) {
            return array;
        }
        double s_ = array[0];
        double s0 = array[1];
        double s1 = array[2];
        double s2 = array[3];
        emptyArray[0] = 0.0;
        emptyArray[1] = 0.0;
        emptyArray[2] = 0.0;
        emptyArray[3] = 0.0;
        switch (weightSum) {
            case 0: {
                break;
            }
            case 1: {
                emptyArray[0] = s_;
                emptyArray[1] = s_;
                emptyArray[2] = s_;
                emptyArray[3] = s_;
                break;
            }
            case 2: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 3: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s0;
                emptyArray[3] = s0;
                break;
            }
            case 4: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 5: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 6: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 7: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s1;
                break;
            }
            case 8: {
                emptyArray[0] = s2;
                emptyArray[1] = s2;
                emptyArray[2] = s2;
                emptyArray[3] = s2;
                break;
            }
            case 9: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s2) / 2.0;
                emptyArray[2] = (s_ + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 10: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 11: {
                emptyArray[0] = s_;
                emptyArray[1] = s0;
                emptyArray[2] = (s0 + s2) / 2.0;
                emptyArray[3] = s2;
                break;
            }
            case 12: {
                emptyArray[0] = s1;
                emptyArray[1] = s1;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 13: {
                emptyArray[0] = s_;
                emptyArray[1] = (s_ + s1) / 2.0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            case 14: {
                emptyArray[0] = s0;
                emptyArray[1] = s0;
                emptyArray[2] = s1;
                emptyArray[3] = s2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Array cannot be composed from more than 4 elements");
            }
        }
        return emptyArray;
    }
}

