/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.scale;

import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.scale.ScaleOpImage;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class ScaleNearestOpImage
extends ScaleOpImage {
    protected InterpolationNearest interpN = null;
    protected final byte[] byteLookupTable = new byte[256];

    public ScaleNearestOpImage(RenderedImage source, ImageLayout layout, Map configuration, BorderExtender extender, Interpolation interp, float scaleX, float scaleY, float transX, float transY, boolean useRoiAccessor, Range nodata, double[] backgroundValues) {
        super(source, layout, configuration, true, extender, interp, scaleX, scaleY, transX, transY, useRoiAccessor, backgroundValues);
        this.scaleOpInitialization(source, interp, nodata, backgroundValues, useRoiAccessor);
    }

    private void scaleOpInitialization(RenderedImage source, Interpolation interp, Range nodata, double[] backgroundValues, boolean useRoiAccessor) {
        ColorModel srcColorModel = source.getColorModel();
        if (srcColorModel instanceof IndexColorModel) {
            this.sampleModel = source.getSampleModel().createCompatibleSampleModel(this.tileWidth, this.tileHeight);
            this.colorModel = srcColorModel;
        }
        SampleModel sm = source.getSampleModel();
        int srcDataType = sm.getDataType();
        if (this.invScaleXRational.num > this.invScaleXRational.denom) {
            this.invScaleXInt = this.invScaleXRational.num / this.invScaleXRational.denom;
            this.invScaleXFrac = this.invScaleXRational.num % this.invScaleXRational.denom;
        } else {
            this.invScaleXInt = 0L;
            this.invScaleXFrac = this.invScaleXRational.num;
        }
        if (this.invScaleYRational.num > this.invScaleYRational.denom) {
            this.invScaleYInt = this.invScaleYRational.num / this.invScaleYRational.denom;
            this.invScaleYFrac = this.invScaleYRational.num % this.invScaleYRational.denom;
        } else {
            this.invScaleYInt = 0L;
            this.invScaleYFrac = this.invScaleYRational.num;
        }
        this.interpolator = interp;
        Range nod = nodata;
        Double destNod = null;
        if (backgroundValues != null && backgroundValues.length > 0) {
            destNod = backgroundValues[0];
        }
        if (interp instanceof InterpolationNearest) {
            this.interpN = (InterpolationNearest)interp;
            this.interp = this.interpN;
            this.interpN.setROIdata(this.roiBounds, this.roiIter);
            if (nod == null) {
                nod = this.interpN.getNoDataRange();
            }
            if (destNod == null) {
                destNod = this.interpN.getDestinationNoData();
            }
        }
        if (nod != null) {
            this.hasNoData = true;
            this.noData = nod;
        }
        if (destNod != null) {
            this.destinationNoDataDouble = destNod;
        } else if (this.backgroundValues != null && this.backgroundValues.length > 0) {
            this.destinationNoDataDouble = this.backgroundValues[0];
        }
        if (this.hasROI) {
            this.useRoiAccessor = useRoiAccessor;
        }
        this.subsampleBits = interp.getSubsampleBitsH();
        this.one = 1 << this.subsampleBits;
        this.shift2 = 2 * this.subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        this.one = 1 << this.subsampleBits;
        this.interp_width = interp.getWidth();
        this.interp_height = interp.getHeight();
        this.interp_left = interp.getLeftPadding();
        this.interp_top = interp.getTopPadding();
        switch (srcDataType) {
            case 0: {
                this.destinationNoDataByte = (byte)((byte)this.destinationNoDataDouble & 0xFF);
                if (!this.hasNoData) break;
                for (int i = 0; i < this.byteLookupTable.length; ++i) {
                    byte value = (byte)i;
                    this.byteLookupTable[i] = this.noData.contains(value) ? this.destinationNoDataByte : value;
                }
                break;
            }
            case 1: {
                this.destinationNoDataUShort = (short)((short)this.destinationNoDataDouble & 0xFFFF);
                break;
            }
            case 2: {
                this.destinationNoDataShort = (short)this.destinationNoDataDouble;
                break;
            }
            case 3: {
                this.destinationNoDataInt = (int)this.destinationNoDataDouble;
                break;
            }
            case 4: {
                this.destinationNoDataFloat = (float)this.destinationNoDataDouble;
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Wrong data Type");
            }
        }
        this.caseA = !this.hasROI && !this.hasNoData;
        this.caseB = this.hasROI && !this.hasNoData;
        this.caseC = !this.hasROI && this.hasNoData;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.computeRect(sources, dest, destRect, null);
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect, Raster[] rois) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = source.getBounds();
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        int dwidth = destRect.width;
        int dheight = destRect.height;
        int srcPixelStride = srcAccessor.getPixelStride();
        int srcScanlineStride = srcAccessor.getScanlineStride();
        int[] xpos = new int[dwidth];
        int[] ypos = new int[dheight];
        int[] yposRoi = null;
        int roiScanlineStride = 0;
        RasterAccessor roiAccessor = null;
        Raster roi = null;
        if (this.useRoiAccessor) {
            roi = rois[0];
            roiAccessor = new RasterAccessor(roi, srcRect, RasterAccessor.findCompatibleTags((RenderedImage[])new RenderedImage[]{this.srcROIImage}, (RenderedImage)this.srcROIImage)[0], this.srcROIImage.getColorModel());
            roiScanlineStride = roiAccessor.getScanlineStride();
            yposRoi = new int[dheight];
        }
        int[] xfracValues = new int[dwidth];
        int[] yfracValues = new int[dheight];
        this.preComputePositionsInt(destRect, srcRect.x, srcRect.y, srcPixelStride, srcScanlineStride, xpos, ypos, xfracValues, yfracValues, roiScanlineStride, yposRoi);
        this.dataType = dest.getSampleModel().getDataType();
        switch (this.dataType) {
            case 0: {
                this.byteLoop(srcAccessor, srcRect, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, destRect, dstAccessor, xpos, ypos, roiAccessor, yposRoi);
            }
        }
    }

    private void byteLoop(RasterAccessor src, Rectangle srcRect, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int roiDataLength;
        byte[] roiDataArray;
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        } else {
            roiDataArray = null;
            roiDataLength = 0;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    byte[] srcData = srcDataArrays[k];
                    byte[] dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte : srcData[pos]) : this.destinationNoDataByte;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        dstData[dstPixelOffset] = this.byteLookupTable[value & 0xFF];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        if (this.byteLookupTable[value & 0xFF] == this.destinationNoDataByte) {
                            dstData[dstPixelOffset] = this.destinationNoDataByte;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataByte : this.byteLookupTable[value & 0xFF];
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                byte[] srcData = srcDataArrays[k];
                byte[] dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        byte value = srcData[pos];
                        dstData[dstPixelOffset] = this.byteLookupTable[value & 0xFF] == this.destinationNoDataByte ? this.destinationNoDataByte : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFF) == 0 ? this.destinationNoDataByte : this.byteLookupTable[value & 0xFF]) : this.destinationNoDataByte);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void ushortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFFFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFFFF) == 0 ? this.destinationNoDataUShort : srcData[pos]) : this.destinationNoDataUShort;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataUShort : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataUShort;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            int w = windex < roiDataLength ? roiDataArray[windex] & 0xFFFF : 0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataUShort : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataUShort : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0) & 0xFFFF) == 0 ? this.destinationNoDataUShort : value) : this.destinationNoDataUShort);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void shortLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[] dstData = null;
        short[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataShort : srcData[pos]) : this.destinationNoDataShort;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataShort;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataShort : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        short value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataShort : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataShort : value) : this.destinationNoDataShort);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void intLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[] dstData = null;
        int[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataInt : srcData[pos]) : this.destinationNoDataInt;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataInt;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataInt : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        int value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataInt : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataInt : value) : this.destinationNoDataInt);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void floatLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        float[] dstData = null;
        float[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataFloat : srcData[pos]) : this.destinationNoDataFloat;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataFloat;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataFloat : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        float value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataFloat : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataFloat : value) : this.destinationNoDataFloat);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }

    private void doubleLoop(RasterAccessor src, Rectangle dstRect, RasterAccessor dst, int[] xpos, int[] ypos, RasterAccessor roi, int[] yposRoi) {
        int srcScanlineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] bandOffsets = src.getBandOffsets();
        int dwidth = dstRect.width;
        int dheight = dstRect.height;
        int dnumBands = dst.getNumBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[] dstData = null;
        double[] srcData = null;
        byte[] roiDataArray = null;
        int roiDataLength = 0;
        if (this.useRoiAccessor) {
            roiDataArray = roi.getByteDataArray(0);
            roiDataLength = roiDataArray.length;
        }
        if (this.caseA) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        dstData[dstPixelOffset] = srcData[pos];
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.caseB) {
            if (this.useRoiAccessor) {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        int posyROI = yposRoi[j];
                        for (int i = 0; i < dwidth; ++i) {
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : srcData[pos];
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            } else {
                for (int k = 0; k < dnumBands; ++k) {
                    srcData = srcDataArrays[k];
                    dstData = dstDataArrays[k];
                    int dstlineOffset = dstBandOffsets[k];
                    int bandOffset = bandOffsets[k];
                    for (int j = 0; j < dheight; ++j) {
                        int dstPixelOffset = dstlineOffset;
                        int posy = ypos[j] + bandOffset;
                        for (int i = 0; i < dwidth; ++i) {
                            int w;
                            int y0;
                            int posx = xpos[i];
                            int pos = posx + posy;
                            int x0 = src.getX() + posx / srcPixelStride;
                            dstData[dstPixelOffset] = this.roiBounds.contains(x0, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataDouble : srcData[pos]) : this.destinationNoDataDouble;
                            dstPixelOffset += dstPixelStride;
                        }
                        dstlineOffset += dstScanlineStride;
                    }
                }
            }
        } else if (this.caseC) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : value;
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else if (this.useRoiAccessor) {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    int posyROI = yposRoi[j];
                    for (int i = 0; i < dwidth; ++i) {
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        if (this.noData.contains(value)) {
                            dstData[dstPixelOffset] = this.destinationNoDataDouble;
                        } else {
                            int windex = posx / dnumBands + posyROI;
                            byte w = windex < roiDataLength ? roiDataArray[windex] : (byte)0;
                            dstData[dstPixelOffset] = w == 0 ? this.destinationNoDataDouble : value;
                        }
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        } else {
            for (int k = 0; k < dnumBands; ++k) {
                srcData = srcDataArrays[k];
                dstData = dstDataArrays[k];
                int dstlineOffset = dstBandOffsets[k];
                int bandOffset = bandOffsets[k];
                for (int j = 0; j < dheight; ++j) {
                    int dstPixelOffset = dstlineOffset;
                    int posy = ypos[j] + bandOffset;
                    for (int i = 0; i < dwidth; ++i) {
                        int w;
                        int y0;
                        int x0;
                        int posx = xpos[i];
                        int pos = posx + posy;
                        double value = srcData[pos];
                        dstData[dstPixelOffset] = this.noData.contains(value) ? this.destinationNoDataDouble : (this.roiBounds.contains(x0 = src.getX() + posx / srcPixelStride, y0 = src.getY() + (posy - bandOffset) / srcScanlineStride) ? ((w = this.roiIter.getSample(x0, y0, 0)) == 0 ? this.destinationNoDataDouble : value) : this.destinationNoDataDouble);
                        dstPixelOffset += dstPixelStride;
                    }
                    dstlineOffset += dstScanlineStride;
                }
            }
        }
    }
}

